/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityAssignment;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheEntryInfoCollection;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheMetricsImpl;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryEx;
import org.apache.ignite.internal.processors.cache.GridCacheEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheMvccEntryInfo;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.WalStateManager;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.CachePartitionPartialCountersMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionDemandMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionSupplyMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloader;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPreloaderAssignments;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.IgniteDhtDemandedPartitionsMap;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtInvalidPartitionException;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.CheckpointState;
import org.apache.ignite.internal.processors.cache.persistence.checkpoint.CheckpointProgress;
import org.apache.ignite.internal.processors.dr.GridDrType;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.metric.impl.MetricUtils;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObject;
import org.apache.ignite.internal.processors.timeout.GridTimeoutObjectAdapter;
import org.apache.ignite.internal.util.GridMutableLong;
import org.apache.ignite.internal.util.collection.IntHashMap;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFinishedFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.lang.GridIterableAdapter;
import org.apache.ignite.internal.util.lang.IgnitePredicateX;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.CI1;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.lang.IgnitePredicate;
import org.apache.ignite.spi.IgniteSpiException;
import org.jetbrains.annotations.Nullable;

public class GridDhtPartitionDemander {
    private final GridCacheSharedContext<?, ?> ctx;
    private final CacheGroupContext grp;
    private final IgniteLogger log;
    @GridToStringInclude
    private final GridFutureAdapter syncFut = new GridFutureAdapter();
    @GridToStringInclude
    private volatile RebalanceFuture rebalanceFut;
    private AtomicReference<GridTimeoutObject> lastTimeoutObj = new AtomicReference();
    private volatile GridDhtPartitionsExchangeFuture lastExchangeFut;
    private final AtomicLong lastCancelledTime = new AtomicLong(-1L);

    public GridDhtPartitionDemander(CacheGroupContext grp) {
        assert (grp != null);
        this.grp = grp;
        this.ctx = grp.shared();
        this.log = this.ctx.logger(this.getClass());
        boolean enabled = grp.rebalanceEnabled() && !this.ctx.kernalContext().clientNode();
        this.rebalanceFut = new RebalanceFuture();
        if (!enabled) {
            this.rebalanceFut.onDone(true);
            this.syncFut.onDone();
        }
        String metricGroupName = MetricUtils.metricName("cacheGroups", grp.cacheOrGroupName());
        MetricRegistry mreg = grp.shared().kernalContext().metric().registry(metricGroupName);
        mreg.register("RebalancingPartitionsLeft", () -> this.rebalanceFut.partitionsLeft.get(), "The number of cache group partitions left to be rebalanced.");
        mreg.register("RebalancingPartitionsTotal", () -> this.rebalanceFut.partitionsTotal, "The total number of cache group partitions to be rebalanced.");
        mreg.register("RebalancingReceivedKeys", () -> this.rebalanceFut.receivedKeys.get(), "The number of currently rebalanced keys for the whole cache group.");
        mreg.register("RebalancingReceivedBytes", () -> this.rebalanceFut.receivedBytes.get(), "The number of currently rebalanced bytes of this cache group.");
        mreg.register("RebalancingStartTime", () -> this.rebalanceFut.startTime, "The time the first partition demand message was sent. If there are no messages to send, the rebalancing time will be undefined.");
        mreg.register("RebalancingEndTime", () -> this.rebalanceFut.endTime, "The time the rebalancing was completed. If the rebalancing completed with an error, was cancelled, or the start time was undefined, the rebalancing end time will be undefined.");
        mreg.register("RebalancingLastCancelledTime", () -> this.lastCancelledTime.get(), "The time the rebalancing was completed with an error or was cancelled. If there were several such cases, the metric stores the last time. The metric displays the value even if there is no rebalancing process.");
        mreg.register("RebalancingFullReceivedKeys", () -> F.viewReadOnly(this.rebalanceFut.fullReceivedKeys, LongAdder::sum, new IgnitePredicate[0]), Map.class, "Currently received keys for full rebalance by supplier.");
        mreg.register("RebalancingHistReceivedKeys", () -> F.viewReadOnly(this.rebalanceFut.histReceivedKeys, LongAdder::sum, new IgnitePredicate[0]), Map.class, "Currently received keys for historical rebalance by supplier.");
        mreg.register("RebalancingFullReceivedBytes", () -> F.viewReadOnly(this.rebalanceFut.fullReceivedBytes, LongAdder::sum, new IgnitePredicate[0]), Map.class, "Currently received bytes for full rebalance by supplier.");
        mreg.register("RebalancingHistReceivedBytes", () -> F.viewReadOnly(this.rebalanceFut.histReceivedBytes, LongAdder::sum, new IgnitePredicate[0]), Map.class, "Currently received bytes for historical rebalance by supplier.");
    }

    void start() {
    }

    void stop() {
        try {
            this.rebalanceFut.tryCancel();
        }
        catch (Exception ignored) {
            this.rebalanceFut.onDone(false);
        }
        this.lastExchangeFut = null;
        this.lastTimeoutObj.set(null);
        this.syncFut.onDone();
    }

    IgniteInternalFuture<?> syncFuture() {
        return this.syncFut;
    }

    IgniteInternalFuture<Boolean> rebalanceFuture() {
        return this.rebalanceFut;
    }

    IgniteInternalFuture<Boolean> forceRebalance() {
        GridDhtPartitionsExchangeFuture exchFut;
        GridTimeoutObject obj = this.lastTimeoutObj.getAndSet(null);
        if (obj != null) {
            this.ctx.time().removeTimeoutObject(obj);
        }
        if ((exchFut = this.lastExchangeFut) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Forcing rebalance event for future: " + exchFut);
            }
            final GridFutureAdapter<Boolean> fut = new GridFutureAdapter<Boolean>();
            exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                @Override
                public void apply(IgniteInternalFuture<AffinityTopologyVersion> t) {
                    if (t.error() == null) {
                        IgniteInternalFuture<Boolean> fut0 = GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                        fut0.listen(new IgniteInClosure<IgniteInternalFuture<Boolean>>(){

                            @Override
                            public void apply(IgniteInternalFuture<Boolean> fut1) {
                                try {
                                    fut.onDone(fut1.get());
                                }
                                catch (Exception e) {
                                    fut.onDone(e);
                                }
                            }
                        });
                    } else {
                        fut.onDone(t.error());
                    }
                }
            });
            return fut;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Ignoring force rebalance request (no topology event happened yet).");
        }
        return new GridFinishedFuture<Boolean>(true);
    }

    void onTopologyChanged(GridDhtPartitionsExchangeFuture lastFut) {
        this.lastExchangeFut = lastFut;
    }

    Collection<UUID> remainingNodes() {
        return this.rebalanceFut.remainingNodes();
    }

    @Nullable
    RebalanceFuture addAssignments(GridDhtPreloaderAssignments assignments, boolean force, long rebalanceId, RebalanceFuture next, @Nullable GridCompoundFuture<Boolean, Boolean> forcedRebFut, GridCompoundFuture<Boolean, Boolean> compatibleRebFut) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Adding partition assignments: " + assignments);
        }
        assert (force == (forcedRebFut != null));
        long delay = this.grp.config().getRebalanceDelay();
        if (delay == 0L || force) {
            assert (assignments != null);
            RebalanceFuture oldFut = this.rebalanceFut;
            if (assignments.cancelled()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to cancelled assignments.");
                }
                return null;
            }
            if (assignments.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing skipped due to empty assignments.");
                }
                if (oldFut.isInitial()) {
                    oldFut.onDone(true);
                } else if (!oldFut.isDone()) {
                    oldFut.tryCancel();
                }
                ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                return null;
            }
            if (!force && (!oldFut.isDone() || ((Boolean)oldFut.result()).booleanValue()) && oldFut.compatibleWith(assignments)) {
                if (!oldFut.isDone()) {
                    compatibleRebFut.add(oldFut);
                }
                return null;
            }
            if (!oldFut.isDone() && !oldFut.isInitial()) {
                oldFut.tryCancel();
            }
            assignments.retainMoving(this.grp.topology());
            if (assignments.isEmpty()) {
                return null;
            }
            RebalanceFuture fut = new RebalanceFuture(this.grp, this.lastExchangeFut, assignments, this.log, rebalanceId, next, this.lastCancelledTime);
            if (oldFut.isInitial()) {
                fut.listen(() -> oldFut.onDone(fut.result()));
            }
            if (forcedRebFut != null) {
                forcedRebFut.add(fut);
            }
            this.rebalanceFut = fut;
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.clearRebalanceCounters();
                for (GridDhtPartitionDemandMessage msg : assignments.values()) {
                    for (Integer partId : msg.partitions().fullSet()) {
                        metrics.onRebalancingKeysCountEstimateReceived(this.grp.topology().globalPartSizes().get(partId));
                    }
                    CachePartitionPartialCountersMap histMap = msg.partitions().historicalMap();
                    for (int i = 0; i < histMap.size(); ++i) {
                        long from = histMap.initialUpdateCounterAt(i);
                        long to = histMap.updateCounterAt(i);
                        metrics.onRebalancingKeysCountEstimateReceived(to - from);
                    }
                }
                metrics.startRebalance(0L);
            }
            fut.sendRebalanceStartedEvent();
            return fut;
        }
        if (delay > 0L) {
            for (GridCacheContext cctx : this.grp.caches()) {
                if (!cctx.statisticsEnabled()) continue;
                CacheMetricsImpl metrics = cctx.cache().metrics0();
                metrics.startRebalance(delay);
            }
            GridTimeoutObject obj = this.lastTimeoutObj.get();
            if (obj != null) {
                this.ctx.time().removeTimeoutObject(obj);
            }
            final GridDhtPartitionsExchangeFuture exchFut = this.lastExchangeFut;
            assert (exchFut != null) : "Delaying rebalance process without topology event.";
            obj = new GridTimeoutObjectAdapter(delay){

                @Override
                public void onTimeout() {
                    exchFut.listen(new CI1<IgniteInternalFuture<AffinityTopologyVersion>>(){

                        @Override
                        public void apply(IgniteInternalFuture<AffinityTopologyVersion> f) {
                            GridDhtPartitionDemander.this.ctx.exchange().forceRebalance(exchFut.exchangeId());
                        }
                    });
                }
            };
            this.lastTimeoutObj.set(obj);
            this.ctx.time().addTimeoutObject(obj);
        }
        return null;
    }

    public void registerSupplyMessage(UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg, Runnable r) {
        RebalanceFuture fut = this.rebalanceFut;
        if (fut.isActual(supplyMsg.rebalanceId())) {
            boolean historical = false;
            for (Integer p : supplyMsg.infos().keySet()) {
                ((LongAdder)fut.queued.get(p)).increment();
                if (!fut.historical.contains(p)) continue;
                historical = true;
            }
            if (historical) {
                this.ctx.kernalContext().pools().getStripedRebalanceExecutorService().execute(r, Math.abs(nodeId.hashCode()));
            } else {
                this.ctx.kernalContext().pools().getRebalanceExecutorService().execute(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSupplyMessage(UUID nodeId, GridDhtPartitionSupplyMessage supplyMsg) {
        block44: {
            AffinityTopologyVersion topVer = supplyMsg.topologyVersion();
            RebalanceFuture fut = this.rebalanceFut;
            ClusterNode node = this.ctx.node(nodeId);
            fut.cancelLock.readLock().lock();
            try {
                String errMsg = null;
                if (fut.isDone()) {
                    errMsg = "rebalance completed";
                } else if (node == null) {
                    errMsg = "supplier has left cluster";
                } else if (!this.rebalanceFut.isActual(supplyMsg.rebalanceId())) {
                    errMsg = "topology changed";
                }
                if (errMsg != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Supply message has been ignored (" + errMsg + ") [" + this.demandRoutineInfo(nodeId, supplyMsg) + ']');
                    }
                    return;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Received supply message [" + this.demandRoutineInfo(nodeId, supplyMsg) + ']');
                }
                Throwable msgExc = null;
                GridDhtPartitionTopology top = this.grp.topology();
                if (supplyMsg.classError() != null) {
                    msgExc = supplyMsg.classError();
                } else if (supplyMsg.error() != null) {
                    msgExc = supplyMsg.error();
                }
                if (msgExc != null) {
                    GridDhtPartitionMap partMap = top.localPartitionMap();
                    Set set = supplyMsg.infos().keySet().stream().filter(p -> partMap.get((int)p) == GridDhtPartitionState.MOVING).collect(Collectors.toSet());
                    U.error(this.log, "Rebalancing routine has failed, some partitions could be unavailable for reading [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", unavailablePartitions=" + S.toStringSortedDistinct(set) + ']', msgExc);
                    fut.error(nodeId);
                    return;
                }
                fut.receivedBytes.addAndGet(supplyMsg.messageSize());
                for (GridCacheContext gridCacheContext : this.grp.caches()) {
                    long l;
                    if (!gridCacheContext.statisticsEnabled()) continue;
                    long l2 = l = this.grp.sharedGroup() ? supplyMsg.keysForCache(gridCacheContext.cacheId()) : supplyMsg.estimatedKeysCount();
                    if (l != -1L) {
                        gridCacheContext.cache().metrics0().onRebalancingKeysCountEstimateReceived(l);
                    }
                    gridCacheContext.cache().metrics0().onRebalanceBatchReceived(supplyMsg.messageSize());
                }
                try {
                    AffinityAssignment aff = this.grp.affinity().cachedAffinity(topVer);
                    for (Map.Entry<Integer, CacheEntryInfoCollection> entry : supplyMsg.infos().entrySet()) {
                        int p2 = entry.getKey();
                        if (aff.get(p2).contains(this.ctx.localNode())) {
                            GridDhtLocalPartition part;
                            try {
                                part = top.localPartition(p2, topVer, true);
                            }
                            catch (GridDhtInvalidPartitionException err) {
                                assert (!topVer.equals(top.lastTopologyChangeVersion()));
                                if (!this.log.isDebugEnabled()) continue;
                                this.log.debug("Failed to get partition for rebalancing [grp=" + this.grp.cacheOrGroupName() + ", err=" + err + ", p=" + p2 + ", topVer=" + topVer + ", lastTopVer=" + top.lastTopologyChangeVersion() + ']');
                                continue;
                            }
                            assert (part != null);
                            boolean last = supplyMsg.last().containsKey(p2);
                            if (part.state() == GridDhtPartitionState.MOVING) {
                                boolean reserved = part.reserve();
                                assert (reserved) : "Failed to reserve partition [igniteInstanceName=" + this.ctx.igniteInstanceName() + ", grp=" + this.grp.cacheOrGroupName() + ", part=" + part + ']';
                                part.beforeApplyBatch(last);
                                try {
                                    long[] byteRcv;
                                    block43: {
                                        byteRcv = new long[]{0L};
                                        GridIterableAdapter<GridCacheEntryInfo> infosWrap = new GridIterableAdapter<GridCacheEntryInfo>(new GridIterableAdapter.IteratorWrapper<GridCacheEntryInfo>(entry.getValue().infos().iterator()){

                                            @Override
                                            public GridCacheEntryInfo nextX() throws IgniteCheckedException {
                                                GridCacheEntryInfo i = (GridCacheEntryInfo)super.nextX();
                                                byteRcv[0] = byteRcv[0] + (long)i.marshalledSize(GridDhtPartitionDemander.this.ctx.cacheObjectContext(i.cacheId()));
                                                return i;
                                            }
                                        });
                                        try {
                                            this.preloadEntries(topVer, part, infosWrap);
                                            this.rebalanceFut.onReceivedKeys(p2, entry.getValue().infos().size(), node);
                                        }
                                        catch (GridDhtInvalidPartitionException ignored) {
                                            if (!this.log.isDebugEnabled()) break block43;
                                            this.log.debug("Partition became invalid during rebalancing (will ignore): " + p2);
                                        }
                                    }
                                    ((LongAdder)fut.processed.get(p2)).increment();
                                    fut.onReceivedBytes(p2, byteRcv[0], node);
                                    if (!last) continue;
                                    this.ownPartition(fut, p2, nodeId, supplyMsg);
                                    continue;
                                }
                                finally {
                                    part.release();
                                    continue;
                                }
                            }
                            if (last) {
                                fut.partitionDone(nodeId, p2, false);
                            }
                            if (!this.log.isDebugEnabled()) continue;
                            this.log.debug("Skipping rebalancing partition (state is not MOVING): [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p2 + ']');
                            continue;
                        }
                        fut.partitionDone(nodeId, p2, false);
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug("Skipping rebalancing partition (affinity changed): [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", p=" + p2 + ']');
                    }
                    for (Integer n : supplyMsg.missed()) {
                        if (!aff.get(n).contains(this.ctx.localNode())) continue;
                        fut.partitionMissed(nodeId, n);
                    }
                    for (Integer n : supplyMsg.missed()) {
                        fut.partitionDone(nodeId, n, false);
                    }
                    GridDhtPartitionDemandMessage gridDhtPartitionDemandMessage = new GridDhtPartitionDemandMessage(supplyMsg.rebalanceId(), supplyMsg.topologyVersion(), this.grp.groupId());
                    gridDhtPartitionDemandMessage.timeout(this.grp.preloader().timeout());
                    if (!fut.isDone()) {
                        try {
                            this.ctx.io().sendOrderedMessage(node, gridDhtPartitionDemandMessage.topic(), gridDhtPartitionDemandMessage.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.preloader().timeout());
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Send next demand message [" + this.demandRoutineInfo(nodeId, supplyMsg) + "]");
                            }
                            break block44;
                        }
                        catch (ClusterTopologyCheckedException clusterTopologyCheckedException) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Supplier has left [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", errMsg=" + clusterTopologyCheckedException.getMessage() + ']');
                            }
                            break block44;
                        }
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Will not request next demand message [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", rebalanceFuture=" + fut + ']');
                    }
                }
                catch (IgniteCheckedException | IgniteSpiException e) {
                    fut.error(nodeId);
                    LT.error(this.log, e, "Error during rebalancing [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", err=" + e + ']');
                }
            }
            finally {
                fut.cancelLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ownPartition(final RebalanceFuture fut, final int p, final UUID nodeId, final GridDhtPartitionSupplyMessage supplyMsg) {
        fut.cancelLock.readLock().lock();
        try {
            if (!fut.isActual(supplyMsg.rebalanceId())) {
                return;
            }
            long queued = ((LongAdder)fut.queued.get(p)).sum();
            long processed = ((LongAdder)fut.processed.get(p)).sum();
            if (processed == queued) {
                fut.partitionDone(nodeId, p, true);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Finished rebalancing partition: [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", id=" + p + "]");
                }
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Retrying partition owning: [" + this.demandRoutineInfo(nodeId, supplyMsg) + ", id=" + p + ", processed=" + processed + ", queued=" + queued + "]");
                }
                this.ctx.kernalContext().timeout().addTimeoutObject(new GridTimeoutObjectAdapter(100L){

                    @Override
                    public void onTimeout() {
                        GridDhtPartitionDemander.this.ctx.kernalContext().pools().getRebalanceExecutorService().execute(() -> GridDhtPartitionDemander.this.ownPartition(fut, p, nodeId, supplyMsg));
                    }
                });
            }
        }
        finally {
            fut.cancelLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mvccPreloadEntries(AffinityTopologyVersion topVer, ClusterNode node, int p, Iterator<GridCacheEntryInfo> infos) throws IgniteCheckedException {
        GridCacheContext<?, ?> cctx;
        if (!infos.hasNext()) {
            return;
        }
        IntHashMap<GridMutableLong> receivedKeys = new IntHashMap<GridMutableLong>();
        ArrayList<GridCacheMvccEntryInfo> entryHist = new ArrayList<GridCacheMvccEntryInfo>();
        GridCacheContext<?, ?> gridCacheContext = cctx = this.grp.sharedGroup() ? null : this.grp.singleCacheContext();
        block3: while (infos.hasNext() || !entryHist.isEmpty()) {
            this.ctx.database().checkpointReadLock();
            try {
                for (int i = 0; i < 100; ++i) {
                    boolean flushHistory;
                    boolean hasMore = infos.hasNext();
                    assert (hasMore || !entryHist.isEmpty());
                    GridCacheMvccEntryInfo entry = null;
                    if (hasMore) {
                        entry = (GridCacheMvccEntryInfo)infos.next();
                        GridCacheMvccEntryInfo prev = entryHist.isEmpty() ? null : (GridCacheMvccEntryInfo)entryHist.get(0);
                        flushHistory = prev != null && (this.grp.sharedGroup() && prev.cacheId() != entry.cacheId() || !prev.key().equals(entry.key()));
                    } else {
                        flushHistory = true;
                    }
                    if (flushHistory) {
                        assert (!entryHist.isEmpty());
                        int cacheId = ((GridCacheMvccEntryInfo)entryHist.get(0)).cacheId();
                        if (this.grp.sharedGroup() && (cctx == null || cacheId != cctx.cacheId())) {
                            assert (cacheId != 0);
                            cctx = this.grp.shared().cacheContext(cacheId);
                        }
                        if (cctx != null) {
                            this.mvccPreloadEntry(cctx, node, entryHist, topVer, p);
                            this.rebalanceFut.onReceivedKeys(p, 1L, node);
                            receivedKeys.computeIfAbsent(cacheId, cid -> new GridMutableLong()).incrementAndGet();
                        }
                        entryHist.clear();
                        if (!hasMore) continue block3;
                    }
                    entryHist.add(entry);
                }
            }
            finally {
                this.ctx.database().checkpointReadUnlock();
            }
        }
        this.updateKeyReceivedMetrics(this.grp, receivedKeys);
    }

    private void preloadEntries(final AffinityTopologyVersion topVer, GridDhtLocalPartition part, Iterator<GridCacheEntryInfo> infos) throws IgniteCheckedException {
        final IntHashMap<GridMutableLong> receivedKeys = new IntHashMap<GridMutableLong>();
        this.grp.offheap().storeEntries(part, infos, new IgnitePredicateX<CacheDataRow>(){

            @Override
            public boolean applyx(CacheDataRow row) throws IgniteCheckedException {
                receivedKeys.computeIfAbsent(row.cacheId(), cid -> new GridMutableLong()).incrementAndGet();
                return GridDhtPartitionDemander.this.preloadEntry(row, topVer);
            }
        });
        this.updateKeyReceivedMetrics(this.grp, receivedKeys);
    }

    private boolean preloadEntry(CacheDataRow row, AffinityTopologyVersion topVer) throws IgniteCheckedException {
        GridCacheContext<?, ?> cctx;
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        GridCacheContext<?, ?> gridCacheContext = cctx = this.grp.sharedGroup() ? this.ctx.cacheContext(row.cacheId()) : this.grp.singleCacheContext();
        if (cctx == null) {
            return false;
        }
        cctx = cctx.isNear() ? cctx.dhtCache().context() : cctx;
        GridCacheEntryEx cached = cctx.cache().entryEx(row.key(), topVer);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Rebalancing key [key=" + cached.key() + ", part=" + cached.partition() + ", grpId=" + this.grp.groupId() + ']');
            }
            assert (row.expireTime() >= 0L) : row.expireTime();
            if (cached.initialValue(row.value(), row.version(), null, null, (byte)0, (byte)0, 0L, row.expireTime(), true, topVer, cctx.isDrEnabled() ? GridDrType.DR_PRELOAD : GridDrType.DR_NONE, false, false, row)) {
                cached.touch();
                if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                    cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), null, null, null, 84, row.value(), true, null, false, null, null, true);
                }
                return true;
            }
            cached.touch();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + cached.partition() + ']');
            }
        }
        catch (GridCacheEntryRemovedException ignored) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + cached.partition() + ']');
            }
        }
        catch (IgniteInterruptedCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [key=" + row.key() + ", part=" + row.partition() + ']', e);
        }
        return false;
    }

    private boolean mvccPreloadEntry(GridCacheContext cctx, ClusterNode from, List<GridCacheMvccEntryInfo> history, AffinityTopologyVersion topVer, int p) throws IgniteCheckedException {
        assert (this.ctx.database().checkpointLockIsHeldByThread());
        assert (!history.isEmpty());
        GridCacheMvccEntryInfo info = history.get(0);
        assert (info.key() != null);
        try {
            GridCacheEntryEx cached = null;
            while (true) {
                try {
                    cached = cctx.cache().entryEx(info.key(), topVer);
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("Rebalancing key [key=" + info.key() + ", part=" + p + ", node=" + from.id() + ']');
                    }
                    if (cached.mvccPreloadEntry(history)) {
                        cached.touch();
                        if (cctx.events().isRecordable(84) && !cached.isInternal()) {
                            cctx.events().addEvent(cached.partition(), cached.key(), cctx.localNodeId(), null, null, null, 84, null, true, null, false, null, null, true);
                        }
                    } else {
                        cached.touch();
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Rebalancing entry is already in cache (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                        }
                    }
                }
                catch (GridCacheEntryRemovedException ignored) {
                    if (!this.log.isTraceEnabled()) continue;
                    this.log.trace("Entry has been concurrently removed while rebalancing (will ignore) [key=" + cached.key() + ", part=" + p + ']');
                    continue;
                }
                catch (GridDhtInvalidPartitionException ignored) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partition became invalid during rebalancing (will ignore): " + p);
                    }
                    return false;
                }
                break;
            }
        }
        catch (IgniteInterruptedCheckedException | ClusterTopologyCheckedException e) {
            throw e;
        }
        catch (IgniteCheckedException e) {
            throw new IgniteCheckedException("Failed to cache rebalanced entry (will stop rebalancing) [local=" + this.ctx.localNode() + ", node=" + from.id() + ", key=" + info.key() + ", part=" + p + ']', e);
        }
        return false;
    }

    private String demandRoutineInfo(UUID supplier, GridDhtPartitionSupplyMessage supplyMsg) {
        return "grp=" + this.grp.cacheOrGroupName() + ", rebalanceId=" + supplyMsg.rebalanceId() + ", topVer=" + supplyMsg.topologyVersion() + ", supplier=" + supplier;
    }

    private void updateKeyReceivedMetrics(CacheGroupContext grpCtx, IntHashMap<GridMutableLong> receivedKeys) {
        if (!receivedKeys.isEmpty()) {
            for (GridCacheContext cacheCtx : grpCtx.caches()) {
                if (!cacheCtx.statisticsEnabled() || !receivedKeys.containsKey(cacheCtx.cacheId())) continue;
                cacheCtx.cache().metrics0().onRebalanceKeyReceived(receivedKeys.get(cacheCtx.cacheId()).get());
            }
        }
    }

    public String toString() {
        return S.toString(GridDhtPartitionDemander.class, this);
    }

    void finishPreloading(AffinityTopologyVersion topVer, long rebalanceId) {
        assert (!this.rebalanceFut.isInitial()) : topVer;
        this.rebalanceFut.ownPartitionsAndFinishFuture(topVer, rebalanceId);
    }

    public static class RebalanceFuture
    extends GridFutureAdapter<Boolean> {
        private static final AtomicReferenceFieldUpdater<RebalanceFuture, RebalanceFutureState> STATE_UPD = AtomicReferenceFieldUpdater.newUpdater(RebalanceFuture.class, RebalanceFutureState.class, "state");
        private final GridCacheSharedContext<?, ?> ctx;
        private volatile RebalanceFutureState state = RebalanceFutureState.INIT;
        private final CacheGroupContext grp;
        private final IgniteLogger log;
        private final Map<UUID, IgniteDhtDemandedPartitionsMap> remaining = new HashMap<UUID, IgniteDhtDemandedPartitionsMap>();
        private final Map<UUID, Collection<Integer>> missed = new HashMap<UUID, Collection<Integer>>();
        @GridToStringExclude
        private final GridDhtPartitionExchangeId exchId;
        @GridToStringExclude
        private final GridDhtPartitionsExchangeFuture exchFut;
        private final AffinityTopologyVersion topVer;
        private final long rebalanceId;
        private final long routines;
        private final ReentrantReadWriteLock cancelLock;
        private final Map<Integer, LongAdder> queued = new HashMap<Integer, LongAdder>();
        private final Map<Integer, LongAdder> processed = new HashMap<Integer, LongAdder>();
        private final Set<Integer> historical = new HashSet<Integer>();
        private final AtomicLong receivedBytes = new AtomicLong(0L);
        private final AtomicLong receivedKeys = new AtomicLong(0L);
        private final AtomicLong partitionsLeft = new AtomicLong(0L);
        private final int partitionsTotal;
        private volatile long startTime = -1L;
        private volatile long endTime = -1L;
        private final AtomicLong lastCancelledTime;
        @GridToStringExclude
        private final RebalanceFuture next;
        private final GridDhtPreloaderAssignments assignments;
        private final Map<UUID, Set<Integer>> rebalancingParts;
        private final Map<UUID, LongAdder> fullReceivedKeys = new ConcurrentHashMap<UUID, LongAdder>();
        private final Map<UUID, LongAdder> fullReceivedBytes = new ConcurrentHashMap<UUID, LongAdder>();
        private final Map<UUID, LongAdder> histReceivedKeys = new ConcurrentHashMap<UUID, LongAdder>();
        private final Map<UUID, LongAdder> histReceivedBytes = new ConcurrentHashMap<UUID, LongAdder>();

        RebalanceFuture(CacheGroupContext grp, GridDhtPartitionsExchangeFuture exchFut, GridDhtPreloaderAssignments assignments, IgniteLogger log, long rebalanceId, RebalanceFuture next, AtomicLong lastCancelledTime) {
            assert (assignments != null) : "Asiignments must not be null.";
            this.rebalancingParts = U.newHashMap(assignments.size());
            this.assignments = assignments;
            this.exchId = assignments.exchangeId();
            this.topVer = assignments.topologyVersion();
            this.exchFut = exchFut;
            this.next = next;
            this.lastCancelledTime = lastCancelledTime;
            assignments.forEach((k, v) -> {
                assert (v.partitions() != null) : "Partitions are null [grp=" + grp.cacheOrGroupName() + ", fromNode=" + k.id() + "]";
                this.remaining.put(k.id(), v.partitions());
                this.partitionsLeft.addAndGet(v.partitions().size());
                HashSet<Integer> parts = new HashSet<Integer>(v.partitions().size());
                parts.addAll(v.partitions().historicalSet());
                parts.addAll(v.partitions().fullSet());
                this.rebalancingParts.put(k.id(), parts);
                this.historical.addAll(v.partitions().historicalSet());
                Stream.concat(v.partitions().historicalSet().stream(), v.partitions().fullSet().stream()).forEach(p -> {
                    this.queued.put((Integer)p, new LongAdder());
                    this.processed.put((Integer)p, new LongAdder());
                });
                Stream.of(this.fullReceivedKeys, this.fullReceivedBytes, this.histReceivedKeys, this.histReceivedBytes).forEach(map -> map.put(k.id(), new LongAdder()));
            });
            this.routines = this.remaining.size();
            this.partitionsTotal = this.rebalancingParts.values().stream().mapToInt(Set::size).sum();
            this.grp = grp;
            this.log = log;
            this.rebalanceId = rebalanceId;
            this.ctx = grp.shared();
            this.cancelLock = new ReentrantReadWriteLock();
        }

        RebalanceFuture() {
            this.rebalancingParts = null;
            this.partitionsTotal = 0;
            this.assignments = null;
            this.exchId = null;
            this.topVer = null;
            this.exchFut = null;
            this.ctx = null;
            this.grp = null;
            this.log = null;
            this.rebalanceId = -1L;
            this.routines = 0L;
            this.cancelLock = new ReentrantReadWriteLock();
            this.next = null;
            this.lastCancelledTime = new AtomicLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void requestPartitions() {
            if (!STATE_UPD.compareAndSet(this, RebalanceFutureState.INIT, RebalanceFutureState.STARTED)) {
                this.cancel();
                return;
            }
            if (this.ctx.kernalContext().isStopping()) {
                this.cancel();
                return;
            }
            if (!this.ctx.kernalContext().grid().isRebalanceEnabled()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Cancel partition demand because rebalance disabled on current node.");
                }
                this.cancel();
                return;
            }
            if (this.isDone()) {
                assert (!((Boolean)this.result()).booleanValue()) : "Rebalance future was done, but partitions never requested [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + ", rebalanceId=" + this.rebalanceId + ']';
                return;
            }
            CacheConfiguration cfg = this.grp.config();
            for (Map.Entry e : this.assignments.entrySet()) {
                IgniteDhtDemandedPartitionsMap parts;
                final ClusterNode node = (ClusterNode)e.getKey();
                final GridDhtPartitionDemandMessage d = (GridDhtPartitionDemandMessage)e.getValue();
                RebalanceFuture rebalanceFuture = this;
                synchronized (rebalanceFuture) {
                    if (this.isDone()) {
                        return;
                    }
                    if (this.startTime == -1L) {
                        this.startTime = System.currentTimeMillis();
                    }
                    parts = this.remaining.get(node.id());
                    U.log(this.log, "Prepared rebalancing [grp=" + this.grp.cacheOrGroupName() + ", mode=" + (Object)((Object)cfg.getRebalanceMode()) + ", supplier=" + node.id() + ", partitionsCount=" + parts.size() + ", topVer=" + this.topologyVersion() + ", rebalanceId=" + this.rebalanceId + ']');
                }
                if (parts.isEmpty()) continue;
                d.rebalanceId(this.rebalanceId);
                d.timeout(this.grp.preloader().timeout());
                int fullSetSize = d.partitions().fullSet().size();
                final AtomicInteger waitCnt = new AtomicInteger(fullSetSize);
                for (Integer partId : d.partitions().fullSet()) {
                    final GridDhtLocalPartition part = this.grp.topology().localPartition(partId);
                    part.dataStore().resetInitialUpdateCounter();
                    part.clearAsync().listen(new IgniteInClosure<IgniteInternalFuture<?>>(){

                        @Override
                        public void apply(IgniteInternalFuture<?> fut) {
                            if (fut.error() != null) {
                                this.tryCancel();
                                log.error("Failed to clear a partition, cancelling rebalancing for a group [grp=" + grp.cacheOrGroupName() + ", part=" + part.id() + ']', fut.error());
                                return;
                            }
                            if (waitCnt.decrementAndGet() == 0) {
                                ctx.kernalContext().closure().runLocalSafe(() -> this.requestPartitions0(node, parts, d));
                            }
                        }
                    });
                }
                if (!d.partitions().fullSet().isEmpty() || d.partitions().historicalSet().isEmpty()) continue;
                this.ctx.kernalContext().closure().runLocalSafe(() -> this.requestPartitions0(node, parts, d));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void requestPartitions0(ClusterNode supplierNode, IgniteDhtDemandedPartitionsMap parts, GridDhtPartitionDemandMessage msg) {
            if (this.isDone()) {
                return;
            }
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Starting rebalance routine [" + this.grp.cacheOrGroupName() + ", topVer=" + this.topVer + ", supplier=" + supplierNode.id() + ", fullPartitions=" + S.toStringSortedDistinct(parts.fullSet()) + ", histPartitions=" + S.toStringSortedDistinct(parts.historicalSet()) + ", rebalanceId=" + this.rebalanceId + ']');
                }
                this.ctx.io().sendOrderedMessage(supplierNode, msg.topic(), msg.convertIfNeeded(supplierNode.version()), this.grp.ioPolicy(), msg.timeout());
                RebalanceFuture rebalanceFuture = this;
                synchronized (rebalanceFuture) {
                    if (this.isDone()) {
                        this.cleanupRemoteContexts(supplierNode.id());
                    }
                }
            }
            catch (IgniteCheckedException e1) {
                ClusterTopologyCheckedException cause = e1.getCause(ClusterTopologyCheckedException.class);
                if (cause != null) {
                    this.log.warning("Failed to send initial demand request to node. " + e1.getMessage());
                } else {
                    this.log.error("Failed to send initial demand request to node.", e1);
                }
                this.cancel();
            }
            catch (Throwable th) {
                this.log.error("Runtime error caught during initial demand request sending.", th);
                this.cancel();
            }
        }

        public void ownPartitionsAndFinishFuture(AffinityTopologyVersion topVer, long rebalanceId) {
            AffinityTopologyVersion curRebTopVer;
            AffinityTopologyVersion rebTopVer = this.ctx.exchange().lastAffinityChangedTopologyVersion(topVer);
            if (!rebTopVer.equals(curRebTopVer = this.ctx.exchange().lastAffinityChangedTopologyVersion(this.topologyVersion()))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Do not own partitions because the topology is outdated [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + topVer + ", curTopVer=" + this.topologyVersion() + ", rebTopVer=" + rebTopVer + ", curRebTopVer=" + curRebTopVer + ']');
                }
                return;
            }
            if (this.rebalanceId != rebalanceId) {
                if (this.log.isInfoEnabled()) {
                    this.log.info("Received preloading task with wrong rebalanceId, ignoring it [rebalanceId=" + this.rebalanceId + ", finishPreloadingTaskRebalanceId=" + rebalanceId + ", grpId=" + this.grp.groupId() + ", topVer=" + topVer + ']');
                }
                return;
            }
            if (this.onDone(true, null)) {
                assert (this.state == RebalanceFutureState.STARTED) : this;
                this.grp.localWalEnabled(true, true);
                this.grp.topology().ownMoving();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Partitions have been scheduled to resend [reason=Group durability restored, name=" + this.grp.cacheOrGroupName() + ']');
                }
                this.ctx.exchange().refreshPartitions(Collections.singleton(this.grp));
            } else if (this.log.isDebugEnabled()) {
                this.log.debug("Do not own partitions because the future has been finished [grp=" + this.grp.cacheOrGroupName() + ", ver=" + this.topVer + ", result=" + this.result() + ']');
            }
        }

        public AffinityTopologyVersion topologyVersion() {
            return this.topVer;
        }

        private boolean isActual(long rebalanceId) {
            return this.rebalanceId == rebalanceId && !this.isDone();
        }

        public boolean isInitial() {
            return this.topVer == null;
        }

        private void tryCancel() {
            if (STATE_UPD.compareAndSet(this, RebalanceFutureState.INIT, RebalanceFutureState.MARK_CANCELLED)) {
                U.log(this.log, "Rebalancing marked as cancelled [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + ", rebalanceId=" + this.rebalanceId + ']');
                return;
            }
            this.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            this.cancelLock.writeLock().lock();
            try {
                RebalanceFuture rebalanceFuture = this;
                synchronized (rebalanceFuture) {
                    block10: {
                        if (!this.isDone()) break block10;
                        boolean bl = true;
                        return bl;
                    }
                    U.log(this.log, "Cancelled rebalancing from all nodes [grp=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topologyVersion() + ", rebalanceId=" + this.rebalanceId + ']');
                    if (!this.ctx.kernalContext().isStopping()) {
                        for (UUID nodeId : this.remaining.keySet()) {
                            this.cleanupRemoteContexts(nodeId);
                        }
                    }
                    this.remaining.clear();
                    this.checkIsDone(true);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.cancelLock.writeLock().unlock();
            }
        }

        @Override
        public boolean onDone(@Nullable Boolean res, @Nullable Throwable err, boolean cancel) {
            boolean isCancelled;
            assert (!cancel) : "RebalanceFuture cancel is not supported. Use res = false.";
            boolean byThisCall = super.onDone(res, err, cancel);
            boolean bl = isCancelled = res == Boolean.FALSE || this.isFailed();
            if (byThisCall) {
                if (isCancelled) {
                    this.lastCancelledTime.accumulateAndGet(System.currentTimeMillis(), Math::max);
                } else if (this.startTime != -1L) {
                    this.endTime = System.currentTimeMillis();
                }
                if (this.log != null && this.log.isInfoEnabled() && !this.isInitial()) {
                    this.log.info("Completed rebalance future: " + this + (this.isFailed() ? ", error=" + err : ""));
                }
                if (!this.isInitial()) {
                    this.sendRebalanceFinishedEvent();
                    if (res.booleanValue() && !this.grp.preloader().syncFuture().isDone()) {
                        ((GridFutureAdapter)this.grp.preloader().syncFuture()).onDone();
                    }
                    if (this.isChainFinished()) {
                        this.onChainFinished();
                    }
                }
                if (this.next != null) {
                    this.next.requestPartitions();
                }
            }
            return byThisCall;
        }

        private synchronized void error(UUID nodeId) {
            if (this.isDone()) {
                return;
            }
            this.cleanupRemoteContexts(nodeId);
            this.remaining.remove(nodeId);
            this.checkIsDone(false);
        }

        private synchronized void partitionMissed(UUID nodeId, int p) {
            if (this.isDone()) {
                return;
            }
            IgniteDhtDemandedPartitionsMap parts = this.remaining.get(nodeId);
            assert (parts != null) : "Remaining not found [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + "]";
            if (parts.historicalMap().contains(p)) {
                this.exchFut.markNodeAsInapplicableForHistoricalRebalance(nodeId);
            } else {
                this.exchFut.markNodeAsInapplicableForFullRebalance(nodeId, this.grp.groupId(), p);
            }
            this.missed.computeIfAbsent(nodeId, k -> new HashSet()).add(p);
        }

        private void cleanupRemoteContexts(UUID nodeId) {
            block3: {
                ClusterNode node = this.ctx.discovery().node(nodeId);
                if (node == null) {
                    return;
                }
                GridDhtPartitionDemandMessage d = new GridDhtPartitionDemandMessage(-this.rebalanceId, this.topologyVersion(), this.grp.groupId());
                d.timeout(this.grp.preloader().timeout());
                try {
                    Object rebalanceTopic = GridCachePartitionExchangeManager.rebalanceTopic(0);
                    this.ctx.io().sendOrderedMessage(node, rebalanceTopic, d.convertIfNeeded(node.version()), this.grp.ioPolicy(), this.grp.preloader().timeout());
                }
                catch (IgniteCheckedException ignored) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("Failed to send failover context cleanup request to node " + nodeId);
                }
            }
        }

        private synchronized void partitionDone(UUID nodeId, int p, boolean own) {
            if (own && (this.grp.localWalEnabled() || !this.grp.persistenceEnabled())) {
                this.grp.topology().own(this.grp.topology().localPartition(p));
            }
            if (this.isDone()) {
                return;
            }
            if (this.grp.eventRecordable(82)) {
                this.rebalanceEvent(p, 82, this.exchId.discoveryEvent());
            }
            IgniteDhtDemandedPartitionsMap parts = this.remaining.get(nodeId);
            assert (parts != null) : "Remaining not found [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + "]";
            boolean rmvd = parts.remove(p);
            assert (rmvd) : "Partition already done [grp=" + this.grp.cacheOrGroupName() + ", fromNode=" + nodeId + ", part=" + p + ", left=" + parts + "]";
            if (rmvd) {
                this.partitionsLeft.decrementAndGet();
            }
            if (parts.isEmpty()) {
                this.logSupplierDone(nodeId);
                this.remaining.remove(nodeId);
            }
            this.checkIsDone(false);
        }

        private void rebalanceEvent(int part, int type, DiscoveryEvent discoEvt) {
            assert (discoEvt != null);
            this.grp.addRebalanceEvent(part, type, discoEvt.eventNode(), discoEvt.type(), discoEvt.timestamp());
        }

        private void rebalanceEvent(int type, DiscoveryEvent discoEvt) {
            this.rebalanceEvent(-1, type, discoEvt);
        }

        private void checkIsDone(boolean cancelled) {
            if (this.remaining.isEmpty()) {
                HashSet<Integer> m = new HashSet<Integer>();
                for (Map.Entry<UUID, Collection<Integer>> e : this.missed.entrySet()) {
                    if (e.getValue() == null || e.getValue().isEmpty()) continue;
                    m.addAll(e.getValue());
                }
                if (!m.isEmpty()) {
                    U.log(this.log, "Reassigning partitions that were missed [parts=" + m + ", grpId=" + this.grp.groupId() + ", grpName=" + this.grp.cacheOrGroupName() + ", topVer=" + this.topVer + ']');
                    this.onDone(false);
                    this.ctx.exchange().forceReassign(this.exchId, this.exchFut);
                    return;
                }
                if (this.grp.persistenceEnabled() && !this.grp.localWalEnabled() && !cancelled) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Delaying partition owning for a group [name=" + this.grp.cacheOrGroupName() + ", ver=" + this.topVer + ']');
                    }
                    CheckpointProgress cp = this.ctx.database().forceCheckpoint(WalStateManager.reason(this.grp.groupId(), this.topVer));
                    cp.onStateChanged(CheckpointState.PAGE_SNAPSHOT_TAKEN, () -> this.grp.localWalEnabled(true, false));
                    cp.onStateChanged(CheckpointState.FINISHED, () -> this.ctx.exchange().finishPreloading(this.topVer, this.grp.groupId(), this.rebalanceId));
                } else {
                    if (this.grp.cdcEnabled() && !this.grp.localWalEnabled() && !cancelled) {
                        this.grp.localWalEnabled(true, false);
                    }
                    this.onDone(!cancelled);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Partitions have been scheduled to resend [reason=Rebalance is done, grp=" + this.grp.cacheOrGroupName() + "]");
                    }
                    this.ctx.exchange().refreshPartitions(Collections.singleton(this.grp));
                }
            }
        }

        private synchronized Collection<UUID> remainingNodes() {
            return this.remaining.keySet();
        }

        private void sendRebalanceStartedEvent() {
            if (this.grp.eventRecordable(80)) {
                this.rebalanceEvent(80, this.exchId.discoveryEvent());
            }
        }

        private void sendRebalanceFinishedEvent() {
            if (this.grp.eventRecordable(81)) {
                this.rebalanceEvent(81, this.exchId.discoveryEvent());
            }
        }

        public boolean compatibleWith(GridDhtPreloaderAssignments newAssignments) {
            if (this.isInitial() || ((GridDhtPreloader)this.grp.preloader()).disableRebalancingCancellationOptimization()) {
                return false;
            }
            if (this.ctx.exchange().lastAffinityChangedTopologyVersion(this.topVer).equals(this.ctx.exchange().lastAffinityChangedTopologyVersion(newAssignments.topologyVersion()))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Rebalancing is forced on the same topology [grp=" + this.grp.cacheOrGroupName() + ", top=" + this.topVer + ']');
                }
                return false;
            }
            if (newAssignments.affinityReassign()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Some of owned partitions were reassigned by coordinator [grp=" + this.grp.cacheOrGroupName() + ", , init=" + this.topVer + ", other=" + newAssignments.topologyVersion() + ']');
                }
                return false;
            }
            Set<Object> p0 = new HashSet();
            Set<Integer> p1 = new HashSet<Integer>();
            for (UUID uUID : this.rebalancingParts.keySet()) {
                if (this.grp.cacheObjectContext().kernalContext().discovery().alive(uUID)) continue;
                return false;
            }
            for (Set set : this.rebalancingParts.values()) {
                p0.addAll(set);
            }
            for (GridDhtPartitionDemandMessage gridDhtPartitionDemandMessage : newAssignments.values()) {
                p1.addAll(gridDhtPartitionDemandMessage.partitions().fullSet());
                p1.addAll(gridDhtPartitionDemandMessage.partitions().historicalSet());
            }
            if (!p0.containsAll(p1)) {
                return false;
            }
            p1 = Stream.concat(this.grp.affinity().cachedAffinity(newAssignments.topologyVersion()).primaryPartitions(this.ctx.localNodeId()).stream(), this.grp.affinity().cachedAffinity(newAssignments.topologyVersion()).backupPartitions(this.ctx.localNodeId()).stream()).collect(Collectors.toSet());
            NavigableSet<AffinityTopologyVersion> toCheck = this.grp.affinity().cachedVersions().headSet(newAssignments.topologyVersion(), false);
            if (!toCheck.contains(this.topVer)) {
                this.log.warning("History is not enough for checking compatible last rebalance, new rebalance started [grp=" + this.grp.cacheOrGroupName() + ", lastTop=" + this.topVer + ']');
                return false;
            }
            for (AffinityTopologyVersion previousTopVer : toCheck.descendingSet()) {
                if (previousTopVer.before(this.topVer)) break;
                if (!this.ctx.exchange().lastAffinityChangedTopologyVersion(previousTopVer).equals(previousTopVer) || (p0 = Stream.concat(this.grp.affinity().cachedAffinity(previousTopVer).primaryPartitions(this.ctx.localNodeId()).stream(), this.grp.affinity().cachedAffinity(previousTopVer).backupPartitions(this.ctx.localNodeId()).stream()).collect(Collectors.toSet())).equals(p1)) continue;
                return false;
            }
            return true;
        }

        private void onReceivedKeys(int p, long k, ClusterNode node) {
            this.receivedKeys.addAndGet(k);
            boolean hist = ((GridDhtPartitionDemandMessage)this.assignments.get(node)).partitions().hasHistorical(p);
            (hist ? this.histReceivedKeys : this.fullReceivedKeys).get(node.id()).add(k);
        }

        private void onReceivedBytes(int p, long bytes, ClusterNode node) {
            boolean hist = ((GridDhtPartitionDemandMessage)this.assignments.get(node)).partitions().hasHistorical(p);
            (hist ? this.histReceivedBytes : this.fullReceivedBytes).get(node.id()).add(bytes);
        }

        private boolean isChainFinished() {
            assert (this.isDone()) : this;
            if (this.isInitial() || !((Boolean)this.result()).booleanValue()) {
                return false;
            }
            RebalanceFuture fut = this.next;
            while (Objects.nonNull(fut)) {
                if (fut.isInitial() || !fut.isDone()) {
                    return false;
                }
                fut = fut.next;
            }
            return true;
        }

        private void onChainFinished() {
            Set futs = this.ctx.cacheContexts().stream().map(GridCacheContext::preloader).filter(GridDhtPreloader.class::isInstance).map(GridDhtPreloader.class::cast).map(p -> p.demander().rebalanceFut).filter(fut -> !fut.isInitial() && fut.isDone() && (Boolean)fut.result() != false && this.topVer.equals(fut.topVer)).collect(Collectors.toSet());
            long parts = 0L;
            long entries = 0L;
            long bytes = 0L;
            long minStartTime = Long.MAX_VALUE;
            for (RebalanceFuture fut2 : futs) {
                parts += fut2.rebalancingParts.values().stream().mapToLong(Collection::size).sum();
                entries += Stream.of(fut2.fullReceivedKeys, fut2.histReceivedKeys).flatMap(map -> map.values().stream()).mapToLong(LongAdder::sum).sum();
                bytes += Stream.of(fut2.fullReceivedBytes, fut2.histReceivedBytes).flatMap(map -> map.values().stream()).mapToLong(LongAdder::sum).sum();
                minStartTime = Math.min(minStartTime, fut2.startTime);
            }
            this.log.info("Completed rebalance chain: [rebalanceId=" + this.rebalanceId + ", partitions=" + parts + ", entries=" + entries + ", duration=" + U.humanReadableDuration(System.currentTimeMillis() - minStartTime) + ", bytesRcvd=" + U.humanReadableByteCount(bytes) + ']');
        }

        private void logSupplierDone(UUID nodeId) {
            int remainingRoutines = this.remaining.size() - 1;
            try {
                Map<Boolean, Long> partCnts = this.rebalancingParts.getOrDefault(nodeId, Collections.emptySet()).stream().collect(Collectors.partitioningBy(this.historical::contains, Collectors.counting()));
                int fullParts = partCnts.getOrDefault(Boolean.FALSE, 0L).intValue();
                int histParts = partCnts.getOrDefault(Boolean.TRUE, 0L).intValue();
                long fullEntries = this.fullReceivedKeys.get(nodeId).sum();
                long histEntries = this.histReceivedKeys.get(nodeId).sum();
                long fullBytes = this.fullReceivedBytes.get(nodeId).sum();
                long histBytes = this.histReceivedBytes.get(nodeId).sum();
                long duration = System.currentTimeMillis() - this.startTime;
                long durationSec = Math.max(1L, TimeUnit.MILLISECONDS.toSeconds(duration));
                U.log(this.log, "Completed " + (remainingRoutines == 0 ? "(final) " : "") + "rebalancing [rebalanceId=" + this.rebalanceId + ", grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", partitions=" + (fullParts + histParts) + ", entries=" + (fullEntries + histEntries) + ", duration=" + U.humanReadableDuration(duration) + ", bytesRcvd=" + U.humanReadableByteCount(fullBytes + histBytes) + ", bandwidth=" + U.humanReadableByteCount((fullBytes + histBytes) / durationSec) + "/sec, histPartitions=" + histParts + ", histEntries=" + histEntries + ", histBytesRcvd=" + U.humanReadableByteCount(histBytes) + ", fullPartitions=" + fullParts + ", fullEntries=" + fullEntries + ", fullBytesRcvd=" + U.humanReadableByteCount(fullBytes) + ", topVer=" + this.topologyVersion() + ", progress=" + (this.routines - (long)remainingRoutines) + "/" + this.routines + ']');
            }
            catch (Throwable t) {
                U.error(this.log, "Completed " + (remainingRoutines == 0 ? "(final) " : "") + "rebalancing [grp=" + this.grp.cacheOrGroupName() + ", supplier=" + nodeId + ", topVer=" + this.topologyVersion() + ", progress=" + (this.routines - (long)remainingRoutines) + "/" + this.routines + "]", t);
            }
        }

        @Override
        public String toString() {
            return S.toString(RebalanceFuture.class, this, "result", this.result());
        }
    }

    private static enum RebalanceFutureState {
        INIT,
        STARTED,
        MARK_CANCELLED;

    }
}

