/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.binary.streams.BinaryHeapOutputStream;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;

@IgniteCodeGeneratingFail
public class ClientMessage
implements Message,
Externalizable {
    private static final long serialVersionUID = -4609408156037304495L;
    private static final int MAX_HANDSHAKE_SIZE = 0x4000000;
    private static final int HANDSHAKE_HEADER = 257;
    private static final int HANDSHAKE_HEADER2 = 513;
    private final boolean isFirstMessage;
    private byte[] data;
    private BinaryHeapOutputStream stream;
    private int cnt = -4;
    private int msgSize;
    private int firstMessageHeader;

    public ClientMessage() {
        this.isFirstMessage = false;
    }

    public ClientMessage(boolean isFirstMessage) {
        this.isFirstMessage = isFirstMessage;
    }

    public ClientMessage(byte[] data) {
        this.data = data;
        this.isFirstMessage = false;
    }

    public ClientMessage(BinaryHeapOutputStream stream) {
        this.stream = stream;
        this.isFirstMessage = false;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter ignored) {
        int missing;
        int msgSize;
        assert (this.stream != null || this.data != null);
        byte[] data = this.stream != null ? this.stream.array() : this.data;
        int n = msgSize = this.stream != null ? this.stream.position() : data.length;
        if (this.cnt < 0) {
            while (this.cnt < 0 && buf.hasRemaining()) {
                buf.put((byte)(msgSize >> 8 * (4 + this.cnt) & 0xFF));
                ++this.cnt;
            }
            if (this.cnt < 0) {
                return false;
            }
        }
        assert (this.cnt >= 0);
        assert (msgSize > 0);
        int remaining = buf.remaining();
        if (remaining > 0 && (missing = msgSize - this.cnt) > 0) {
            int len = Math.min(missing, remaining);
            buf.put(data, this.cnt, len);
            this.cnt += len;
        }
        if (this.cnt == msgSize) {
            this.cnt = -4;
            if (this.stream != null) {
                U.closeQuiet(this.stream);
                this.stream = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        throw new UnsupportedOperationException();
    }

    public boolean readFrom(ByteBuffer buf) throws IOException {
        int missing;
        if (this.cnt < 0) {
            while (this.cnt < 0 && buf.hasRemaining()) {
                this.msgSize |= (buf.get() & 0xFF) << 8 * (4 + this.cnt);
                ++this.cnt;
            }
            if (this.cnt < 0) {
                return false;
            }
            if (this.msgSize <= 0) {
                throw new IOException("Message size must be greater than 0: " + this.msgSize);
            }
            if (this.isFirstMessage && this.msgSize > 0x4000000) {
                throw new IOException("Client handshake size limit exceeded: " + this.msgSize + " > " + 0x4000000);
            }
        }
        assert (this.cnt >= 0);
        assert (this.msgSize > 0);
        int remaining = buf.remaining();
        if (remaining > 0 && (missing = this.msgSize - this.cnt) > 0) {
            int len;
            if (this.isFirstMessage && this.data == null) {
                for (len = Math.min(missing, remaining); len > 0 && this.cnt < 3; --len) {
                    this.firstMessageHeader |= (buf.get() & 0xFF) << 8 * this.cnt;
                    ++this.cnt;
                }
                if (this.cnt < 3) {
                    return false;
                }
                if (this.firstMessageHeader != 257 && this.firstMessageHeader != 513) {
                    throw new IOException("Handshake header check failed: " + this.firstMessageHeader);
                }
                this.data = new byte[this.msgSize];
                this.data[0] = 1;
                this.data[1] = (byte)(this.firstMessageHeader >> 8);
            }
            if (this.data == null) {
                this.data = new byte[this.msgSize];
            }
            buf.get(this.data, this.cnt, len);
            this.cnt += len;
        }
        if (this.cnt == this.msgSize) {
            this.cnt = -4;
            this.msgSize = 0;
            return true;
        }
        return false;
    }

    @Override
    public short directType() {
        return Short.MIN_VALUE;
    }

    @Override
    public byte fieldsCount() {
        return 1;
    }

    @Override
    public void onAckReceived() {
    }

    public byte[] payload() {
        if (this.stream != null) {
            this.data = this.stream.arrayCopy();
            U.closeQuiet(this.stream);
            this.stream = null;
        }
        return this.data;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] data = this.payload();
        out.writeInt(data.length);
        out.write(data);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.data = new byte[in.readInt()];
        in.read(this.data, 0, this.data.length);
    }
}

