/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.compute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.binary.BinaryRawReaderEx;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractJob;
import org.apache.ignite.internal.processors.platform.compute.PlatformAbstractTask;
import org.apache.ignite.internal.processors.platform.memory.PlatformInputStream;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.jetbrains.annotations.Nullable;

public class PlatformClosureJob
extends PlatformAbstractJob {
    private static final long serialVersionUID = 0L;

    public PlatformClosureJob() {
    }

    public PlatformClosureJob(PlatformAbstractTask task, long ptr, Object job, String jobName) {
        super(task, ptr, job, jobName);
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public Object execute0(PlatformContext ctx) throws IgniteCheckedException {
        if (this.task == null) {
            assert (this.ptr == 0L);
            this.createJob(ctx);
            try {
                try (PlatformMemory mem = ctx.memory().allocate();){
                    PlatformOutputStream out = mem.output();
                    out.writeLong(this.ptr);
                    out.writeBoolean(false);
                    out.synchronize();
                    ctx.gateway().computeJobExecute(mem.pointer());
                    PlatformInputStream in = mem.input();
                    in.synchronize();
                    BinaryRawReaderEx reader = ctx.reader(in);
                    Object object = PlatformUtils.readInvocationResult(ctx, reader);
                    return object;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                ctx.gateway().computeJobDestroy(this.ptr);
            }
        }
        assert (this.ptr != 0L);
        return this.runLocal(ctx, false);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        assert (this.job != null);
        out.writeObject(this.job);
        out.writeObject(this.jobName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.job = in.readObject();
        this.jobName = (String)in.readObject();
    }
}

