/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.cluster.ClusterTopologyServerNotFoundException;
import org.apache.ignite.internal.events.DiscoveryCustomEvent;
import org.apache.ignite.internal.managers.discovery.DiscoveryCustomMessage;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheAffinityChangeMessage;
import org.apache.ignite.internal.processors.service.IgniteServiceProcessor;
import org.apache.ignite.internal.processors.service.ServiceClusterDeploymentResult;
import org.apache.ignite.internal.processors.service.ServiceClusterDeploymentResultBatch;
import org.apache.ignite.internal.processors.service.ServiceDeploymentActions;
import org.apache.ignite.internal.processors.service.ServiceDeploymentProcessId;
import org.apache.ignite.internal.processors.service.ServiceInfo;
import org.apache.ignite.internal.processors.service.ServiceSingleNodeDeploymentResult;
import org.apache.ignite.internal.processors.service.ServiceSingleNodeDeploymentResultBatch;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteUuid;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.services.ServiceConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ServiceDeploymentTask {
    private final GridFutureAdapter<?> completeStateFut = new GridFutureAdapter();
    private final GridFutureAdapter<?> initTaskFut = new GridFutureAdapter();
    private final GridFutureAdapter<?> initCrdFut = new GridFutureAdapter();
    private final Object initCrdMux = new Object();
    @GridToStringInclude
    private final Set<UUID> remaining = new HashSet<UUID>();
    private final AtomicBoolean addedInQueue = new AtomicBoolean(false);
    @GridToStringInclude
    private final Map<UUID, ServiceSingleNodeDeploymentResultBatch> singleDepsMsgs = new HashMap<UUID, ServiceSingleNodeDeploymentResultBatch>();
    @GridToStringExclude
    private final Map<IgniteUuid, Map<UUID, Integer>> expDeps = new HashMap<IgniteUuid, Map<UUID, Integer>>();
    @GridToStringExclude
    private final Map<IgniteUuid, Collection<Throwable>> depErrors = new HashMap<IgniteUuid, Collection<Throwable>>();
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final IgniteServiceProcessor srvcProc;
    @GridToStringInclude
    private final ServiceDeploymentProcessId depId;
    @GridToStringExclude
    private volatile UUID crdId;
    @GridToStringInclude
    private volatile DiscoveryEvent evt;
    @GridToStringInclude
    private volatile AffinityTopologyVersion evtTopVer;
    private volatile ServiceDeploymentActions depActions;

    protected ServiceDeploymentTask(GridKernalContext ctx, ServiceDeploymentProcessId depId) {
        assert (ctx.service() instanceof IgniteServiceProcessor);
        this.depId = depId;
        this.ctx = ctx;
        this.srvcProc = ctx.service();
        this.log = ctx.log(this.getClass());
    }

    protected void onEvent(@NotNull DiscoveryEvent evt, @NotNull AffinityTopologyVersion evtTopVer, @Nullable ServiceDeploymentActions depActions) {
        assert (evt.type() == 10 || evt.type() == 11 || evt.type() == 12 || evt.type() == 18) : "Unexpected event type, evt=" + evt;
        this.evt = evt;
        this.evtTopVer = evtTopVer;
        this.depActions = depActions;
    }

    protected void init() throws IgniteCheckedException {
        if (this.isCompleted() || this.initTaskFut.isDone()) {
            return;
        }
        assert (this.evt != null && this.evtTopVer != null) : "Illegal state to perform task's initialization :" + this;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Started services deployment task init: [depId=" + this.depId + ", locId=" + this.ctx.localNodeId() + ", evt=" + this.evt + ']');
        }
        try {
            ClusterNode crd;
            if (this.depActions != null && this.depActions.deactivate()) {
                this.srvcProc.onDeActivate(this.ctx);
                this.completeSuccess();
                return;
            }
            if (this.depActions == null) {
                HashMap<IgniteUuid, ServiceInfo> toDeploy = new HashMap<IgniteUuid, ServiceInfo>();
                int evtType = this.evt.type();
                if (evtType == 18) {
                    DiscoveryCustomMessage msg = ((DiscoveryCustomEvent)this.evt).customMessage();
                    if (msg instanceof CacheAffinityChangeMessage) {
                        Map<Integer, IgniteUuid> change;
                        CacheAffinityChangeMessage msg0 = (CacheAffinityChangeMessage)msg;
                        Map<IgniteUuid, ServiceInfo> services = this.srvcProc.deployedServices();
                        if (!services.isEmpty() && (change = msg0.cacheDeploymentIds()) != null) {
                            HashSet names = new HashSet();
                            this.ctx.cache().cacheDescriptors().forEach((name, desc) -> {
                                if (change.containsKey(desc.groupId())) {
                                    names.add(name);
                                }
                            });
                            services.forEach((srvcId, desc) -> {
                                if (names.contains(desc.cacheName())) {
                                    toDeploy.put((IgniteUuid)srvcId, (ServiceInfo)desc);
                                }
                            });
                        }
                    }
                } else {
                    assert (evtType == 10 || evtType == 11 || evtType == 12);
                    ClusterNode eventNode = this.evt.eventNode();
                    Map<IgniteUuid, ServiceInfo> deployedServices = this.srvcProc.deployedServices();
                    if (evtType == 11 || evtType == 12) {
                        deployedServices.forEach((srvcId, desc) -> {
                            if (desc.topologySnapshot().containsKey(eventNode.id()) || desc.cacheName() != null && !eventNode.isClient()) {
                                toDeploy.put((IgniteUuid)srvcId, (ServiceInfo)desc);
                            }
                        });
                    } else {
                        toDeploy.putAll(deployedServices);
                        toDeploy.putAll(this.srvcProc.servicesReceivedFromJoin(eventNode.id()));
                    }
                }
                if (toDeploy.isEmpty()) {
                    this.completeSuccess();
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("No services deployment deployment action required.");
                    }
                    return;
                }
                this.depActions = new ServiceDeploymentActions(this.ctx);
                this.depActions.servicesToDeploy(toDeploy);
            }
            if ((crd = this.srvcProc.coordinator()) == null) {
                this.onAllServersLeft();
                return;
            }
            this.crdId = crd.id();
            if (crd.isLocal()) {
                this.initCoordinator(this.evtTopVer);
            }
            this.processDeploymentActions(this.depActions);
        }
        catch (Exception e) {
            this.log.error("Error occurred while initializing deployment task, err=" + e.getMessage(), e);
            this.completeError(e);
            throw new IgniteCheckedException(e);
        }
        finally {
            if (!this.initTaskFut.isDone()) {
                this.initTaskFut.onDone();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Finished services deployment future init: [depId=" + this.deploymentId() + ", locId=" + this.ctx.localNodeId() + ']');
            }
        }
    }

    private void processDeploymentActions(@NotNull ServiceDeploymentActions depActions) {
        this.srvcProc.updateDeployedServices(depActions);
        depActions.servicesToUndeploy().forEach((srvcId, desc) -> {
            this.srvcProc.deployment().deployerBlockingSectionBegin();
            try {
                this.srvcProc.undeploy((IgniteUuid)srvcId);
            }
            finally {
                this.srvcProc.deployment().deployerBlockingSectionEnd();
            }
        });
        if (!depActions.servicesToDeploy().isEmpty()) {
            Collection<UUID> evtTopNodes = F.nodeIds(this.ctx.discovery().nodes(this.evtTopVer));
            depActions.servicesToDeploy().forEach((srvcId, desc) -> {
                block5: {
                    try {
                        ServiceConfiguration cfg = desc.configuration();
                        TreeMap<UUID, Integer> oldTop = this.filterDeadNodes(evtTopNodes, desc.topologySnapshot());
                        Map<UUID, Integer> top = this.reassign((IgniteUuid)srvcId, cfg, this.evtTopVer, oldTop);
                        this.expDeps.put((IgniteUuid)srvcId, top);
                        Integer expCnt = top.getOrDefault(this.ctx.localNodeId(), 0);
                        if (expCnt <= this.srvcProc.localInstancesCount((IgniteUuid)srvcId)) break block5;
                        this.srvcProc.deployment().deployerBlockingSectionBegin();
                        try {
                            this.srvcProc.redeploy((IgniteUuid)srvcId, cfg, top);
                        }
                        finally {
                            this.srvcProc.deployment().deployerBlockingSectionEnd();
                        }
                    }
                    catch (IgniteCheckedException e) {
                        this.depErrors.computeIfAbsent((IgniteUuid)srvcId, c -> new ArrayList()).add(e);
                    }
                }
            });
        }
        this.createAndSendSingleDeploymentsMessage(this.depId, this.depErrors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCoordinator(AffinityTopologyVersion topVer) {
        Object object = this.initCrdMux;
        synchronized (object) {
            if (this.initCrdFut.isDone()) {
                return;
            }
            try {
                for (ClusterNode node : this.ctx.discovery().nodes(topVer)) {
                    if (!this.ctx.discovery().alive(node) || this.singleDepsMsgs.containsKey(node.id())) continue;
                    this.remaining.add(node.id());
                }
            }
            catch (Exception e) {
                this.log.error("Error occurred while initializing remaining collection.", e);
                this.initCrdFut.onDone(e);
            }
            finally {
                if (!this.initCrdFut.isDone()) {
                    this.initCrdFut.onDone();
                }
            }
        }
    }

    private void createAndSendSingleDeploymentsMessage(ServiceDeploymentProcessId depId, Map<IgniteUuid, Collection<Throwable>> errors) {
        assert (this.crdId != null) : "Coordinator should be defined at this point, locId=" + this.ctx.localNodeId();
        try {
            HashSet<IgniteUuid> depServicesIds = new HashSet<IgniteUuid>();
            if (this.evt.type() == 10) {
                UUID evtNodeId = this.evt.eventNode().id();
                this.expDeps.forEach((srvcId, top) -> {
                    if (top.containsKey(evtNodeId)) {
                        depServicesIds.add((IgniteUuid)srvcId);
                    }
                });
            } else {
                depServicesIds.addAll(this.expDeps.keySet());
            }
            HashMap<IgniteUuid, ServiceSingleNodeDeploymentResult> results = new HashMap<IgniteUuid, ServiceSingleNodeDeploymentResult>();
            for (IgniteUuid srvcId2 : depServicesIds) {
                ServiceSingleNodeDeploymentResult depRes = new ServiceSingleNodeDeploymentResult(this.srvcProc.localInstancesCount(srvcId2));
                this.attachDeploymentErrors(depRes, errors.get(srvcId2));
                results.put(srvcId2, depRes);
            }
            errors.forEach((srvcId, err) -> {
                if (results.containsKey(srvcId)) {
                    return;
                }
                ServiceSingleNodeDeploymentResult depRes = new ServiceSingleNodeDeploymentResult(this.srvcProc.localInstancesCount((IgniteUuid)srvcId));
                this.attachDeploymentErrors(depRes, (Collection<Throwable>)err);
                results.put((IgniteUuid)srvcId, depRes);
            });
            ServiceSingleNodeDeploymentResultBatch msg = new ServiceSingleNodeDeploymentResultBatch(depId, results);
            if (this.ctx.localNodeId().equals(this.crdId)) {
                this.onReceiveSingleDeploymentsMessage(this.ctx.localNodeId(), msg);
            } else {
                this.ctx.io().sendToGridTopic(this.crdId, GridTopic.TOPIC_SERVICES, (Message)msg, (byte)11);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Send services single deployments message, msg=" + msg);
            }
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to send services single deployments message to coordinator over communication spi.", e);
        }
    }

    protected void onReceiveSingleDeploymentsMessage(UUID snd, ServiceSingleNodeDeploymentResultBatch msg) {
        assert (this.depId.equals(msg.deploymentId())) : "Wrong message's deployment process id, msg=" + msg;
        this.initCrdFut.listen(() -> {
            if (this.isCompleted()) {
                return;
            }
            Object object = this.initCrdMux;
            synchronized (object) {
                if (this.remaining.remove(snd)) {
                    this.singleDepsMsgs.put(snd, msg);
                    if (this.remaining.isEmpty()) {
                        this.onAllReceived();
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Unexpected service single deployments received, msg=" + msg);
                }
            }
        });
    }

    protected void onReceiveFullDeploymentsMessage(ServiceClusterDeploymentResultBatch msg) {
        assert (this.depId.equals(msg.deploymentId())) : "Wrong message's deployment process id, msg=" + msg;
        this.initTaskFut.listen(() -> {
            if (this.isCompleted()) {
                return;
            }
            this.ctx.closure().runLocalSafe(() -> {
                try {
                    ServiceDeploymentActions depResults = msg.servicesDeploymentActions();
                    assert (depResults != null) : "Services deployment actions should be attached.";
                    Map<IgniteUuid, Map<UUID, Integer>> fullTops = depResults.deploymentTopologies();
                    Map<IgniteUuid, Collection<byte[]>> fullErrors = depResults.deploymentErrors();
                    this.depActions.deploymentTopologies(fullTops);
                    this.depActions.deploymentErrors(fullErrors);
                    this.srvcProc.updateServicesTopologies(fullTops);
                    Map<IgniteUuid, ServiceInfo> services = this.srvcProc.deployedServices();
                    fullTops.forEach((srvcId, top) -> {
                        Integer expCnt = top.getOrDefault(this.ctx.localNodeId(), 0);
                        if (expCnt < this.srvcProc.localInstancesCount((IgniteUuid)srvcId)) {
                            ServiceInfo desc = (ServiceInfo)services.get(srvcId);
                            assert (desc != null);
                            ServiceConfiguration cfg = desc.configuration();
                            try {
                                this.srvcProc.redeploy((IgniteUuid)srvcId, cfg, (Map<UUID, Integer>)top);
                            }
                            catch (IgniteCheckedException e) {
                                this.log.error("Error occured during cancel exceed service instances: [srvcId=" + srvcId + ", name=" + desc.name() + ']', e);
                            }
                        }
                    });
                    this.completeSuccess();
                }
                catch (Throwable t) {
                    this.log.error("Failed to process services full deployments message, msg=" + msg, t);
                    this.completeError(t);
                }
            });
        });
    }

    private void completeInitiatingFuture(Throwable err) {
        if (this.depActions == null) {
            return;
        }
        this.depActions.servicesToDeploy().forEach((srvcId, desc) -> {
            if (err != null) {
                this.srvcProc.completeInitiatingFuture(true, (IgniteUuid)srvcId, err);
                return;
            }
            Collection<byte[]> errors = this.depActions.deploymentErrors().get(srvcId);
            if (errors == null) {
                this.srvcProc.completeInitiatingFuture(true, (IgniteUuid)srvcId, null);
                return;
            }
            Throwable depErr = null;
            for (byte[] error : errors) {
                try {
                    Throwable t = (Throwable)U.unmarshal(this.ctx, error, null);
                    if (depErr == null) {
                        depErr = t;
                        continue;
                    }
                    depErr.addSuppressed(t);
                }
                catch (IgniteCheckedException e) {
                    this.log.error("Failed to unmarshal deployment error.", e);
                }
            }
            this.srvcProc.completeInitiatingFuture(true, (IgniteUuid)srvcId, depErr);
        });
        for (IgniteUuid reqSrvcId : this.depActions.servicesToUndeploy().keySet()) {
            this.srvcProc.completeInitiatingFuture(false, reqSrvcId, err);
        }
    }

    private void onAllReceived() {
        assert (!this.isCompleted());
        Collection<ServiceClusterDeploymentResult> fullResults = this.buildFullDeploymentsResults(this.singleDepsMsgs);
        try {
            ServiceClusterDeploymentResultBatch msg = new ServiceClusterDeploymentResultBatch(this.depId, fullResults);
            this.ctx.discovery().sendCustomEvent(msg);
        }
        catch (IgniteCheckedException e) {
            this.log.error("Failed to send services full deployments message across the ring.", e);
        }
    }

    private Map<UUID, Integer> reassign(IgniteUuid srvcId, ServiceConfiguration cfg, AffinityTopologyVersion topVer, TreeMap<UUID, Integer> oldTop) throws IgniteCheckedException {
        try {
            Map<UUID, Integer> top = this.srvcProc.reassign(srvcId, cfg, topVer, oldTop);
            if (top.isEmpty()) {
                throw new IgniteCheckedException("Failed to determine suitable nodes to deploy service.");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Calculated service assignment : [srvcId=" + srvcId + ", srvcTop=" + top + ']');
            }
            return top;
        }
        catch (Throwable e) {
            throw new IgniteCheckedException("Failed to calculate assignments for service, cfg=" + cfg, e);
        }
    }

    private TreeMap<UUID, Integer> filterDeadNodes(Collection<UUID> evtTopNodes, Map<UUID, Integer> top) {
        TreeMap<UUID, Integer> filtered = new TreeMap<UUID, Integer>();
        if (F.isEmpty(top)) {
            return filtered;
        }
        top.forEach((nodeId, cnt) -> {
            if (evtTopNodes.contains(nodeId)) {
                filtered.put((UUID)nodeId, (Integer)cnt);
            }
        });
        return filtered;
    }

    private Collection<ServiceClusterDeploymentResult> buildFullDeploymentsResults(Map<UUID, ServiceSingleNodeDeploymentResultBatch> singleDepsMsgs) {
        HashMap<IgniteUuid, Map> singleResults = new HashMap<IgniteUuid, Map>();
        singleDepsMsgs.forEach((nodeId, msg) -> msg.results().forEach((srvcId, res) -> {
            Map<UUID, Integer> expTop;
            Map depResults = singleResults.computeIfAbsent((IgniteUuid)srvcId, r -> new HashMap());
            int cnt = res.count();
            if (cnt != 0 && (expTop = this.expDeps.get(srvcId)) != null) {
                Integer expCnt = expTop.get(nodeId);
                int n = cnt = expCnt == null ? 0 : Math.min(cnt, expCnt);
            }
            if (cnt == 0 && res.errors().isEmpty()) {
                return;
            }
            ServiceSingleNodeDeploymentResult singleDepRes = new ServiceSingleNodeDeploymentResult(cnt);
            if (!res.errors().isEmpty()) {
                singleDepRes.errors(res.errors());
            }
            depResults.put(nodeId, singleDepRes);
        }));
        ArrayList<ServiceClusterDeploymentResult> fullResults = new ArrayList<ServiceClusterDeploymentResult>();
        singleResults.forEach((srvcId, dep) -> {
            ServiceClusterDeploymentResult res = new ServiceClusterDeploymentResult((IgniteUuid)srvcId, (Map<UUID, ServiceSingleNodeDeploymentResult>)dep);
            fullResults.add(res);
        });
        return fullResults;
    }

    private void attachDeploymentErrors(@NotNull ServiceSingleNodeDeploymentResult depRes, @Nullable Collection<Throwable> errors) {
        if (F.isEmpty(errors)) {
            return;
        }
        ArrayList<byte[]> errorsBytes = new ArrayList<byte[]>();
        for (Throwable th : errors) {
            try {
                byte[] arr = U.marshal(this.ctx, (Object)th);
                errorsBytes.add(arr);
            }
            catch (IgniteCheckedException e) {
                this.log.error("Failed to marshal deployment error, err=" + th, e);
            }
        }
        depRes.errors(errorsBytes);
    }

    protected void onNodeLeft(UUID nodeId) {
        this.initTaskFut.listen(() -> {
            if (this.isCompleted()) {
                return;
            }
            boolean crdChanged = nodeId.equals(this.crdId);
            if (crdChanged) {
                ClusterNode crd = this.srvcProc.coordinator();
                if (crd != null) {
                    this.crdId = crd.id();
                    if (crd.isLocal()) {
                        this.initCoordinator(this.evtTopVer);
                    }
                    this.createAndSendSingleDeploymentsMessage(this.depId, this.depErrors);
                } else {
                    this.onAllServersLeft();
                }
            } else if (this.ctx.localNodeId().equals(this.crdId)) {
                Object object = this.initCrdMux;
                synchronized (object) {
                    boolean rmvd = this.remaining.remove(nodeId);
                    if (rmvd && this.remaining.isEmpty()) {
                        this.singleDepsMsgs.remove(nodeId);
                        this.onAllReceived();
                    }
                }
            }
        });
    }

    private void onAllServersLeft() {
        assert (this.ctx.clientNode());
        this.completeError(new ClusterTopologyServerNotFoundException("Failed to resolve coordinator to continue services deployment process: [locId=" + this.ctx.localNodeId() + "client=" + this.ctx.clientNode() + "evt=" + this.evt + ']'));
    }

    public DiscoveryEvent event() {
        return this.evt;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.evtTopVer;
    }

    public ServiceDeploymentProcessId deploymentId() {
        return this.depId;
    }

    public void completeSuccess() {
        if (!this.completeStateFut.isDone()) {
            this.completeInitiatingFuture(null);
            this.completeStateFut.onDone();
        }
        if (!this.initTaskFut.isDone()) {
            this.initTaskFut.onDone();
        }
        if (!this.initCrdFut.isDone()) {
            this.initCrdFut.onDone();
        }
    }

    public void completeError(Throwable err) {
        if (!this.completeStateFut.isDone()) {
            this.completeInitiatingFuture(err);
            this.completeStateFut.onDone(err);
        }
        if (!this.initTaskFut.isDone()) {
            this.initTaskFut.onDone(err);
        }
        if (!this.initCrdFut.isDone()) {
            this.initCrdFut.onDone(err);
        }
    }

    protected boolean isCompleted() {
        return this.completeStateFut.isDone();
    }

    protected void waitForComplete(long timeout) throws IgniteCheckedException {
        this.completeStateFut.get(timeout);
    }

    protected boolean onEnqueued() {
        return this.addedInQueue.compareAndSet(false, true);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceDeploymentTask task = (ServiceDeploymentTask)o;
        return this.depId.equals(task.depId);
    }

    public int hashCode() {
        return this.depId.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.initCrdMux;
        synchronized (object) {
            return S.toString(ServiceDeploymentTask.class, this, "locNodeId", this.ctx != null ? this.ctx.localNodeId() : "unknown", "crdId", (Object)this.crdId);
        }
    }
}

