/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.logger.java;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JavaLoggerFormatter
extends Formatter {
    public static final String ANONYMOUS_LOGGER_NAME = "UNKNOWN";

    @Override
    public String format(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String logName = record.getLoggerName();
        if (logName == null) {
            logName = ANONYMOUS_LOGGER_NAME;
        } else if (logName.contains(".")) {
            logName = logName.substring(logName.lastIndexOf(46) + 1);
        }
        String ex = null;
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            record.getThrown().printStackTrace(new PrintWriter(sw));
            String stackTrace = sw.toString();
            ex = "\n" + stackTrace;
        }
        return "[" + IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(record.getMillis())) + "][" + record.getLevel() + "][" + threadName + "][" + logName + "] " + this.formatMessage(record) + (ex == null ? "\n" : ex);
    }

    public String toString() {
        return S.toString(JavaLoggerFormatter.class, this);
    }
}

