/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.ignite.IgniteOutputTableHandle;
import io.trino.plugin.ignite.IgniteTableProperties;
import io.trino.plugin.ignite.ImplementAvgBigint;
import io.trino.plugin.ignite.ImplementAvgDecimal;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.WriteFunction;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementCountDistinct;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class IgniteClient
extends BaseJdbcClient {
    private static final String IGNITE_SCHEMA = "PUBLIC";
    private static final String IGNITE_DUMMY_ID = "dummy_id";
    private static final Splitter SPLITTER = Splitter.on((String)"\"").omitEmptyStrings().trimResults();
    private static final LocalDate MIN_DATE = LocalDate.parse("1970-01-01");
    private static final LocalDate MAX_DATE = LocalDate.parse("9999-12-31");
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;

    @Inject
    public IgniteClient(BaseJdbcConfig config, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("`", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, false);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((IgniteClient)this).quoted(arg_0)).map("$equal(left, right)").to("left = right").map("$not_equal(left, right)").to("left <> right").map("$identical(left, right)").to("left IS NOT DISTINCT FROM right").map("$less_than(left, right)").to("left < right").map("$less_than_or_equal(left, right)").to("left <= right").map("$greater_than(left, right)").to("left > right").map("$greater_than_or_equal(left, right)").to("left >= right").map("$like(value: varchar, pattern: varchar): boolean").to("value LIKE pattern").map("$not($is_null(value))").to("value IS NOT NULL").map("$not(value: boolean)").to("NOT value").map("$is_null(value)").to("value IS NULL").build();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax(true)).add((Object)new ImplementSum(IgniteClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementCountDistinct(bigintTypeHandle, true)).build());
    }

    public Collection<String> listSchemas(Connection connection) {
        return ImmutableSet.of((Object)IGNITE_SCHEMA);
    }

    public ResultSet getTables(Connection connection, Optional<String> schemaName, Optional<String> tableName) throws SQLException {
        DatabaseMetaData metadata = connection.getMetaData();
        return metadata.getTables(null, this.escapeObjectNameForMetadataQuery(schemaName, metadata.getSearchStringEscape()).orElse(IGNITE_SCHEMA), this.escapeObjectNameForMetadataQuery(tableName, metadata.getSearchStringEscape()).orElse(null), new String[]{"TABLE", "VIEW"});
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (typeHandle.jdbcType()) {
            case 16: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 6: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 3: {
                int decimalDigits = typeHandle.requiredDecimalDigits();
                int precision = typeHandle.requiredColumnSize();
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW && precision > 38) {
                    int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                    return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                }
                if ((precision += Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0))));
            }
            case 12: {
                return Optional.of(IgniteClient.varcharColumnMapping(typeHandle.columnSize()));
            }
            case 91: {
                return Optional.of(ColumnMapping.longMapping((Type)DateType.DATE, (LongReadFunction)IgniteClient.dateReadFunction(), (LongWriteFunction)IgniteClient.dateWriteFunction()));
            }
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"int", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return WriteMapping.sliceMapping((String)("varchar(" + charType.getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof DateType) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)IgniteClient.dateWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"binary", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(3, Optional.of("Decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    private static ColumnMapping varcharColumnMapping(Optional<Integer> columnSize) {
        VarcharType varcharType = columnSize.filter(size -> size != Integer.MAX_VALUE).map(VarcharType::createVarcharType).orElse(VarcharType.createUnboundedVarcharType());
        return ColumnMapping.sliceMapping((Type)varcharType, (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)varcharType), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)PredicatePushdownController.FULL_PUSHDOWN);
    }

    private static LongReadFunction dateReadFunction() {
        return (resultSet, columnIndex) -> {
            long localMillis = resultSet.getDate(columnIndex).getTime();
            long days = TimeUnit.MILLISECONDS.toDays(localMillis);
            IgniteClient.checkDateValue(days);
            return days;
        };
    }

    private static LongWriteFunction dateWriteFunction() {
        return (statement, index, value) -> {
            IgniteClient.checkDateValue(value);
            long millis = TimeUnit.DAYS.toMillis(value);
            statement.setDate(index, new Date(millis));
        };
    }

    private static void checkDateValue(long epochDay) {
        if (epochDay < MIN_DATE.toEpochDay() || epochDay > MAX_DATE.toEpochDay()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Date must be between %s and %s in Ignite: %s", MIN_DATE, MAX_DATE, LocalDate.ofEpochDay(epochDay)));
        }
    }

    public JdbcOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        IgniteOutputTableHandle igniteOutputTableHandle;
        block12: {
            if (tableMetadata.getComment().isPresent()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating tables with table comment");
            }
            SchemaTableName schemaTableName = tableMetadata.getTable();
            String schema = schemaTableName.getSchemaName();
            if (!this.getSchemaNames(session).contains(schema)) {
                throw new SchemaNotFoundException(schema);
            }
            int expectedSize = tableMetadata.getColumns().size();
            ImmutableList.Builder columns = ImmutableList.builderWithExpectedSize((int)expectedSize);
            ImmutableList.Builder columnNamesBuilder = ImmutableList.builderWithExpectedSize((int)expectedSize);
            ImmutableList.Builder columnTypes = ImmutableList.builderWithExpectedSize((int)expectedSize);
            for (ColumnMetadata columnMetadata : tableMetadata.getColumns()) {
                columns.add((Object)this.getColumnDefinitionSql(session, columnMetadata, columnMetadata.getName()));
                columnNamesBuilder.add((Object)columnMetadata.getName());
                columnTypes.add((Object)columnMetadata.getType());
            }
            ImmutableList columnNames = columnNamesBuilder.build();
            List<String> primaryKeys = IgniteTableProperties.getPrimaryKey(tableMetadata.getProperties());
            for (String primaryKey : primaryKeys) {
                if (columnNames.contains(primaryKey)) continue;
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_TABLE_PROPERTY, String.format("Column '%s' specified in property '%s' doesn't exist in table", primaryKey, "primary_key"));
            }
            String sql = this.buildCreateSql(schemaTableName, (List<String>)columns.build(), primaryKeys);
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                this.execute(session, connection, sql);
                igniteOutputTableHandle = new IgniteOutputTableHandle(new RemoteTableName(Optional.empty(), Optional.of(schemaTableName.getSchemaName()), schemaTableName.getTableName()), (List<String>)columnNames, (List<Type>)columnTypes.build(), Optional.empty(), primaryKeys.isEmpty() ? Optional.of(IGNITE_DUMMY_ID) : Optional.empty());
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return igniteOutputTableHandle;
    }

    private String buildCreateSql(SchemaTableName schemaTableName, List<String> columns, List<String> primaryKeys) {
        ImmutableList.Builder columnDefinitions = ImmutableList.builder();
        columnDefinitions.addAll(columns);
        Preconditions.checkArgument((primaryKeys.size() < columns.size() ? 1 : 0) != 0, (Object)"Ignite table must have at least one non PRIMARY KEY column.");
        if (primaryKeys.isEmpty()) {
            columnDefinitions.add((Object)(this.quoted(IGNITE_DUMMY_ID) + " VARCHAR NOT NULL"));
            primaryKeys = ImmutableList.of((Object)IGNITE_DUMMY_ID);
        }
        columnDefinitions.add((Object)("PRIMARY KEY (" + String.join((CharSequence)", ", primaryKeys.stream().map(arg_0 -> ((IgniteClient)this).quoted(arg_0)).collect(Collectors.joining(", "))) + ")"));
        String remoteTableName = this.quoted(null, schemaTableName.getSchemaName(), schemaTableName.getTableName());
        return String.format("CREATE TABLE %s (%s) ", remoteTableName, String.join((CharSequence)", ", (Iterable<? extends CharSequence>)columnDefinitions.build()));
    }

    protected String quoted(@Nullable String catalog, @Nullable String schema, String table) {
        StringBuilder sb = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)schema)) {
            sb.append(this.quoted(schema)).append(".");
        }
        sb.append(this.quoted(table));
        return sb.toString();
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsMerge() {
        return true;
    }

    public List<JdbcColumnHandle> getPrimaryKeys(ConnectorSession session, RemoteTableName remoteTableName) {
        JdbcTableHandle plainTable = new JdbcTableHandle(remoteTableName.getSchemaTableName(), remoteTableName, Optional.empty());
        Map<String, Object> tableProperties = this.getTableProperties(session, plainTable);
        ImmutableSet primaryKey = ImmutableSet.copyOf(IgniteTableProperties.getPrimaryKey(tableProperties));
        List primaryKeys = (List)this.getColumns(session, remoteTableName.getSchemaTableName(), remoteTableName).stream().filter(arg_0 -> IgniteClient.lambda$getPrimaryKeys$0((Set)primaryKey, arg_0)).collect(ImmutableList.toImmutableList());
        Verify.verify((!primaryKeys.isEmpty() ? 1 : 0) != 0, (String)"Ignite primary keys is empty", (Object[])new Object[0]);
        return primaryKeys;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().map(sortItem -> {
                String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                String nullsHandling = sortItem.sortOrder().isNullsFirst() ? "IS NULL DESC" : "IS NULL ASC";
                String columnName = this.quoted(sortItem.column().getColumnName());
                return String.format("%s %s, %1$s %s", columnName, nullsHandling, ordering);
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s OFFSET 0 ROWS FETCH NEXT %s ROWS ONLY", query, orderBy, limit);
        });
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        Map<String, Object> map;
        block8: {
            Connection connection = this.connectionFactory.openConnection(session);
            try {
                map = this.getTableProperties(connection, tableHandle);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
                }
            }
            connection.close();
        }
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getTableProperties(Connection connection, JdbcTableHandle tableHandle) {
        ImmutableMap.Builder properties = ImmutableMap.builder();
        SchemaTableName schemaTableName = tableHandle.asPlainTable().getSchemaTableName();
        String schemaName = Objects.requireNonNull(schemaTableName.getSchemaName(), "Ignite schema name can not be null").toUpperCase(Locale.ENGLISH);
        String tableName = Objects.requireNonNull(schemaTableName.getTableName(), "Ignite table name can not be null").toUpperCase(Locale.ENGLISH);
        String sql = "SELECT COLUMNS FROM sys.indexes WHERE SCHEMA_NAME = ? AND TABLE_NAME = ? AND IS_PK LIMIT 1";
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            preparedStatement.setString(1, schemaName);
            preparedStatement.setString(2, tableName);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) {
                    ImmutableMap immutableMap = ImmutableMap.of();
                    return immutableMap;
                }
                List<String> primaryKeys = this.extractColumnNamesFromOrderingScheme(resultSet.getString("COLUMNS"));
                Preconditions.checkArgument((!primaryKeys.isEmpty() ? 1 : 0) != 0, (Object)"Ignite table should has at least one primary key");
                properties.put((Object)"primary_key", primaryKeys);
                return properties.buildOrThrow();
            }
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private List<String> extractColumnNamesFromOrderingScheme(String row) {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (Strings.isNullOrEmpty((String)row)) {
            return builder.build();
        }
        List fields = SPLITTER.splitToList((CharSequence)row);
        for (int i = 0; i < fields.size(); i += 2) {
            String field = (String)fields.get(i);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)field) ? 1 : 0) != 0, (Object)"Ignite column name is empty");
            builder.add((Object)field.toLowerCase(Locale.ENGLISH));
        }
        return builder.build();
    }

    public String buildInsertSql(JdbcOutputTableHandle handle, List<WriteFunction> columnWriters) {
        IgniteOutputTableHandle outputHandle = (IgniteOutputTableHandle)handle;
        Object params = columnWriters.stream().map(WriteFunction::getBindExpression).collect(Collectors.joining(","));
        Object columns = handle.getColumnNames().stream().map(arg_0 -> ((IgniteClient)this).quoted(arg_0)).collect(Collectors.joining(", "));
        if (outputHandle.dummyIdColumn().isPresent()) {
            String nextId = "CAST(UUID() AS VARCHAR), ";
            params = nextId + (String)params;
            columns = this.quoted(outputHandle.dummyIdColumn().get()) + ", " + (String)columns;
        }
        return String.format("INSERT INTO %s (%s) VALUES (%s)", this.quoted(handle.getRemoteTableName()), columns, params);
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics);
    }

    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return super.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics);
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        return true;
    }

    public void createSchema(ConnectorSession session, String schemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support creating schemas");
    }

    public void dropSchema(ConnectorSession session, String schemaName, boolean cascade) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping schemas");
    }

    public void truncateTable(ConnectorSession session, JdbcTableHandle handle) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support truncating tables");
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming columns");
    }

    public void renameTable(ConnectorSession session, JdbcTableHandle handle, SchemaTableName newTableName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables");
    }

    public void renameSchema(ConnectorSession session, String schemaName, String newSchemaName) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming schemas");
    }

    private static /* synthetic */ boolean lambda$getPrimaryKeys$0(Set primaryKey, JdbcColumnHandle columnHandle) {
        return primaryKey.contains(columnHandle.getColumnName().toLowerCase(Locale.ENGLISH));
    }
}

