/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.ignite.IgniteClient;
import io.trino.plugin.ignite.IgniteJdbcConfig;
import io.trino.plugin.ignite.IgniteJdbcMetadataFactory;
import io.trino.plugin.ignite.IgniteTableProperties;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadataFactory;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import java.sql.Driver;
import org.apache.ignite.IgniteJdbcThinDriver;

public class IgniteClientModule
implements Module {
    public void configure(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(IgniteClient.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, JdbcMetadataFactory.class).setBinding().to(IgniteJdbcMetadataFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(IgniteJdbcConfig.class);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, IgniteTableProperties.class);
        binder.install((Module)new DecimalModule());
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory createConnectionFactory(BaseJdbcConfig config, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        return DriverConnectionFactory.builder((Driver)new IgniteJdbcThinDriver(), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setOpenTelemetry(openTelemetry).build();
    }
}

