/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.ignite.IgniteMetadata;
import io.trino.plugin.jdbc.DefaultJdbcMetadataFactory;
import io.trino.plugin.jdbc.IdentityCacheMapping;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import java.util.Objects;
import java.util.Set;

public class IgniteJdbcMetadataFactory
extends DefaultJdbcMetadataFactory {
    private final TimestampTimeZoneDomain timestampTimeZoneDomain;
    private final Set<JdbcQueryEventListener> jdbcQueryEventListeners;

    @Inject
    public IgniteJdbcMetadataFactory(JdbcClient jdbcClient, TimestampTimeZoneDomain timestampTimeZoneDomain, Set<JdbcQueryEventListener> jdbcQueryEventListeners, IdentityCacheMapping identityCacheMapping) {
        super(jdbcClient, timestampTimeZoneDomain, jdbcQueryEventListeners, identityCacheMapping);
        this.timestampTimeZoneDomain = Objects.requireNonNull(timestampTimeZoneDomain, "timestampTimeZoneDomain is null");
        this.jdbcQueryEventListeners = ImmutableSet.copyOf(jdbcQueryEventListeners);
    }

    protected JdbcMetadata create(JdbcClient transactionCachingJdbcClient) {
        return new IgniteMetadata(transactionCachingJdbcClient, this.timestampTimeZoneDomain, this.jdbcQueryEventListeners);
    }
}

