/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.ignite;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.plugin.ignite.IgniteMergeTableHandle;
import io.trino.plugin.ignite.IgniteOutputTableHandle;
import io.trino.plugin.jdbc.DefaultJdbcMetadata;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcMetadata;
import io.trino.plugin.jdbc.JdbcNamedRelationHandle;
import io.trino.plugin.jdbc.JdbcQueryEventListener;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnPosition;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableLayout;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.RetryMode;
import io.trino.spi.connector.SaveMode;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.type.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class IgniteMetadata
extends DefaultJdbcMetadata {
    private static final String IGNITE_DUMMY_ID = "dummy_id";
    private final JdbcClient igniteClient;

    public IgniteMetadata(JdbcClient igniteClient, TimestampTimeZoneDomain timestampTimeZoneDomain, Set<JdbcQueryEventListener> jdbcQueryEventListeners) {
        super(igniteClient, timestampTimeZoneDomain, false, jdbcQueryEventListeners);
        this.igniteClient = Objects.requireNonNull(igniteClient, "igniteClient is null");
    }

    public JdbcTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        return this.igniteClient.getTableHandle(session, schemaTableName).map(JdbcTableHandle::asPlainTable).map(JdbcNamedRelationHandle::getRemoteTableName).map(remoteTableName -> new JdbcTableHandle(schemaTableName, new RemoteTableName(remoteTableName.getCatalogName(), Optional.of(remoteTableName.getSchemaName().orElse("public")), remoteTableName.getTableName()), Optional.empty())).orElse(null);
    }

    public ConnectorInsertTableHandle beginInsert(ConnectorSession session, ConnectorTableHandle tableHandle, List<ColumnHandle> columns, RetryMode retryMode) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        Optional<String> dummyIdColumn = JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this.igniteClient, (JdbcTableHandle)handle).stream().map(JdbcColumnHandle::getColumnName).filter(IGNITE_DUMMY_ID::equalsIgnoreCase).findFirst();
        ImmutableList.Builder columnNames = ImmutableList.builder();
        ImmutableList.Builder columnTypes = ImmutableList.builder();
        ImmutableList.Builder columnJdbcTypeHandles = ImmutableList.builder();
        for (ColumnHandle column : columns) {
            JdbcColumnHandle columnHandle = (JdbcColumnHandle)column;
            if (IGNITE_DUMMY_ID.equalsIgnoreCase(columnHandle.getColumnName())) continue;
            columnNames.add((Object)columnHandle.getColumnName());
            columnTypes.add((Object)columnHandle.getColumnType());
            columnJdbcTypeHandles.add((Object)columnHandle.getJdbcTypeHandle());
        }
        RemoteTableName remoteTableName = handle.asPlainTable().getRemoteTableName();
        return new IgniteOutputTableHandle(remoteTableName, (List<String>)columnNames.build(), (List<Type>)columnTypes.build(), Optional.of(columnJdbcTypeHandles.build()), dummyIdColumn);
    }

    public Optional<ConnectorOutputMetadata> finishInsert(ConnectorSession session, ConnectorInsertTableHandle insertHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public ConnectorMergeTableHandle beginMerge(ConnectorSession session, ConnectorTableHandle tableHandle, Map<Integer, Collection<ColumnHandle>> updateColumnHandles, RetryMode retryMode) {
        JdbcTableHandle handle = (JdbcTableHandle)tableHandle;
        SchemaTableName schemaTableName = handle.getRequiredNamedRelation().getSchemaTableName();
        RemoteTableName remoteTableName = handle.getRequiredNamedRelation().getRemoteTableName();
        List primaryKeys = this.igniteClient.getPrimaryKeys(session, handle.getRequiredNamedRelation().getRemoteTableName());
        List columns = (List)this.igniteClient.getColumns(session, schemaTableName, remoteTableName).stream().filter(column -> !IGNITE_DUMMY_ID.equalsIgnoreCase(column.getColumnName())).collect(ImmutableList.toImmutableList());
        for (Collection<ColumnHandle> updateColumns : updateColumnHandles.values()) {
            for (ColumnHandle column2 : updateColumns) {
                Preconditions.checkArgument((boolean)columns.contains(column2), (Object)"the update column not found in the target table");
                Preconditions.checkArgument((!primaryKeys.contains(column2) ? 1 : 0) != 0, (Object)"Ignite does not allow update primary key");
            }
        }
        if (handle.getColumns().isPresent()) {
            handle = new JdbcTableHandle(handle.getRelationHandle(), handle.getConstraint(), handle.getConstraintExpressions(), handle.getSortOrder(), handle.getLimit(), Optional.of(columns), handle.getOtherReferencedTables(), handle.getNextSyntheticColumnId(), handle.getAuthorization(), handle.getUpdateAssignments());
        }
        return new IgniteMergeTableHandle(handle, (IgniteOutputTableHandle)this.beginInsert(session, (ConnectorTableHandle)new JdbcTableHandle(schemaTableName, remoteTableName, Optional.empty()), (List<ColumnHandle>)ImmutableList.copyOf((Collection)columns), retryMode), primaryKeys, columns, updateColumnHandles);
    }

    public void finishMerge(ConnectorSession session, ConnectorMergeTableHandle tableHandle, List<ConnectorTableHandle> sourceTableHandles, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableMetadata(handle.getRequiredNamedRelation().getSchemaTableName(), this.getColumnMetadata(session, handle), this.igniteClient.getTableProperties(session, handle));
    }

    public List<ColumnMetadata> getColumnMetadata(ConnectorSession session, JdbcTableHandle handle) {
        return (List)JdbcMetadata.getColumns((ConnectorSession)session, (JdbcClient)this.igniteClient, (JdbcTableHandle)handle).stream().filter(column -> !IGNITE_DUMMY_ID.equalsIgnoreCase(column.getColumnName())).map(JdbcColumnHandle::getColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    public ConnectorTableSchema getTableSchema(ConnectorSession session, ConnectorTableHandle table) {
        JdbcTableHandle handle = (JdbcTableHandle)table;
        return new ConnectorTableSchema(handle.getRequiredNamedRelation().getSchemaTableName(), (List)this.getColumnMetadata(session, handle).stream().map(ColumnMetadata::getColumnSchema).collect(ImmutableList.toImmutableList()));
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, SaveMode saveMode) {
        if (saveMode == SaveMode.REPLACE) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        this.igniteClient.beginCreateTable(session, tableMetadata);
    }

    public ConnectorOutputTableHandle beginCreateTable(ConnectorSession session, ConnectorTableMetadata tableMetadata, Optional<ConnectorTableLayout> layout, RetryMode retryMode, boolean replace) {
        if (retryMode != RetryMode.NO_RETRIES) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support query retries");
        }
        if (replace) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support replacing tables");
        }
        return this.igniteClient.beginCreateTable(session, tableMetadata);
    }

    public Optional<ConnectorOutputMetadata> finishCreateTable(ConnectorSession session, ConnectorOutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        return Optional.empty();
    }

    public void setColumnType(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column, Type type) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support setting column types");
    }

    public void dropNotNullConstraint(ConnectorSession session, ConnectorTableHandle table, ColumnHandle column) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support dropping a not null constraint");
    }

    public void addColumn(ConnectorSession session, ConnectorTableHandle table, ColumnMetadata columnMetadata, ColumnPosition position) {
        if (!columnMetadata.isNullable()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding not null columns");
        }
        ColumnPosition columnPosition = position;
        Objects.requireNonNull(columnPosition);
        ColumnPosition columnPosition2 = columnPosition;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ColumnPosition.First.class, ColumnPosition.After.class, ColumnPosition.Last.class}, (ColumnPosition)columnPosition2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with FIRST clause");
            }
            case 1: {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support adding columns with AFTER clause");
            }
            case 2: 
        }
        JdbcTableHandle handle = (JdbcTableHandle)table;
        this.igniteClient.addColumn(session, handle, columnMetadata, position);
    }
}

