/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public final class ConfiguringConnectionFactory
implements ConnectionFactory {
    private final ConnectionFactory delegate;
    private final Configurator configurator;

    public ConfiguringConnectionFactory(ConnectionFactory delegate, Configurator configurator) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.configurator = Objects.requireNonNull(configurator, "configurator is null");
    }

    @Override
    public Connection openConnection(ConnectorSession session) throws SQLException {
        Connection connection = this.delegate.openConnection(session);
        try {
            this.configurator.configure(connection);
        }
        catch (RuntimeException | SQLException e) {
            Connection connection2 = connection;
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (connection2 != null) {
                    try {
                        connection2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return connection;
    }

    @Override
    public void close() throws SQLException {
        this.delegate.close();
    }

    @FunctionalInterface
    public static interface Configurator {
        public void configure(Connection var1) throws SQLException;
    }
}

