/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.jodah.failsafe;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.net.jodah.failsafe.Policy;
import io.trino.jdbc.$internal.net.jodah.failsafe.PolicyExecutor;
import io.trino.jdbc.$internal.net.jodah.failsafe.PolicyListeners;
import io.trino.jdbc.$internal.net.jodah.failsafe.TimeoutExecutor;
import io.trino.jdbc.$internal.net.jodah.failsafe.internal.util.Assert;
import java.time.Duration;

public class Timeout<R>
extends PolicyListeners<Timeout<R>, R>
implements Policy<R> {
    private final Duration timeout;
    private volatile boolean cancellable;
    private volatile boolean interruptable;

    private Timeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public boolean canCancel() {
        return this.cancellable;
    }

    public boolean canInterrupt() {
        return this.interruptable;
    }

    public Timeout<R> withCancel(boolean mayInterruptIfRunning) {
        this.cancellable = true;
        this.interruptable = mayInterruptIfRunning;
        return this;
    }

    public static <R> Timeout<R> of(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new Timeout<R>(timeout);
    }

    @Override
    public PolicyExecutor toExecutor(.AbstractExecution execution) {
        return new TimeoutExecutor(this, execution);
    }
}

