/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.OkHttpUtil;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.ConnectionProperties;
import io.trino.jdbc.QueryExecutor;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoDriverUri;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrinoDriver
implements Driver,
Closeable {
    static final String DRIVER_NAME = "Trino JDBC Driver";
    static final String DRIVER_VERSION;
    static final int DRIVER_VERSION_MAJOR;
    static final int DRIVER_VERSION_MINOR;
    private final OkHttpClient httpClient = this.newHttpClient();

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        TrinoDriverUri uri = TrinoDriverUri.create(url, info);
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        uri.setupClient(builder);
        QueryExecutor executor = new QueryExecutor(builder.build());
        return new TrinoConnection(uri, executor);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return TrinoDriverUri.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties properties = TrinoDriverUri.create(url, info).getProperties();
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        return DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private OkHttpClient newHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(OkHttpUtil.userAgent("Trino JDBC Driver/" + DRIVER_VERSION));
        OkHttpUtil.setupChannelSocket(builder);
        return builder.build();
    }

    static {
        String implementationVersion = TrinoDriver.class.getPackage().getImplementationVersion();
        DRIVER_VERSION = implementationVersion == null ? "unknown" : implementationVersion;
        Matcher matcher = Pattern.compile("^(\\d+)(\\.(\\d+))?($|[.-])").matcher(DRIVER_VERSION);
        if (!matcher.find()) {
            DRIVER_VERSION_MAJOR = 0;
            DRIVER_VERSION_MINOR = 0;
        } else {
            DRIVER_VERSION_MAJOR = Integer.parseInt(matcher.group(1));
            DRIVER_VERSION_MINOR = Integer.parseInt(MoreObjects.firstNonNull(matcher.group(3), "0"));
        }
        try {
            DriverManager.registerDriver(new TrinoDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

