package io.trino.jdbc.$internal.jackson.datatype.joda.ser;

import java.io.IOException;

import io.trino.jdbc.$internal.joda.time.DateTimeZone;

import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.core.type.WritableTypeId;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.jsontype.TypeSerializer;

public class DateTimeZoneSerializer extends JodaSerializerBase<DateTimeZone>
{
    private static final long serialVersionUID = 1L;

    public DateTimeZoneSerializer() { super(DateTimeZone.class); }

    @Override
    public void serialize(DateTimeZone value, JsonGenerator gen, SerializerProvider provider) throws IOException
    {
        gen.writeString(value.getID());
    }

    // as per [datatype-joda#82], need to ensure we will indicate nominal, NOT physical type:
    @Override
    public void serializeWithType(DateTimeZone value, JsonGenerator g,
            SerializerProvider provider, TypeSerializer typeSer) throws IOException
    {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g,
                typeSer.typeId(value, DateTimeZone.class, JsonToken.VALUE_STRING));
        serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }
}
