/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.airlift.units.Duration;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.guava.base.CharMatcher;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.ImmutableSet;
import io.trino.jdbc.$internal.guava.collect.Maps;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import io.trino.jdbc.AbstractConnectionProperty;
import io.trino.jdbc.ConnectionProperty;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class ConnectionProperties {
    public static final ConnectionProperty<String> USER = new User();
    public static final ConnectionProperty<String> PASSWORD = new Password();
    public static final ConnectionProperty<String> SESSION_USER = new SessionUser();
    public static final ConnectionProperty<Map<String, ClientSelectedRole>> ROLES = new Roles();
    public static final ConnectionProperty<HostAndPort> SOCKS_PROXY = new SocksProxy();
    public static final ConnectionProperty<HostAndPort> HTTP_PROXY = new HttpProxy();
    public static final ConnectionProperty<String> APPLICATION_NAME_PREFIX = new ApplicationNamePrefix();
    public static final ConnectionProperty<Boolean> DISABLE_COMPRESSION = new DisableCompression();
    public static final ConnectionProperty<Boolean> SSL = new Ssl();
    public static final ConnectionProperty<SslVerificationMode> SSL_VERIFICATION = new SslVerification();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PATH = new SslKeyStorePath();
    public static final ConnectionProperty<String> SSL_KEY_STORE_PASSWORD = new SslKeyStorePassword();
    public static final ConnectionProperty<String> SSL_KEY_STORE_TYPE = new SslKeyStoreType();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PATH = new SslTrustStorePath();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_PASSWORD = new SslTrustStorePassword();
    public static final ConnectionProperty<String> SSL_TRUST_STORE_TYPE = new SslTrustStoreType();
    public static final ConnectionProperty<String> KERBEROS_SERVICE_PRINCIPAL_PATTERN = new KerberosServicePrincipalPattern();
    public static final ConnectionProperty<String> KERBEROS_REMOTE_SERVICE_NAME = new KerberosRemoteServiceName();
    public static final ConnectionProperty<Boolean> KERBEROS_USE_CANONICAL_HOSTNAME = new KerberosUseCanonicalHostname();
    public static final ConnectionProperty<String> KERBEROS_PRINCIPAL = new KerberosPrincipal();
    public static final ConnectionProperty<File> KERBEROS_CONFIG_PATH = new KerberosConfigPath();
    public static final ConnectionProperty<File> KERBEROS_KEYTAB_PATH = new KerberosKeytabPath();
    public static final ConnectionProperty<File> KERBEROS_CREDENTIAL_CACHE_PATH = new KerberosCredentialCachePath();
    public static final ConnectionProperty<String> ACCESS_TOKEN = new AccessToken();
    public static final ConnectionProperty<Boolean> EXTERNAL_AUTHENTICATION = new ExternalAuthentication();
    public static final ConnectionProperty<Duration> EXTERNAL_AUTHENTICATION_TIMEOUT = new ExternalAuthenticationTimeout();
    public static final ConnectionProperty<Map<String, String>> EXTRA_CREDENTIALS = new ExtraCredentials();
    public static final ConnectionProperty<String> CLIENT_INFO = new ClientInfo();
    public static final ConnectionProperty<String> CLIENT_TAGS = new ClientTags();
    public static final ConnectionProperty<String> TRACE_TOKEN = new TraceToken();
    public static final ConnectionProperty<Map<String, String>> SESSION_PROPERTIES = new SessionProperties();
    public static final ConnectionProperty<String> SOURCE = new Source();
    private static final Set<ConnectionProperty<?>> ALL_PROPERTIES = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add(USER)).add(PASSWORD)).add(SESSION_USER)).add(ROLES)).add(SOCKS_PROXY)).add(HTTP_PROXY)).add(APPLICATION_NAME_PREFIX)).add(DISABLE_COMPRESSION)).add(SSL)).add(SSL_VERIFICATION)).add(SSL_KEY_STORE_PATH)).add(SSL_KEY_STORE_PASSWORD)).add(SSL_KEY_STORE_TYPE)).add(SSL_TRUST_STORE_PATH)).add(SSL_TRUST_STORE_PASSWORD)).add(SSL_TRUST_STORE_TYPE)).add(KERBEROS_REMOTE_SERVICE_NAME)).add(KERBEROS_SERVICE_PRINCIPAL_PATTERN)).add(KERBEROS_USE_CANONICAL_HOSTNAME)).add(KERBEROS_PRINCIPAL)).add(KERBEROS_CONFIG_PATH)).add(KERBEROS_KEYTAB_PATH)).add(KERBEROS_CREDENTIAL_CACHE_PATH)).add(ACCESS_TOKEN)).add(EXTRA_CREDENTIALS)).add(CLIENT_INFO)).add(CLIENT_TAGS)).add(TRACE_TOKEN)).add(SESSION_PROPERTIES)).add(SOURCE)).add(EXTERNAL_AUTHENTICATION)).add(EXTERNAL_AUTHENTICATION_TIMEOUT)).build();
    private static final Map<String, ConnectionProperty<?>> KEY_LOOKUP = Collections.unmodifiableMap(ALL_PROPERTIES.stream().collect(Collectors.toMap(ConnectionProperty::getKey, Function.identity())));
    private static final Map<String, String> DEFAULTS;

    private ConnectionProperties() {
    }

    public static ConnectionProperty<?> forKey(String propertiesKey) {
        return KEY_LOOKUP.get(propertiesKey);
    }

    public static Set<ConnectionProperty<?>> allProperties() {
        return ALL_PROPERTIES;
    }

    public static Map<String, String> getDefaults() {
        return DEFAULTS;
    }

    private static Predicate<Properties> isKerberosEnabled() {
        return AbstractConnectionProperty.checkedPredicate(properties -> KERBEROS_REMOTE_SERVICE_NAME.getValue((Properties)properties).isPresent());
    }

    static {
        ImmutableMap.Builder defaults = ImmutableMap.builder();
        for (ConnectionProperty<?> property : ALL_PROPERTIES) {
            property.getDefault().ifPresent(value -> defaults.put(property.getKey(), value));
        }
        DEFAULTS = defaults.build();
    }

    private static class MapPropertyParser {
        private static final CharMatcher PRINTABLE_ASCII = CharMatcher.inRange('!', '~');
        private static final Splitter MAP_ENTRIES_SPLITTER = Splitter.on(';');
        private static final Splitter MAP_ENTRY_SPLITTER = Splitter.on(':');
        private final String mapName;

        private MapPropertyParser(String mapName) {
            this.mapName = Objects.requireNonNull(mapName, "mapName is null");
        }

        public Map<String, String> parse(String map) {
            return MAP_ENTRIES_SPLITTER.splitToList(map).stream().map(this::parseEntry).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        private Map.Entry<String, String> parseEntry(String credential) {
            List<String> keyValue = MAP_ENTRY_SPLITTER.limit(2).splitToList(credential);
            Preconditions.checkArgument(keyValue.size() == 2, "Malformed %s: %s", (Object)this.mapName, (Object)credential);
            String key = keyValue.get(0);
            String value = keyValue.get(1);
            Preconditions.checkArgument(!key.isEmpty(), "%s key is empty", (Object)this.mapName);
            Preconditions.checkArgument(!value.isEmpty(), "%s key is empty", (Object)this.mapName);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(key), "%s key '%s' contains spaces or is not printable ASCII", (Object)this.mapName, (Object)key);
            Preconditions.checkArgument(PRINTABLE_ASCII.matchesAllOf(value), "%s value for key '%s' contains spaces or is not printable ASCII", (Object)this.mapName, (Object)key);
            return Maps.immutableEntry(key, value);
        }
    }

    private static class Source
    extends AbstractConnectionProperty<String> {
        public Source() {
            super("source", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class SessionProperties
    extends AbstractConnectionProperty<Map<String, String>> {
        private static final Splitter NAME_PARTS_SPLITTER = Splitter.on('.');

        public SessionProperties() {
            super("sessionProperties", NOT_REQUIRED, ALLOWED, SessionProperties::parseSessionProperties);
        }

        public static Map<String, String> parseSessionProperties(String sessionPropertiesString) {
            Map<String, String> sessionProperties = new MapPropertyParser("sessionProperties").parse(sessionPropertiesString);
            for (String sessionPropertyName : sessionProperties.keySet()) {
                Preconditions.checkArgument(NAME_PARTS_SPLITTER.splitToList(sessionPropertyName).size() <= 2, "Malformed session property name: %s", (Object)sessionPropertyName);
            }
            return sessionProperties;
        }
    }

    private static class ExtraCredentials
    extends AbstractConnectionProperty<Map<String, String>> {
        public ExtraCredentials() {
            super("extraCredentials", NOT_REQUIRED, ALLOWED, ExtraCredentials::parseExtraCredentials);
        }

        public static Map<String, String> parseExtraCredentials(String extraCredentialString) {
            return new MapPropertyParser("extraCredentials").parse(extraCredentialString);
        }
    }

    private static class ExternalAuthenticationTimeout
    extends AbstractConnectionProperty<Duration> {
        private static final Predicate<Properties> IF_EXTERNAL_AUTHENTICATION_ENABLED = ExternalAuthenticationTimeout.checkedPredicate(properties -> EXTERNAL_AUTHENTICATION.getValue((Properties)properties).orElse(false));

        public ExternalAuthenticationTimeout() {
            super("externalAuthenticationTimeout", NOT_REQUIRED, IF_EXTERNAL_AUTHENTICATION_ENABLED, Duration::valueOf);
        }
    }

    private static class ExternalAuthentication
    extends AbstractConnectionProperty<Boolean> {
        public ExternalAuthentication() {
            super("externalAuthentication", Optional.of("false"), NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class AccessToken
    extends AbstractConnectionProperty<String> {
        public AccessToken() {
            super("accessToken", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class KerberosCredentialCachePath
    extends AbstractConnectionProperty<File> {
        public KerberosCredentialCachePath() {
            super("KerberosCredentialCachePath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosKeytabPath
    extends AbstractConnectionProperty<File> {
        public KerberosKeytabPath() {
            super("KerberosKeytabPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosConfigPath
    extends AbstractConnectionProperty<File> {
        public KerberosConfigPath() {
            super("KerberosConfigPath", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), FILE_CONVERTER);
        }
    }

    private static class KerberosUseCanonicalHostname
    extends AbstractConnectionProperty<Boolean> {
        public KerberosUseCanonicalHostname() {
            super("KerberosUseCanonicalHostname", Optional.of("true"), ConnectionProperties.isKerberosEnabled(), ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class KerberosPrincipal
    extends AbstractConnectionProperty<String> {
        public KerberosPrincipal() {
            super("KerberosPrincipal", NOT_REQUIRED, ConnectionProperties.isKerberosEnabled(), STRING_CONVERTER);
        }
    }

    private static class KerberosServicePrincipalPattern
    extends AbstractConnectionProperty<String> {
        public KerberosServicePrincipalPattern() {
            super("KerberosServicePrincipalPattern", Optional.of("${SERVICE}@${HOST}"), ConnectionProperties.isKerberosEnabled(), ALLOWED, STRING_CONVERTER);
        }
    }

    private static class KerberosRemoteServiceName
    extends AbstractConnectionProperty<String> {
        public KerberosRemoteServiceName() {
            super("KerberosRemoteServiceName", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class SslTrustStoreType
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_TRUST_STORE = SslTrustStoreType.checkedPredicate(properties -> SSL_TRUST_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslTrustStoreType() {
            super("SSLTrustStoreType", NOT_REQUIRED, IF_TRUST_STORE.and(SslVerification.IF_SSL_VERIFICATION_ENABLED), STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_TRUST_STORE = SslTrustStorePassword.checkedPredicate(properties -> SSL_TRUST_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslTrustStorePassword() {
            super("SSLTrustStorePassword", NOT_REQUIRED, IF_TRUST_STORE.and(SslVerification.IF_SSL_VERIFICATION_ENABLED), STRING_CONVERTER);
        }
    }

    private static class SslTrustStorePath
    extends AbstractConnectionProperty<String> {
        public SslTrustStorePath() {
            super("SSLTrustStorePath", NOT_REQUIRED, SslVerification.IF_SSL_VERIFICATION_ENABLED, STRING_CONVERTER);
        }
    }

    private static class SslKeyStoreType
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_KEY_STORE = SslKeyStoreType.checkedPredicate(properties -> SSL_KEY_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslKeyStoreType() {
            super("SSLKeyStoreType", NOT_REQUIRED, IF_KEY_STORE.and(SslVerification.IF_SSL_VERIFICATION_ENABLED), STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePassword
    extends AbstractConnectionProperty<String> {
        private static final Predicate<Properties> IF_KEY_STORE = SslKeyStorePassword.checkedPredicate(properties -> SSL_KEY_STORE_PATH.getValue((Properties)properties).isPresent());

        public SslKeyStorePassword() {
            super("SSLKeyStorePassword", NOT_REQUIRED, IF_KEY_STORE.and(SslVerification.IF_SSL_VERIFICATION_ENABLED), STRING_CONVERTER);
        }
    }

    private static class SslKeyStorePath
    extends AbstractConnectionProperty<String> {
        public SslKeyStorePath() {
            super("SSLKeyStorePath", NOT_REQUIRED, SslVerification.IF_SSL_VERIFICATION_ENABLED, STRING_CONVERTER);
        }
    }

    private static class SslVerification
    extends AbstractConnectionProperty<SslVerificationMode> {
        private static final Predicate<Properties> IF_SSL_ENABLED = SslVerification.checkedPredicate(properties -> SSL.getValue((Properties)properties).orElse(false));
        static final Predicate<Properties> IF_SSL_VERIFICATION_ENABLED = IF_SSL_ENABLED.and(SslVerification.checkedPredicate(properties -> !SSL_VERIFICATION.getValue((Properties)properties).orElse(SslVerificationMode.FULL).equals((Object)SslVerificationMode.NONE)));

        public SslVerification() {
            super("SSLVerification", NOT_REQUIRED, IF_SSL_ENABLED, SslVerificationMode::valueOf);
        }
    }

    private static class Ssl
    extends AbstractConnectionProperty<Boolean> {
        public Ssl() {
            super("SSL", NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class DisableCompression
    extends AbstractConnectionProperty<Boolean> {
        public DisableCompression() {
            super("disableCompression", NOT_REQUIRED, ALLOWED, BOOLEAN_CONVERTER);
        }
    }

    private static class TraceToken
    extends AbstractConnectionProperty<String> {
        public TraceToken() {
            super("traceToken", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class ClientTags
    extends AbstractConnectionProperty<String> {
        public ClientTags() {
            super("clientTags", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class ClientInfo
    extends AbstractConnectionProperty<String> {
        public ClientInfo() {
            super("clientInfo", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class ApplicationNamePrefix
    extends AbstractConnectionProperty<String> {
        public ApplicationNamePrefix() {
            super("applicationNamePrefix", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class HttpProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_SOCKS_PROXY = HttpProxy.checkedPredicate(properties -> !SOCKS_PROXY.getValue((Properties)properties).isPresent());

        public HttpProxy() {
            super("httpProxy", NOT_REQUIRED, NO_SOCKS_PROXY, HostAndPort::fromString);
        }
    }

    private static class SocksProxy
    extends AbstractConnectionProperty<HostAndPort> {
        private static final Predicate<Properties> NO_HTTP_PROXY = SocksProxy.checkedPredicate(properties -> !HTTP_PROXY.getValue((Properties)properties).isPresent());

        public SocksProxy() {
            super("socksProxy", NOT_REQUIRED, NO_HTTP_PROXY, HostAndPort::fromString);
        }
    }

    private static class Roles
    extends AbstractConnectionProperty<Map<String, ClientSelectedRole>> {
        public Roles() {
            super("roles", NOT_REQUIRED, ALLOWED, Roles::parseRoles);
        }

        public static Map<String, ClientSelectedRole> parseRoles(String roles) {
            return new MapPropertyParser("roles").parse(roles).entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> Roles.mapToClientSelectedRole((String)entry.getValue())));
        }

        private static ClientSelectedRole mapToClientSelectedRole(String role) {
            Preconditions.checkArgument(!role.contains("\""), "Role must not contain double quotes: %s", (Object)role);
            if (ClientSelectedRole.Type.ALL.name().equalsIgnoreCase(role)) {
                return new ClientSelectedRole(ClientSelectedRole.Type.ALL, Optional.empty());
            }
            if (ClientSelectedRole.Type.NONE.name().equalsIgnoreCase(role)) {
                return new ClientSelectedRole(ClientSelectedRole.Type.NONE, Optional.empty());
            }
            return new ClientSelectedRole(ClientSelectedRole.Type.ROLE, Optional.of(role));
        }
    }

    private static class SessionUser
    extends AbstractConnectionProperty<String> {
        protected SessionUser() {
            super("sessionUser", NOT_REQUIRED, ALLOWED, NON_EMPTY_STRING_CONVERTER);
        }
    }

    private static class Password
    extends AbstractConnectionProperty<String> {
        public Password() {
            super("password", NOT_REQUIRED, ALLOWED, STRING_CONVERTER);
        }
    }

    private static class User
    extends AbstractConnectionProperty<String> {
        public User() {
            super("user", REQUIRED, ALLOWED, NON_EMPTY_STRING_CONVERTER);
        }
    }

    static enum SslVerificationMode {
        FULL,
        CA,
        NONE;

    }
}

