package io.trino.jdbc.$internal.jackson.datatype.joda.deser.key;

import io.trino.jdbc.$internal.jackson.databind.DeserializationContext;

import java.io.IOException;

public class DurationKeyDeserializer extends JodaKeyDeserializer {
    private static final long serialVersionUID = 1L;

    @Override
    protected Object deserialize(String key, DeserializationContext ctxt) throws IOException {
        return PERIOD_FORMAT.parsePeriod(ctxt, key).toStandardDuration();
    }
}
