/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.ClientSelectedRole;
import io.trino.jdbc.$internal.client.KerberosUtil;
import io.trino.jdbc.$internal.client.OkHttpUtil;
import io.trino.jdbc.$internal.client.auth.external.DesktopBrowserRedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.ExternalAuthenticator;
import io.trino.jdbc.$internal.client.auth.external.HttpTokenPoller;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.base.Strings;
import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import io.trino.jdbc.$internal.guava.collect.Maps;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.ConnectionProperties;
import io.trino.jdbc.ConnectionProperty;
import io.trino.jdbc.KnownTokenCache;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;

public final class TrinoDriverUri {
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private static final String JDBC_URL_START = "jdbc:trino:";
    private static final String LEGACY_JDBC_URL_START = "jdbc:presto:";
    private static final Splitter QUERY_SPLITTER = Splitter.on('&').omitEmptyStrings();
    private static final Splitter ARG_SPLITTER = Splitter.on('=').limit(2);
    private static final AtomicReference<RedirectHandler> REDIRECT_HANDLER = new AtomicReference<DesktopBrowserRedirectHandler>(new DesktopBrowserRedirectHandler());
    private final HostAndPort address;
    private final URI uri;
    private final Properties properties;
    private Optional<String> catalog = Optional.empty();
    private Optional<String> schema = Optional.empty();
    private final boolean useSecureConnection;

    private TrinoDriverUri(String url, Properties driverProperties) throws SQLException {
        this(TrinoDriverUri.parseDriverUrl(url), driverProperties);
    }

    private TrinoDriverUri(URI uri, Properties driverProperties) throws SQLException {
        this.uri = Objects.requireNonNull(uri, "uri is null");
        this.address = HostAndPort.fromParts(uri.getHost(), uri.getPort());
        this.properties = TrinoDriverUri.mergeConnectionProperties(uri, driverProperties);
        TrinoDriverUri.validateConnectionProperties(this.properties);
        this.useSecureConnection = ConnectionProperties.SSL.getValue(this.properties).orElse(uri.getPort() == 443);
        this.initCatalogAndSchema();
    }

    public static TrinoDriverUri create(String url, Properties properties) throws SQLException {
        return new TrinoDriverUri(url, MoreObjects.firstNonNull(properties, new Properties()));
    }

    public static boolean acceptsURL(String url) {
        return url.startsWith(JDBC_URL_START) || url.startsWith(LEGACY_JDBC_URL_START);
    }

    public URI getJdbcUri() {
        return this.uri;
    }

    public Optional<String> getSchema() {
        return this.schema;
    }

    public Optional<String> getCatalog() {
        return this.catalog;
    }

    public URI getHttpUri() {
        return this.buildHttpUri();
    }

    public String getUser() throws SQLException {
        return ConnectionProperties.USER.getRequiredValue(this.properties);
    }

    public Optional<String> getSessionUser() throws SQLException {
        return ConnectionProperties.SESSION_USER.getValue(this.properties);
    }

    public Map<String, ClientSelectedRole> getRoles() throws SQLException {
        return ConnectionProperties.ROLES.getValue(this.properties).orElse(ImmutableMap.of());
    }

    public Optional<String> getApplicationNamePrefix() throws SQLException {
        return ConnectionProperties.APPLICATION_NAME_PREFIX.getValue(this.properties);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<String, String> getExtraCredentials() throws SQLException {
        return ConnectionProperties.EXTRA_CREDENTIALS.getValue(this.properties).orElse(ImmutableMap.of());
    }

    public Optional<String> getClientInfo() throws SQLException {
        return ConnectionProperties.CLIENT_INFO.getValue(this.properties);
    }

    public Optional<String> getClientTags() throws SQLException {
        return ConnectionProperties.CLIENT_TAGS.getValue(this.properties);
    }

    public Optional<String> getTraceToken() throws SQLException {
        return ConnectionProperties.TRACE_TOKEN.getValue(this.properties);
    }

    public Map<String, String> getSessionProperties() throws SQLException {
        return ConnectionProperties.SESSION_PROPERTIES.getValue(this.properties).orElse(ImmutableMap.of());
    }

    public Optional<String> getSource() throws SQLException {
        return ConnectionProperties.SOURCE.getValue(this.properties);
    }

    public boolean isCompressionDisabled() throws SQLException {
        return ConnectionProperties.DISABLE_COMPRESSION.getValue(this.properties).orElse(false);
    }

    public boolean isAssumeLiteralNamesInMetadataCallsForNonConformingClients() throws SQLException {
        return ConnectionProperties.ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS.getValue(this.properties).orElse(false);
    }

    public void setupClient(OkHttpClient.Builder builder) throws SQLException {
        try {
            OkHttpUtil.setupCookieJar(builder);
            OkHttpUtil.setupSocksProxy(builder, ConnectionProperties.SOCKS_PROXY.getValue(this.properties));
            OkHttpUtil.setupHttpProxy(builder, ConnectionProperties.HTTP_PROXY.getValue(this.properties));
            String password = ConnectionProperties.PASSWORD.getValue(this.properties).orElse("");
            if (!password.isEmpty() && !password.equals("***empty***")) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using username/password requires SSL to be enabled");
                }
                builder.addInterceptor(OkHttpUtil.basicAuth(this.getUser(), password));
            }
            if (this.useSecureConnection) {
                ConnectionProperties.SslVerificationMode sslVerificationMode = ConnectionProperties.SSL_VERIFICATION.getValue(this.properties).orElse(ConnectionProperties.SslVerificationMode.FULL);
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.FULL) || sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                    OkHttpUtil.setupSsl(builder, ConnectionProperties.SSL_KEY_STORE_PATH.getValue(this.properties), ConnectionProperties.SSL_KEY_STORE_PASSWORD.getValue(this.properties), ConnectionProperties.SSL_KEY_STORE_TYPE.getValue(this.properties), ConnectionProperties.SSL_TRUST_STORE_PATH.getValue(this.properties), ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getValue(this.properties), ConnectionProperties.SSL_TRUST_STORE_TYPE.getValue(this.properties));
                }
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.CA)) {
                    builder.hostnameVerifier((hostname, session) -> true);
                }
                if (sslVerificationMode.equals((Object)ConnectionProperties.SslVerificationMode.NONE)) {
                    OkHttpUtil.setupInsecureSsl(builder);
                }
            }
            if (ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getValue(this.properties).isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using Kerberos requires SSL to be enabled");
                }
                OkHttpUtil.setupKerberos(builder, ConnectionProperties.KERBEROS_SERVICE_PRINCIPAL_PATTERN.getRequiredValue(this.properties), ConnectionProperties.KERBEROS_REMOTE_SERVICE_NAME.getRequiredValue(this.properties), ConnectionProperties.KERBEROS_USE_CANONICAL_HOSTNAME.getRequiredValue(this.properties), ConnectionProperties.KERBEROS_PRINCIPAL.getValue(this.properties), ConnectionProperties.KERBEROS_CONFIG_PATH.getValue(this.properties), ConnectionProperties.KERBEROS_KEYTAB_PATH.getValue(this.properties), Optional.ofNullable(ConnectionProperties.KERBEROS_CREDENTIAL_CACHE_PATH.getValue(this.properties).orElseGet(() -> KerberosUtil.defaultCredentialCachePath().map(File::new).orElse(null))));
            }
            if (ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).isPresent()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using an access token requires SSL to be enabled");
                }
                builder.addInterceptor(OkHttpUtil.tokenAuth(ConnectionProperties.ACCESS_TOKEN.getValue(this.properties).get()));
            }
            if (ConnectionProperties.EXTERNAL_AUTHENTICATION.getValue(this.properties).orElse(false).booleanValue()) {
                if (!this.useSecureConnection) {
                    throw new SQLException("Authentication using external authorization requires SSL to be enabled");
                }
                HttpTokenPoller poller = new HttpTokenPoller(builder.build());
                Duration timeout = ConnectionProperties.EXTERNAL_AUTHENTICATION_TIMEOUT.getValue(this.properties).map(value -> Duration.ofMillis(value.toMillis())).orElse(Duration.ofMinutes(2L));
                KnownTokenCache knownTokenCache = ConnectionProperties.EXTERNAL_AUTHENTICATION_TOKEN_CACHE.getValue(this.properties).get();
                ExternalAuthenticator authenticator = new ExternalAuthenticator(REDIRECT_HANDLER.get(), poller, knownTokenCache.create(), timeout);
                builder.authenticator(authenticator);
                builder.addInterceptor(authenticator);
            }
        }
        catch (ClientException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new SQLException("Error setting up connection", e);
        }
    }

    private static Map<String, String> parseParameters(String query) throws SQLException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query != null) {
            Iterable<String> queryArgs = QUERY_SPLITTER.split(query);
            for (String queryArg : queryArgs) {
                List<String> parts = ARG_SPLITTER.splitToList(queryArg);
                if (parts.size() != 2) {
                    throw new SQLException(String.format("Connection argument is not valid connection property: '%s'", queryArg));
                }
                if (result.put(parts.get(0), parts.get(1)) == null) continue;
                throw new SQLException(String.format("Connection property '%s' is in URL multiple times", parts.get(0)));
            }
        }
        return result;
    }

    private static URI parseDriverUrl(String url) throws SQLException {
        URI uri;
        if (!url.startsWith(JDBC_URL_START) && !url.startsWith(LEGACY_JDBC_URL_START)) {
            throw new SQLException("Invalid JDBC URL: " + url);
        }
        if (url.equals(JDBC_URL_START) || url.equals(LEGACY_JDBC_URL_START)) {
            throw new SQLException("Empty JDBC URL: " + url);
        }
        try {
            uri = new URI(url.substring(JDBC_URL_PREFIX.length()));
        }
        catch (URISyntaxException e) {
            throw new SQLException("Invalid JDBC URL: " + url, e);
        }
        if (Strings.isNullOrEmpty(uri.getHost())) {
            throw new SQLException("No host specified: " + url);
        }
        if (uri.getPort() == -1) {
            throw new SQLException("No port number specified: " + url);
        }
        if (uri.getPort() < 1 || uri.getPort() > 65535) {
            throw new SQLException("Invalid port number: " + url);
        }
        return uri;
    }

    private URI buildHttpUri() {
        String scheme = this.useSecureConnection ? "https" : "http";
        try {
            return new URI(scheme, null, this.address.getHost(), this.address.getPort(), null, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private void initCatalogAndSchema() throws SQLException {
        String path = this.uri.getPath();
        if (Strings.isNullOrEmpty(this.uri.getPath()) || path.equals("/")) {
            return;
        }
        if (!path.startsWith("/")) {
            throw new SQLException("Path does not start with a slash: " + this.uri);
        }
        path = path.substring(1);
        List<String> parts = Splitter.on("/").splitToList(path);
        if (parts.get(parts.size() - 1).isEmpty()) {
            parts = parts.subList(0, parts.size() - 1);
        }
        if (parts.size() > 2) {
            throw new SQLException("Invalid path segments in URL: " + this.uri);
        }
        if (parts.get(0).isEmpty()) {
            throw new SQLException("Catalog name is empty: " + this.uri);
        }
        this.catalog = Optional.ofNullable(parts.get(0));
        if (parts.size() > 1) {
            if (parts.get(1).isEmpty()) {
                throw new SQLException("Schema name is empty: " + this.uri);
            }
            this.schema = Optional.ofNullable(parts.get(1));
        }
    }

    private static Properties mergeConnectionProperties(URI uri, Properties driverProperties) throws SQLException {
        Map<String, String> defaults = ConnectionProperties.getDefaults();
        Map<String, String> urlProperties = TrinoDriverUri.parseParameters(uri.getQuery());
        ImmutableMap<String, String> suppliedProperties = Maps.fromProperties(driverProperties);
        for (String key : urlProperties.keySet()) {
            if (!suppliedProperties.containsKey(key)) continue;
            throw new SQLException(String.format("Connection property '%s' is both in the URL and an argument", key));
        }
        Properties result = new Properties();
        TrinoDriverUri.setProperties(result, defaults);
        TrinoDriverUri.setProperties(result, urlProperties);
        TrinoDriverUri.setProperties(result, suppliedProperties);
        return result;
    }

    private static void setProperties(Properties properties, Map<String, String> values) {
        for (Map.Entry<String, String> entry : values.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private static void validateConnectionProperties(Properties connectionProperties) throws SQLException {
        for (String string : connectionProperties.stringPropertyNames()) {
            if (ConnectionProperties.forKey(string) != null) continue;
            throw new SQLException(String.format("Unrecognized connection property '%s'", string));
        }
        for (ConnectionProperty connectionProperty : ConnectionProperties.allProperties()) {
            connectionProperty.validate(connectionProperties);
        }
    }

    @.VisibleForTesting
    static void setRedirectHandler(RedirectHandler handler) {
        REDIRECT_HANDLER.set(Objects.requireNonNull(handler, "handler is null"));
    }
}

