/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.jackson.datatype.joda.ser;

import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.databind.SerializationFeature;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.datatype.joda.cfg.FormatConfig;
import io.trino.jdbc.$internal.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import io.trino.jdbc.$internal.jackson.datatype.joda.ser.JodaDateSerializerBase;
import io.trino.jdbc.$internal.joda.time.Duration;
import java.io.IOException;

public class DurationSerializer
extends JodaDateSerializerBase<Duration> {
    private static final long serialVersionUID = 1L;

    public DurationSerializer() {
        this(FormatConfig.DEFAULT_DATEONLY_FORMAT, 0);
    }

    public DurationSerializer(JacksonJodaDateFormat format) {
        this(format, 0);
    }

    public DurationSerializer(JacksonJodaDateFormat formatter, int shapeOverride) {
        super(Duration.class, formatter, SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS, 2, shapeOverride);
    }

    public DurationSerializer withFormat(JacksonJodaDateFormat formatter, int shapeOverride) {
        return new DurationSerializer(formatter, shapeOverride);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, Duration value) {
        return value.getMillis() == 0L;
    }

    @Override
    public void serialize(Duration value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._serializationShape(provider) == 1) {
            gen.writeString(value.toString());
        } else {
            gen.writeNumber(value.getMillis());
        }
    }
}

