/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.ColumnInfo;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TrinoResultSetMetaData
implements ResultSetMetaData {
    private final List<ColumnInfo> columnInfo;

    TrinoResultSetMetaData(List<ColumnInfo> columnInfo) {
        this.columnInfo = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnInfo, "columnInfo is null"));
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnInfo.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return this.column(column).isCurrency();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        ColumnInfo.Nullable nullable = this.column(column).getNullable();
        switch (nullable) {
            case NO_NULLS: {
                return 0;
            }
            case NULLABLE: {
                return 1;
            }
            case UNKNOWN: {
                return 2;
            }
        }
        throw new SQLException("Unhandled nullable type: " + (Object)((Object)nullable));
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.column(column).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.column(column).getColumnDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.column(column).getColumnLabel();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.column(column).getColumnName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return this.column(column).getPrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return this.column(column).getScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.column(column).getTableName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.column(column).getSchemaName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.column(column).getCatalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.column(column).getColumnType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.column(column).getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        switch (this.column(column).getColumnType()) {
            case 2: 
            case 3: {
                return BigDecimal.class.getName();
            }
            case -7: 
            case 16: {
                return Boolean.class.getName();
            }
            case -6: {
                return Byte.class.getName();
            }
            case 5: {
                return Short.class.getName();
            }
            case 4: {
                return Integer.class.getName();
            }
            case -5: {
                return Long.class.getName();
            }
            case 7: {
                return Float.class.getName();
            }
            case 6: 
            case 8: {
                return Double.class.getName();
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return Date.class.getName();
            }
            case 92: {
                return Time.class.getName();
            }
            case 93: {
                return Timestamp.class.getName();
            }
            case 2004: {
                return Blob.class.getName();
            }
            case 2005: {
                return Clob.class.getName();
            }
            case 2003: {
                return Array.class.getName();
            }
        }
        return String.class.getName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return (T)this;
        }
        throw new SQLException("No wrapper for " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    private ColumnInfo column(int column) throws SQLException {
        if (column <= 0 || column > this.columnInfo.size()) {
            throw new SQLException("Invalid column index: " + column);
        }
        return this.columnInfo.get(column - 1);
    }
}

