package io.trino.jdbc.$internal.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.ZoneId;

import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.core.type.WritableTypeId;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.jsontype.TypeSerializer;
import io.trino.jdbc.$internal.jackson.databind.ser.std.ToStringSerializerBase;

// @since 2.10.2
public class ZoneIdSerializer extends ToStringSerializerBase
{
    private static final long serialVersionUID = 1L;

    public ZoneIdSerializer() { super(ZoneId.class); }

    @Override
    public void serializeWithType(Object value, JsonGenerator g,
            SerializerProvider provider, TypeSerializer typeSer) throws IOException
    {
        // Better ensure we don't use specific sub-classes:
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g,
                typeSer.typeId(value, ZoneId.class, JsonToken.VALUE_STRING));
        serialize(value, g, provider);
        typeSer.writeTypeSuffix(g, typeIdDef);
    }

    @Override
    public String valueToString(Object value) {
        return value.toString();
    }
}
