/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.net;

import io.trino.jdbc.$internal.guava.annotations.Beta;
import io.trino.jdbc.$internal.guava.annotations.GwtIncompatible;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.net.ElementTypesAreNonnullByDefault;
import io.trino.jdbc.$internal.guava.net.HostAndPort;
import io.trino.jdbc.$internal.guava.net.InetAddresses;
import io.trino.jdbc.$internal.guava.net.InternetDomainName;
import io.trino.jdbc.$internal.javax.annotation.CheckForNull;
import java.net.InetAddress;
import java.text.ParseException;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class HostSpecifier {
    private final String canonicalForm;

    private HostSpecifier(String canonicalForm) {
        this.canonicalForm = canonicalForm;
    }

    public static HostSpecifier fromValid(String specifier) {
        HostAndPort parsedHost = HostAndPort.fromString(specifier);
        Preconditions.checkArgument(!parsedHost.hasPort());
        String host = parsedHost.getHost();
        InetAddress addr = null;
        try {
            addr = InetAddresses.forString(host);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (addr != null) {
            return new HostSpecifier(InetAddresses.toUriString(addr));
        }
        InternetDomainName domain = InternetDomainName.from(host);
        if (domain.hasPublicSuffix()) {
            return new HostSpecifier(domain.toString());
        }
        String string = String.valueOf(host);
        throw new IllegalArgumentException(string.length() != 0 ? "Domain name does not have a recognized public suffix: ".concat(string) : new String("Domain name does not have a recognized public suffix: "));
    }

    public static HostSpecifier from(String specifier) throws ParseException {
        try {
            return HostSpecifier.fromValid(specifier);
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(specifier);
            ParseException parseException = new ParseException(string.length() != 0 ? "Invalid host specifier: ".concat(string) : new String("Invalid host specifier: "), 0);
            parseException.initCause(e);
            throw parseException;
        }
    }

    public static boolean isValid(String specifier) {
        try {
            HostSpecifier.fromValid(specifier);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean equals(@CheckForNull Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostSpecifier) {
            HostSpecifier that = (HostSpecifier)other;
            return this.canonicalForm.equals(that.canonicalForm);
        }
        return false;
    }

    public int hashCode() {
        return this.canonicalForm.hashCode();
    }

    public String toString() {
        return this.canonicalForm;
    }
}

