/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.QueryStatusInfo;
import io.trino.jdbc.$internal.client.StatementClient;
import io.trino.jdbc.$internal.guava.base.Throwables;
import io.trino.jdbc.$internal.guava.base.Verify;
import io.trino.jdbc.$internal.guava.collect.AbstractIterator;
import io.trino.jdbc.$internal.guava.collect.Streams;
import io.trino.jdbc.$internal.guava.util.concurrent.ThreadFactoryBuilder;
import io.trino.jdbc.AbstractTrinoResultSet;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.WarningsManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class TrinoResultSet
extends AbstractTrinoResultSet {
    private final StatementClient client;
    private final String queryId;

    static TrinoResultSet create(Statement statement, StatementClient client, long maxRows, Consumer<QueryStats> progressCallback, WarningsManager warningsManager) throws SQLException {
        Objects.requireNonNull(client, "client is null");
        List<.Column> columns = TrinoResultSet.getColumns(client, progressCallback);
        return new TrinoResultSet(statement, client, columns, maxRows, progressCallback, warningsManager);
    }

    private TrinoResultSet(Statement statement, StatementClient client, List<.Column> columns, long maxRows, Consumer<QueryStats> progressCallback, WarningsManager warningsManager) throws SQLException {
        super(Optional.of(Objects.requireNonNull(statement, "statement is null")), columns, new AsyncIterator<List<Object>>(TrinoResultSet.flatten(new ResultsPageIterator(Objects.requireNonNull(client, "client is null"), progressCallback, warningsManager), maxRows), client));
        this.client = Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(progressCallback, "progressCallback is null");
        this.queryId = client.currentStatusInfo().getId();
    }

    public String getQueryId() {
        return this.queryId;
    }

    public QueryStats getStats() {
        return QueryStats.create(this.queryId, this.client.getStats());
    }

    @Override
    public void close() throws SQLException {
        this.closed.set(true);
        ((AsyncIterator)this.results).cancel();
        this.client.close();
    }

    void partialCancel() {
        this.client.cancelLeafStage();
    }

    private static <T> Iterator<T> flatten(Iterator<Iterable<T>> iterator, long maxRows) {
        Stream stream = Streams.stream(iterator).flatMap(Streams::stream);
        if (maxRows > 0L) {
            stream = stream.limit(maxRows);
        }
        return stream.iterator();
    }

    private static List<.Column> getColumns(StatementClient client, Consumer<QueryStats> progressCallback) throws SQLException {
        QueryStatusInfo results;
        while (client.isRunning()) {
            results = client.currentStatusInfo();
            progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
            List<.Column> columns = results.getColumns();
            if (columns != null) {
                return columns;
            }
            client.advance();
        }
        Verify.verify(client.isFinished());
        results = client.finalStatusInfo();
        if (results.getError() == null) {
            throw new SQLException(String.format("Query has no columns (#%s)", results.getId()));
        }
        throw TrinoResultSet.resultsException(results);
    }

    private static class AsyncIterator<T>
    extends AbstractIterator<T> {
        private static final int MAX_QUEUED_ROWS = 50000;
        private static final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Trino JDBC worker-%s").setDaemon(true).build());
        private final StatementClient client;
        private final BlockingQueue<T> rowQueue = new ArrayBlockingQueue<T>(50000);
        private final Semaphore semaphore = new Semaphore(0);
        private final CompletableFuture<Void> future;

        public AsyncIterator(Iterator<T> dataIterator, StatementClient client) {
            Objects.requireNonNull(dataIterator, "dataIterator is null");
            this.client = client;
            this.future = CompletableFuture.runAsync(() -> {
                try {
                    while (dataIterator.hasNext()) {
                        this.rowQueue.put(dataIterator.next());
                        this.semaphore.release();
                    }
                }
                catch (InterruptedException e) {
                    this.interrupt(e);
                }
                finally {
                    this.semaphore.release();
                }
            }, executorService);
        }

        public void cancel() {
            this.future.cancel(true);
        }

        public void interrupt(InterruptedException e) {
            this.client.close();
            Thread.currentThread().interrupt();
            throw new RuntimeException(new SQLException("ResultSet thread was interrupted", e));
        }

        @Override
        protected T computeNext() {
            try {
                this.semaphore.acquire();
            }
            catch (InterruptedException e) {
                this.interrupt(e);
            }
            if (this.rowQueue.isEmpty()) {
                try {
                    this.future.get();
                }
                catch (InterruptedException e) {
                    this.interrupt(e);
                }
                catch (ExecutionException e) {
                    Throwables.throwIfUnchecked(e.getCause());
                    throw new RuntimeException(e.getCause());
                }
                return this.endOfData();
            }
            return (T)this.rowQueue.poll();
        }
    }

    private static class ResultsPageIterator
    extends AbstractIterator<Iterable<List<Object>>> {
        private final StatementClient client;
        private final Consumer<QueryStats> progressCallback;
        private final WarningsManager warningsManager;

        private ResultsPageIterator(StatementClient client, Consumer<QueryStats> progressCallback, WarningsManager warningsManager) {
            this.client = Objects.requireNonNull(client, "client is null");
            this.progressCallback = Objects.requireNonNull(progressCallback, "progressCallback is null");
            this.warningsManager = Objects.requireNonNull(warningsManager, "warningsManager is null");
        }

        @Override
        protected Iterable<List<Object>> computeNext() {
            QueryStatusInfo results;
            while (this.client.isRunning()) {
                results = this.client.currentStatusInfo();
                this.progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
                this.warningsManager.addWarnings(results.getWarnings());
                Iterable<List<Object>> data = this.client.currentData().getData();
                this.client.advance();
                if (data == null) continue;
                return data;
            }
            Verify.verify(this.client.isFinished());
            results = this.client.finalStatusInfo();
            this.progressCallback.accept(QueryStats.create(results.getId(), results.getStats()));
            this.warningsManager.addWarnings(results.getWarnings());
            if (results.getError() != null) {
                throw new RuntimeException(AbstractTrinoResultSet.resultsException(results));
            }
            return (Iterable)this.endOfData();
        }
    }
}

