/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.client.ClientTypeSignatureParameter;
import io.trino.jdbc.$internal.guava.base.Joiner;
import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.base.Splitter;
import io.trino.jdbc.$internal.guava.collect.ImmutableList;
import io.trino.jdbc.$internal.guava.io.BaseEncoding;
import io.trino.jdbc.$internal.guava.primitives.Ints;
import io.trino.jdbc.$internal.joda.time.DateTimeZone;
import io.trino.jdbc.AbstractTrinoResultSet;
import io.trino.jdbc.ColumnInfo;
import io.trino.jdbc.NotImplementedException;
import io.trino.jdbc.ObjectCasts;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoParameterMetaData;
import io.trino.jdbc.TrinoResultSetMetaData;
import io.trino.jdbc.TrinoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TrinoPreparedStatement
extends TrinoStatement
implements PreparedStatement {
    private static final DateTimeFormatter LOCAL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    private static final DateTimeFormatter OFFSET_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "+00:00").toFormatter();
    private static final Pattern TOP_LEVEL_TYPE_PATTERN = Pattern.compile("(.+?)\\((.+)\\)");
    private static final Pattern TIMESTAMP_WITH_TIME_ZONE_PRECISION_PATTERN = Pattern.compile("timestamp\\((\\d+)\\) with time zone");
    private static final Pattern TIME_WITH_TIME_ZONE_PRECISION_PATTERN = Pattern.compile("time\\((\\d+)\\) with time zone");
    private final Map<Integer, String> parameters = new HashMap<Integer, String>();
    private final List<List<String>> batchValues = new ArrayList<List<String>>();
    private final String statementName;
    private final String originalSql;
    private boolean isBatch;

    TrinoPreparedStatement(TrinoConnection connection, Consumer<TrinoStatement> onClose, String statementName, String sql) throws SQLException {
        super(connection, onClose);
        this.statementName = Objects.requireNonNull(statementName, "statementName is null");
        this.originalSql = Objects.requireNonNull(sql, "sql is null");
        super.execute(String.format("PREPARE %s FROM %s", statementName, sql));
    }

    @Override
    public void close() throws SQLException {
        super.execute(String.format("DEALLOCATE PREPARE %s", this.statementName));
        super.close();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.requireNonBatchStatement();
        if (!super.execute(TrinoPreparedStatement.getExecuteSql(this.statementName, TrinoPreparedStatement.toValues(this.parameters)))) {
            throw new SQLException("Prepared SQL statement is not a query: " + this.originalSql);
        }
        return this.getResultSet();
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.requireNonBatchStatement();
        return Ints.saturatedCast(this.executeLargeUpdate());
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.requireNonBatchStatement();
        if (super.execute(TrinoPreparedStatement.getExecuteSql(this.statementName, TrinoPreparedStatement.toValues(this.parameters)))) {
            throw new SQLException("Prepared SQL is not an update statement: " + this.originalSql);
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public boolean execute() throws SQLException {
        this.requireNonBatchStatement();
        return super.execute(TrinoPreparedStatement.getExecuteSql(this.statementName, TrinoPreparedStatement.toValues(this.parameters)));
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.typedNull(sqlType));
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatBooleanLiteral(x));
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TINYINT", Byte.toString(x)));
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("SMALLINT", Short.toString(x)));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("INTEGER", Integer.toString(x)));
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("BIGINT", Long.toString(x)));
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("REAL", Float.toString(x)));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkOpen();
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("DOUBLE", Double.toString(x)));
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 3);
        } else {
            this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("DECIMAL", x.toString()));
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 12);
        } else {
            this.setParameter(parameterIndex, TrinoPreparedStatement.formatStringLiteral(x));
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, -3);
        } else {
            this.setParameter(parameterIndex, TrinoPreparedStatement.formatBinaryLiteral(x));
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 91);
        } else {
            this.setAsDate(parameterIndex, x);
        }
    }

    private void setAsDate(int parameterIndex, Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        String literal = this.toDateLiteral(value);
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("DATE", literal));
    }

    private String toDateLiteral(Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        if (value instanceof java.util.Date) {
            return AbstractTrinoResultSet.DATE_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDate) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return DateTimeFormatter.ISO_LOCAL_DATE.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ObjectCasts.invalidConversion(value, "date");
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 92);
        } else {
            this.setAsTime(parameterIndex, x);
        }
    }

    private void setAsTime(int parameterIndex, Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        String literal = this.toTimeLiteral(value);
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TIME", literal));
    }

    private String toTimeLiteral(Object value) throws SQLException {
        if (value instanceof java.util.Date) {
            return AbstractTrinoResultSet.TIME_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalTime) {
            return DateTimeFormatter.ISO_LOCAL_TIME.format((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return DateTimeFormatter.ISO_LOCAL_TIME.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ObjectCasts.invalidConversion(value, "time");
    }

    private void setAsTimeWithTimeZone(int parameterIndex, Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        String literal = this.toTimeWithTimeZoneLiteral(value);
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TIME", literal));
    }

    private String toTimeWithTimeZoneLiteral(Object value) throws SQLException {
        if (value instanceof OffsetTime) {
            return OFFSET_TIME_FORMATTER.format((OffsetTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ObjectCasts.invalidConversion(value, "time with time zone");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setAsTimestamp(parameterIndex, x);
        }
    }

    private void setAsTimestamp(int parameterIndex, Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        String literal = this.toTimestampLiteral(value);
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TIMESTAMP", literal));
    }

    private String toTimestampLiteral(Object value) throws SQLException {
        if (value instanceof java.util.Date) {
            return AbstractTrinoResultSet.TIMESTAMP_FORMATTER.print(((java.util.Date)value).getTime());
        }
        if (value instanceof LocalDateTime) {
            return LOCAL_DATE_TIME_FORMATTER.format((LocalDateTime)value);
        }
        if (value instanceof String) {
            return (String)value;
        }
        throw ObjectCasts.invalidConversion(value, "timestamp");
    }

    private void setAsTimestampWithTimeZone(int parameterIndex, Object value) throws SQLException {
        Objects.requireNonNull(value, "value is null");
        String literal = this.toTimestampWithTimeZoneLiteral(value);
        this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TIMESTAMP", literal));
    }

    private String toTimestampWithTimeZoneLiteral(Object value) throws SQLException {
        if (value instanceof String) {
            return (String)value;
        }
        throw ObjectCasts.invalidConversion(value, "timestamp with time zone");
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkOpen();
        if (x == null || cal == null) {
            this.setTimestamp(parameterIndex, x);
        } else {
            String formattedDateTime = AbstractTrinoResultSet.TIMESTAMP_FORMATTER.withZone(DateTimeZone.forTimeZone(cal.getTimeZone())).print(x.getTime());
            this.setParameter(parameterIndex, TrinoPreparedStatement.formatLiteral("TIMESTAMP", formattedDateTime));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setUnicodeStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkOpen();
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        switch (targetSqlType) {
            case -7: 
            case 16: {
                this.setBoolean(parameterIndex, ObjectCasts.castToBoolean(x, targetSqlType));
                return;
            }
            case -6: {
                this.setByte(parameterIndex, ObjectCasts.castToByte(x, targetSqlType));
                return;
            }
            case 5: {
                this.setShort(parameterIndex, ObjectCasts.castToShort(x, targetSqlType));
                return;
            }
            case 4: {
                this.setInt(parameterIndex, ObjectCasts.castToInt(x, targetSqlType));
                return;
            }
            case -5: {
                this.setLong(parameterIndex, ObjectCasts.castToLong(x, targetSqlType));
                return;
            }
            case 6: 
            case 7: {
                this.setFloat(parameterIndex, ObjectCasts.castToFloat(x, targetSqlType));
                return;
            }
            case 8: {
                this.setDouble(parameterIndex, ObjectCasts.castToDouble(x, targetSqlType));
                return;
            }
            case 2: 
            case 3: {
                this.setBigDecimal(parameterIndex, ObjectCasts.castToBigDecimal(x, targetSqlType));
                return;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                this.setString(parameterIndex, x.toString());
                return;
            }
            case -4: 
            case -3: 
            case -2: {
                this.setBytes(parameterIndex, ObjectCasts.castToBinary(x, targetSqlType));
                return;
            }
            case 91: {
                this.setAsDate(parameterIndex, x);
                return;
            }
            case 92: {
                this.setAsTime(parameterIndex, x);
                return;
            }
            case 2013: {
                this.setAsTimeWithTimeZone(parameterIndex, x);
                return;
            }
            case 93: {
                this.setAsTimestamp(parameterIndex, x);
                return;
            }
            case 2014: {
                this.setAsTimestampWithTimeZone(parameterIndex, x);
                return;
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType.getVendorTypeNumber());
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkOpen();
        if (x == null) {
            this.setNull(parameterIndex, 0);
        } else if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
        } else if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
        } else if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
        } else if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
        } else if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
        } else if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
        } else if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
        } else if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
        } else if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
        } else if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
        } else if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
        } else if (x instanceof LocalDate) {
            this.setAsDate(parameterIndex, x);
        } else if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
        } else if (x instanceof OffsetTime) {
            this.setAsTimeWithTimeZone(parameterIndex, x);
        } else if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
        } else {
            throw new SQLException("Unsupported object type: " + x.getClass().getName());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkOpen();
        this.batchValues.add(TrinoPreparedStatement.toValues(this.parameters));
        this.isBatch = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.checkOpen();
        this.batchValues.clear();
        this.isBatch = false;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] batchUpdateCounts = new int[this.batchValues.size()];
            for (int i = 0; i < this.batchValues.size(); ++i) {
                super.execute(TrinoPreparedStatement.getExecuteSql(this.statementName, this.batchValues.get(i)));
                batchUpdateCounts[i] = this.getUpdateCount();
            }
            int[] nArray = batchUpdateCounts;
            return nArray;
        }
        finally {
            this.clearBatch();
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRef");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setArray");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try (Statement statement = this.connection().createStatement();){
            TrinoResultSetMetaData trinoResultSetMetaData;
            block12: {
                ResultSet resultSet = statement.executeQuery("DESCRIBE OUTPUT " + this.statementName);
                try {
                    trinoResultSetMetaData = new TrinoResultSetMetaData(TrinoPreparedStatement.getDescribeOutputColumnInfoList(resultSet));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return trinoResultSetMetaData;
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setDate");
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setTime");
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setURL");
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try (Statement statement = this.connection().createStatement();){
            TrinoParameterMetaData trinoParameterMetaData;
            block12: {
                ResultSet resultSet = statement.executeQuery("DESCRIBE INPUT " + this.statementName);
                try {
                    trinoParameterMetaData = new TrinoParameterMetaData(TrinoPreparedStatement.getParamerters(resultSet));
                    if (resultSet == null) break block12;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return trinoParameterMetaData;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setRowId");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("setSQLXML");
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("setObject");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        throw new NotImplementedException("PreparedStatement", "setCharacterStream");
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setAsciiStream");
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBinaryStream");
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setCharacterStream");
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNCharacterStream");
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setClob");
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("setBlob");
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("setNClob");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("This method cannot be called on PreparedStatement");
    }

    private void setParameter(int parameterIndex, String value) throws SQLException {
        if (parameterIndex < 1) {
            throw new SQLException("Parameter index out of bounds: " + parameterIndex);
        }
        this.parameters.put(parameterIndex - 1, value);
    }

    private static List<String> toValues(Map<Integer, String> parameters) throws SQLException {
        ImmutableList.Builder values = ImmutableList.builder();
        for (int index = 0; index < parameters.size(); ++index) {
            if (!parameters.containsKey(index)) {
                throw new SQLException("No value specified for parameter " + (index + 1));
            }
            values.add(parameters.get(index));
        }
        return values.build();
    }

    private void requireNonBatchStatement() throws SQLException {
        if (this.isBatch) {
            throw new SQLException("Batch prepared statement must be executed using executeBatch method");
        }
    }

    private static String getExecuteSql(String statementName, List<String> values) {
        StringBuilder sql = new StringBuilder();
        sql.append("EXECUTE ").append(statementName);
        if (!values.isEmpty()) {
            sql.append(" USING ");
            Joiner.on(", ").appendTo(sql, (Iterable<? extends Object>)values);
        }
        return sql.toString();
    }

    private static String formatLiteral(String type, String x) {
        return type + " " + TrinoPreparedStatement.formatStringLiteral(x);
    }

    private static String formatBooleanLiteral(boolean x) {
        return Boolean.toString(x);
    }

    private static String formatStringLiteral(String x) {
        return "'" + x.replace("'", "''") + "'";
    }

    private static String formatBinaryLiteral(byte[] x) {
        return "X'" + BaseEncoding.base16().encode(x) + "'";
    }

    private static String typedNull(int targetSqlType) throws SQLException {
        switch (targetSqlType) {
            case -7: 
            case 16: {
                return TrinoPreparedStatement.typedNull("BOOLEAN");
            }
            case -6: {
                return TrinoPreparedStatement.typedNull("TINYINT");
            }
            case 5: {
                return TrinoPreparedStatement.typedNull("SMALLINT");
            }
            case 4: {
                return TrinoPreparedStatement.typedNull("INTEGER");
            }
            case -5: {
                return TrinoPreparedStatement.typedNull("BIGINT");
            }
            case 6: 
            case 7: {
                return TrinoPreparedStatement.typedNull("REAL");
            }
            case 8: {
                return TrinoPreparedStatement.typedNull("DOUBLE");
            }
            case 2: 
            case 3: {
                return TrinoPreparedStatement.typedNull("DECIMAL");
            }
            case -15: 
            case 1: {
                return TrinoPreparedStatement.typedNull("CHAR");
            }
            case -16: 
            case -9: 
            case -1: 
            case 12: 
            case 2005: 
            case 2011: {
                return TrinoPreparedStatement.typedNull("VARCHAR");
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return TrinoPreparedStatement.typedNull("VARBINARY");
            }
            case 91: {
                return TrinoPreparedStatement.typedNull("DATE");
            }
            case 92: {
                return TrinoPreparedStatement.typedNull("TIME");
            }
            case 93: {
                return TrinoPreparedStatement.typedNull("TIMESTAMP");
            }
            case 0: {
                return "NULL";
            }
        }
        throw new SQLException("Unsupported target SQL type: " + targetSqlType);
    }

    private static String typedNull(String type) {
        return String.format("CAST(NULL AS %s)", type);
    }

    private static List<ColumnInfo> getParamerters(ResultSet resultSet) throws SQLException {
        ImmutableList.Builder builder = ImmutableList.builder();
        while (resultSet.next()) {
            ClientTypeSignature clientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString(resultSet.getString("Type"));
            ColumnInfo.Builder columnInfoBuilder = new ColumnInfo.Builder().setCatalogName("").setSchemaName("").setTableName("").setColumnLabel(resultSet.getString("Position")).setColumnName(resultSet.getString("Position")).setColumnTypeSignature(clientTypeSignature).setNullable(ColumnInfo.Nullable.UNKNOWN);
            ColumnInfo.setTypeInfo(columnInfoBuilder, clientTypeSignature);
            builder.add(columnInfoBuilder.build());
        }
        return builder.build();
    }

    private static List<ColumnInfo> getDescribeOutputColumnInfoList(ResultSet resultSet) throws SQLException {
        ImmutableList.Builder list = ImmutableList.builder();
        while (resultSet.next()) {
            String columnName = resultSet.getString("Column Name");
            String catalog = resultSet.getString("Catalog");
            String schema = resultSet.getString("Schema");
            String table = resultSet.getString("Table");
            ClientTypeSignature clientTypeSignature = TrinoPreparedStatement.getClientTypeSignatureFromTypeString(resultSet.getString("Type"));
            ColumnInfo.Builder builder = new ColumnInfo.Builder().setColumnName(columnName).setColumnLabel(columnName).setCatalogName(catalog).setSchemaName(schema).setTableName(table).setColumnTypeSignature(clientTypeSignature).setNullable(ColumnInfo.Nullable.UNKNOWN);
            ColumnInfo.setTypeInfo(builder, clientTypeSignature);
            list.add(builder.build());
        }
        return list.build();
    }

    @.VisibleForTesting
    static ClientTypeSignature getClientTypeSignatureFromTypeString(String type) {
        String topLevelType;
        ArrayList<ClientTypeSignatureParameter> arguments = new ArrayList<ClientTypeSignatureParameter>();
        Matcher topLevelMatcher = TOP_LEVEL_TYPE_PATTERN.matcher(type);
        if (topLevelMatcher.matches()) {
            topLevelType = topLevelMatcher.group(1);
            String typeParameters = topLevelMatcher.group(2);
            if (topLevelType.equals("decimal")) {
                List<String> precisionAndScale = Splitter.on(',').splitToList(typeParameters);
                Preconditions.checkArgument(precisionAndScale.size() == 2, "Invalid decimal parameters: %s", (Object)typeParameters);
                arguments.add(ClientTypeSignatureParameter.ofLong(Long.parseLong(precisionAndScale.get(0))));
                arguments.add(ClientTypeSignatureParameter.ofLong(Long.parseLong(precisionAndScale.get(1))));
            } else if (topLevelType.equals("char") || topLevelType.equals("varchar")) {
                long precision = Long.parseLong(typeParameters);
                arguments.add(ClientTypeSignatureParameter.ofLong(precision));
            }
        } else {
            Matcher timestampMatcher = TIMESTAMP_WITH_TIME_ZONE_PRECISION_PATTERN.matcher(type);
            Matcher timeMatcher = TIME_WITH_TIME_ZONE_PRECISION_PATTERN.matcher(type);
            if (timestampMatcher.matches()) {
                topLevelType = "timestamp with time zone";
                arguments.add(ClientTypeSignatureParameter.ofLong(Long.parseLong(timestampMatcher.group(1))));
            } else if (timeMatcher.matches()) {
                topLevelType = "time with time zone";
                arguments.add(ClientTypeSignatureParameter.ofLong(Long.parseLong(timeMatcher.group(1))));
            } else {
                topLevelType = type;
                if (topLevelType.equals("varchar")) {
                    arguments.add(ClientTypeSignatureParameter.ofLong(Integer.MAX_VALUE));
                }
            }
        }
        return new ClientTypeSignature(topLevelType, arguments);
    }
}

