package io.trino.jdbc.$internal.jackson.datatype.jdk8;

import java.io.IOException;
import java.util.OptionalLong;

import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.core.JsonParser;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.trino.jdbc.$internal.jackson.databind.ser.std.StdScalarSerializer;

final class OptionalLongSerializer extends StdScalarSerializer<OptionalLong>
{
    private static final long serialVersionUID = 1L;

    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    // @since 2.6
    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value) {
        return (value == null) || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor,
            JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor
                .expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value, JsonGenerator jgen, SerializerProvider provider)
        throws IOException
    {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsLong());
        } else { // should we get here?
            jgen.writeNull();
        }
    }
}
