/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.auth.external.KnownToken;
import io.trino.jdbc.$internal.client.auth.external.Token;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;

@.ThreadSafe
class MemoryCachedKnownToken
implements KnownToken {
    public static final MemoryCachedKnownToken INSTANCE = new MemoryCachedKnownToken();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private Optional<Token> knownToken = Optional.empty();

    private MemoryCachedKnownToken() {
    }

    @Override
    public Optional<Token> getToken() {
        try {
            this.readLock.lockInterruptibly();
            Optional<Token> optional = this.knownToken;
            return optional;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setupToken(Supplier<Optional<Token>> tokenSource) {
        if (this.writeLock.tryLock()) {
            try {
                this.knownToken = Optional.empty();
                this.knownToken = tokenSource.get();
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

