/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.guava.base.Preconditions;
import io.trino.jdbc.$internal.guava.reflect.TypeToken;
import io.trino.jdbc.ConnectionProperty;
import java.io.File;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Stream;

abstract class AbstractConnectionProperty<T>
implements ConnectionProperty<T> {
    private final String key;
    private final Optional<String> defaultValue;
    private final Predicate<Properties> isRequired;
    private final Predicate<Properties> isAllowed;
    private final Converter<T> converter;
    private final String[] choices;
    protected static final Predicate<Properties> REQUIRED = properties -> true;
    protected static final Predicate<Properties> NOT_REQUIRED = properties -> false;
    protected static final Predicate<Properties> ALLOWED = properties -> true;
    protected static final Converter<String> STRING_CONVERTER = value -> value;
    protected static final Converter<String> NON_EMPTY_STRING_CONVERTER = value -> {
        Preconditions.checkArgument(!value.isEmpty(), "value is empty");
        return value;
    };
    protected static final Converter<File> FILE_CONVERTER = File::new;
    protected static final Converter<Boolean> BOOLEAN_CONVERTER = value -> {
        switch (value.toLowerCase(Locale.ENGLISH)) {
            case "true": {
                return true;
            }
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("value must be 'true' or 'false'");
    };

    protected AbstractConnectionProperty(String key, Optional<String> defaultValue, Predicate<Properties> isRequired, Predicate<Properties> isAllowed, Converter<T> converter) {
        this.key = Objects.requireNonNull(key, "key is null");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue is null");
        this.isRequired = Objects.requireNonNull(isRequired, "isRequired is null");
        this.isAllowed = Objects.requireNonNull(isAllowed, "isAllowed is null");
        this.converter = Objects.requireNonNull(converter, "converter is null");
        Class type = new TypeToken<T>(this.getClass()){}.getRawType();
        this.choices = type == Boolean.class ? new String[]{"true", "false"} : (Enum.class.isAssignableFrom(type) ? (String[])Stream.of(type.getEnumConstants()).map(Object::toString).toArray(String[]::new) : null);
    }

    protected AbstractConnectionProperty(String key, Predicate<Properties> required, Predicate<Properties> allowed, Converter<T> converter) {
        this(key, Optional.empty(), required, allowed, converter);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public Optional<String> getDefault() {
        return this.defaultValue;
    }

    @Override
    public DriverPropertyInfo getDriverPropertyInfo(Properties mergedProperties) {
        String currentValue = mergedProperties.getProperty(this.key);
        DriverPropertyInfo result = new DriverPropertyInfo(this.key, currentValue);
        result.required = this.isRequired.test(mergedProperties);
        result.choices = this.choices != null ? (String[])this.choices.clone() : null;
        return result;
    }

    @Override
    public boolean isRequired(Properties properties) {
        return this.isRequired.test(properties);
    }

    @Override
    public boolean isAllowed(Properties properties) {
        return this.isAllowed.test(properties);
    }

    @Override
    public Optional<T> getValue(Properties properties) throws SQLException {
        String value = properties.getProperty(this.key);
        if (value == null) {
            if (this.isRequired(properties)) {
                throw new SQLException(String.format("Connection property '%s' is required", this.key));
            }
            return Optional.empty();
        }
        try {
            return Optional.of(this.converter.convert(value));
        }
        catch (RuntimeException e) {
            if (value.isEmpty()) {
                throw new SQLException(String.format("Connection property '%s' value is empty", this.key), e);
            }
            throw new SQLException(String.format("Connection property '%s' value is invalid: %s", this.key, value), e);
        }
    }

    @Override
    public void validate(Properties properties) throws SQLException {
        if (properties.containsKey(this.key) && !this.isAllowed(properties)) {
            throw new SQLException(String.format("Connection property '%s' is not allowed", this.key));
        }
        this.getValue(properties);
    }

    protected static <T> Predicate<T> checkedPredicate(CheckedPredicate<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (SQLException e) {
                return false;
            }
        };
    }

    static interface Converter<T> {
        public T convert(String var1);
    }

    protected static interface CheckedPredicate<T> {
        public boolean test(T var1) throws SQLException;
    }
}

