/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe;

import io.trino.jdbc.$internal.dev.failsafe.Policy;
import io.trino.jdbc.$internal.dev.failsafe.TimeoutBuilder;
import io.trino.jdbc.$internal.dev.failsafe.TimeoutConfig;
import io.trino.jdbc.$internal.dev.failsafe.internal.TimeoutImpl;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Assert;
import java.time.Duration;

public interface Timeout<R>
extends Policy<R> {
    public static <R> TimeoutBuilder<R> builder(Duration timeout) {
        Assert.notNull(timeout, "timeout");
        Assert.isTrue(timeout.toNanos() > 0L, "timeout must be > 0", new Object[0]);
        return new TimeoutBuilder(timeout);
    }

    public static <R> TimeoutBuilder<R> builder(TimeoutConfig<R> config) {
        return new TimeoutBuilder<R>(config);
    }

    public static <R> Timeout<R> of(Duration timeout) {
        return new TimeoutImpl(new TimeoutConfig(timeout, false));
    }

    @Override
    public TimeoutConfig<R> getConfig();
}

