/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.OkHttpUtil;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.ConnectionProperties;
import io.trino.jdbc.DriverInfo;
import io.trino.jdbc.TrinoConnection;
import io.trino.jdbc.TrinoDriverUri;
import java.io.Closeable;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class NonRegisteringTrinoDriver
implements Driver,
Closeable {
    private final OkHttpClient httpClient = NonRegisteringTrinoDriver.newHttpClient();

    @Override
    public void close() {
        this.httpClient.dispatcher().executorService().shutdown();
        this.httpClient.connectionPool().evictAll();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        TrinoDriverUri uri = TrinoDriverUri.create(url, info);
        OkHttpClient.Builder builder = this.httpClient.newBuilder();
        uri.setupClient(builder);
        return new TrinoConnection(uri, builder.build());
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("URL is null");
        }
        return TrinoDriverUri.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties properties = NonRegisteringTrinoDriver.urlProperties(url, info);
        return (DriverPropertyInfo[])ConnectionProperties.allProperties().stream().filter(property -> property.isAllowed(properties)).map(property -> property.getDriverPropertyInfo(properties)).toArray(DriverPropertyInfo[]::new);
    }

    private static Properties urlProperties(String url, Properties info) {
        try {
            return TrinoDriverUri.create(url, info).getProperties();
        }
        catch (SQLException e) {
            return info;
        }
    }

    @Override
    public int getMajorVersion() {
        return DriverInfo.DRIVER_VERSION_MAJOR;
    }

    @Override
    public int getMinorVersion() {
        return DriverInfo.DRIVER_VERSION_MINOR;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    private static OkHttpClient newHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().addInterceptor(OkHttpUtil.userAgent(DriverInfo.DRIVER_NAME + "/" + DriverInfo.DRIVER_VERSION));
        return builder.build();
    }
}

