/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.auth.external;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.ClientException;
import io.trino.jdbc.$internal.client.auth.external.ExternalAuthentication;
import io.trino.jdbc.$internal.client.auth.external.KnownToken;
import io.trino.jdbc.$internal.client.auth.external.RedirectHandler;
import io.trino.jdbc.$internal.client.auth.external.Token;
import io.trino.jdbc.$internal.client.auth.external.TokenPoller;
import io.trino.jdbc.$internal.okhttp3.Authenticator;
import io.trino.jdbc.$internal.okhttp3.Challenge;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExternalAuthenticator
implements Authenticator,
Interceptor {
    public static final String TOKEN_URI_FIELD = "x_token_server";
    public static final String REDIRECT_URI_FIELD = "x_redirect_server";
    private final TokenPoller tokenPoller;
    private final RedirectHandler redirectHandler;
    private final Duration timeout;
    private final KnownToken knownToken;

    public ExternalAuthenticator(RedirectHandler redirect, TokenPoller tokenPoller, KnownToken knownToken, Duration timeout2) {
        this.tokenPoller = Objects.requireNonNull(tokenPoller, "tokenPoller is null");
        this.redirectHandler = Objects.requireNonNull(redirect, "redirect is null");
        this.knownToken = Objects.requireNonNull(knownToken, "knownToken is null");
        this.timeout = Objects.requireNonNull(timeout2, "timeout is null");
    }

    @Override
    @.Nullable
    public Request authenticate(.Route route, Response response) {
        this.knownToken.setupToken(() -> {
            Optional<ExternalAuthentication> authentication = ExternalAuthenticator.toAuthentication(response);
            if (!authentication.isPresent()) {
                return Optional.empty();
            }
            return authentication.get().obtainToken(this.timeout, this.redirectHandler, this.tokenPoller);
        });
        return this.knownToken.getToken().map(token -> ExternalAuthenticator.withBearerToken(response.request(), token)).orElse(null);
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Optional<Token> token = this.knownToken.getToken();
        if (token.isPresent()) {
            return chain.proceed(ExternalAuthenticator.withBearerToken(chain.request(), token.get()));
        }
        return chain.proceed(chain.request());
    }

    private static Request withBearerToken(Request request, Token token) {
        return request.newBuilder().header("Authorization", "Bearer " + token.token()).build();
    }

    @.VisibleForTesting
    static Optional<ExternalAuthentication> toAuthentication(Response response) {
        for (Challenge challenge : response.challenges()) {
            if (!challenge.scheme().equalsIgnoreCase("Bearer")) continue;
            Optional<URI> tokenUri = ExternalAuthenticator.parseField(challenge.authParams(), TOKEN_URI_FIELD);
            Optional<URI> redirectUri = ExternalAuthenticator.parseField(challenge.authParams(), REDIRECT_URI_FIELD);
            if (!tokenUri.isPresent()) continue;
            return Optional.of(new ExternalAuthentication(tokenUri.get(), redirectUri));
        }
        return Optional.empty();
    }

    private static Optional<URI> parseField(Map<String, String> fields, String key) {
        return Optional.ofNullable(fields.get(key)).map(value -> {
            try {
                return new URI((String)value);
            }
            catch (URISyntaxException e) {
                throw new ClientException(String.format("Failed to parse URI for field '%s'", key), e);
            }
        });
    }
}

