/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

public class JdbcDriverIT {
    private static final Set<String> MANIFEST_FILES = ImmutableSet.of((Object)"META-INF/MANIFEST.MF", (Object)"META-INF/services/java.sql.Driver");

    @Parameters(value={"jdbc-jar"})
    @Test
    public void testDependenciesRelocated(String file) {
        try (JarFile jarFile = new JarFile(file);){
            List nonRelocatedFiles = (List)jarFile.stream().filter(value -> !value.isDirectory()).map(ZipEntry::getName).filter(name -> !JdbcDriverIT.isExpectedFile(name)).collect(ImmutableList.toImmutableList());
            ((ListAssert)Assertions.assertThat((List)nonRelocatedFiles).describedAs("Non-relocated files in the shaded jar", new Object[0])).isEmpty();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean isExpectedFile(String filename) {
        return MANIFEST_FILES.contains(filename) || filename.startsWith("io/trino/jdbc");
    }
}

