/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.airlift.log.Logging;
import io.trino.jdbc.BaseTestJdbcResultSet;
import io.trino.server.testing.TestingTrinoServer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;

public class TestJdbcResultSet
extends BaseTestJdbcResultSet {
    private TestingTrinoServer server;

    @BeforeClass
    public void setupServer() {
        Logging.initialize();
        this.server = this.createTestingServer();
    }

    protected TestingTrinoServer createTestingServer() {
        return TestingTrinoServer.create();
    }

    @AfterClass(alwaysRun=true)
    public void tearDownServer() throws Exception {
        this.server.close();
        this.server = null;
    }

    @Override
    protected Connection createConnection() throws SQLException {
        String url = String.format("jdbc:trino://%s", this.server.getAddress());
        return DriverManager.getConnection(url, "test", null);
    }

    @Override
    protected int getTestedServerVersion() {
        return Integer.MAX_VALUE;
    }
}

