/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Assertions;
import io.trino.client.ClientTypeSignature;
import io.trino.client.Column;
import io.trino.client.QueryResults;
import io.trino.client.StatementStats;
import io.trino.jdbc.QueryStats;
import io.trino.jdbc.TrinoStatement;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.OptionalDouble;
import java.util.function.Consumer;
import okhttp3.mockwebserver.MockResponse;
import okhttp3.mockwebserver.MockWebServer;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestProgressMonitor {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private MockWebServer server;

    @BeforeMethod
    public void setup() throws IOException {
        this.server = new MockWebServer();
        this.server.start();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() throws IOException {
        this.server.close();
        this.server = null;
    }

    private List<String> createResults() {
        ImmutableList columns = ImmutableList.of((Object)new Column("_col0", "bigint", new ClientTypeSignature("bigint")));
        return ImmutableList.builder().add((Object)this.newQueryResults(null, 1, null, null, "QUEUED")).add((Object)this.newQueryResults(1, 2, (List<Column>)columns, null, "RUNNING")).add((Object)this.newQueryResults(1, 3, (List<Column>)columns, null, "RUNNING")).add((Object)this.newQueryResults(0, 4, (List<Column>)columns, (List<List<Object>>)ImmutableList.of((Object)ImmutableList.of((Object)253161)), "RUNNING")).add((Object)this.newQueryResults(null, null, (List<Column>)columns, null, "FINISHED")).build();
    }

    private String newQueryResults(Integer partialCancelId, Integer nextUriId, List<Column> responseColumns, List<List<Object>> data, String state) {
        String queryId = "20160128_214710_00012_rk68b";
        QueryResults queryResults = new QueryResults(queryId, this.server.url("/query.html?" + queryId).uri(), partialCancelId == null ? null : this.server.url(String.format("/v1/statement/partialCancel/%s.%s", queryId, partialCancelId)).uri(), nextUriId == null ? null : this.server.url(String.format("/v1/statement/%s/%s", queryId, nextUriId)).uri(), responseColumns, data, new StatementStats(state, state.equals("QUEUED"), true, OptionalDouble.of(0.0), OptionalDouble.of(0.0), 0, 0, 0, 0, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, null), null, (List)ImmutableList.of(), null, null);
        return QUERY_RESULTS_CODEC.toJson((Object)queryResults);
    }

    @Test
    public void test() throws SQLException {
        for (String result : this.createResults()) {
            this.server.enqueue(new MockResponse().addHeader("Content-Type", (Object)"application/json").setBody(result));
        }
        try (Connection connection = this.createConnection();
             Statement statement = connection.createStatement();){
            TrinoStatement trinoStatement = statement.unwrap(TrinoStatement.class);
            RecordingProgressMonitor progressMonitor = new RecordingProgressMonitor();
            trinoStatement.setProgressMonitor((Consumer)progressMonitor);
            try (ResultSet rs = statement.executeQuery("bogus query for testing");){
                ResultSetMetaData metadata = rs.getMetaData();
                Assert.assertEquals((int)metadata.getColumnCount(), (int)1);
                Assert.assertEquals((String)metadata.getColumnName(1), (String)"_col0");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)rs.getLong(1), (long)253161L);
                Assert.assertEquals((long)rs.getLong("_col0"), (long)253161L);
                Assert.assertFalse((boolean)rs.next());
            }
            trinoStatement.clearProgressMonitor();
            List<QueryStats> queryStatsList = progressMonitor.finish();
            Assertions.assertGreaterThanOrEqual((Comparable)Integer.valueOf(queryStatsList.size()), (Comparable)Integer.valueOf(5));
            Assert.assertEquals((String)queryStatsList.get(0).getState(), (String)"QUEUED");
            Assert.assertEquals((String)queryStatsList.get(queryStatsList.size() - 1).getState(), (String)"FINISHED");
        }
    }

    private Connection createConnection() throws SQLException {
        String url = String.format("jdbc:trino://%s", this.server.url("/").uri().getAuthority());
        return DriverManager.getConnection(url, "test", null);
    }

    private static class RecordingProgressMonitor
    implements Consumer<QueryStats> {
        private final ImmutableList.Builder<QueryStats> builder = ImmutableList.builder();
        private boolean finished;

        private RecordingProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            this.builder.add((Object)queryStats);
        }

        public synchronized List<QueryStats> finish() {
            this.finished = true;
            return this.builder.build();
        }
    }
}

