/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.ConnectionProperties;
import io.trino.jdbc.TrinoDriverUri;
import java.net.URI;
import java.sql.SQLException;
import java.util.Optional;
import java.util.Properties;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTrinoDriverUri {
    @Test
    public void testInvalidUrls() {
        TestTrinoDriverUri.assertInvalid("test", "Invalid JDBC URL: test");
        TestTrinoDriverUri.assertInvalid("jdbc:", "Invalid JDBC URL: jdbc:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino:", "Empty JDBC URL: jdbc:trino:");
        TestTrinoDriverUri.assertInvalid("jdbc:mysql://localhost", "Invalid JDBC URL: jdbc:mysql://localhost");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost/", "No port number specified:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/hive/default/abc", "Invalid path segments in URL:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080//", "Catalog name is empty:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080//default", "Catalog name is empty:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/a//", "Schema name is empty:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/hive/default?ShoeSize=13", "Unrecognized connection property 'ShoeSize'");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/hive/default?SSL=", "Connection property 'SSL' value is empty");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/hive/default?SSL=true&SSLVerification=", "Connection property 'SSLVerification' value is empty");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/blackhole?password=a&password=b", "Connection property 'password' is in URL multiple times");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/blackhole?password&user=abc", "Connection argument is not valid connection property: 'password'");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080/blackhole?user=test123", "Connection property 'user' is both in the URL and an argument");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?socksProxy=localhost:1080&httpProxy=localhost:8888", "Connection property 'socksProxy' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?httpProxy=localhost:8888&socksProxy=localhost:1080", "Connection property 'socksProxy' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=0", "Connection property 'SSL' value is invalid: 0");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=1", "Connection property 'SSL' value is invalid: 1");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=2", "Connection property 'SSL' value is invalid: 2");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=abc", "Connection property 'SSL' value is invalid: abc");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=0", "Connection property 'SSLVerification' value is invalid: 0");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=abc", "Connection property 'SSLVerification' value is invalid: abc");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLVerification=FULL", "Connection property 'SSLVerification' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:443?SSLVerification=FULL", "Connection property 'SSLVerification' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLKeyStorePassword=password", "Connection property 'SSLKeyStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLKeyStoreType=type", "Connection property 'SSLKeyStoreType' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLTrustStorePassword=password", "Connection property 'SSLTrustStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLTrustStoreType=type", "Connection property 'SSLTrustStoreType' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property 'SSLKeyStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:443?SSLKeyStorePath=keystore.jks", "Connection property 'SSLKeyStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLTrustStorePath=truststore.jks", "Connection property 'SSLTrustStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:443?SSLTrustStorePath=truststore.jks", "Connection property 'SSLTrustStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLKeyStorePassword=password", "Connection property 'SSLKeyStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLTrustStorePassword=password", "Connection property 'SSLTrustStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePath=keystore.jks", "Connection property 'SSLKeyStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStorePassword=password", "Connection property 'SSLKeyStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLKeyStoreType=type", "Connection property 'SSLKeyStoreType' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePath=truststore.jks", "Connection property 'SSLTrustStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLVerification=NONE&SSLTrustStorePassword=password", "Connection property 'SSLTrustStorePassword' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLKeyStorePath=keystore.jks", "Connection property 'SSLKeyStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSLUseSystemTrustStore=true", "Connection property 'SSLUseSystemTrustStore' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?SSL=true&SSLUseSystemTrustStore=true&SSLTrustStorePath=truststore.jks", "Connection property 'SSLTrustStorePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?KerberosCredentialCachePath=/test", "Connection property 'KerberosCredentialCachePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?KerberosRemoteServiceName=test&KerberosDelegation=true&KerberosCredentialCachePath=/test", "Connection property 'KerberosCredentialCachePath' is not allowed");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?extraCredentials=:invalid", "Connection property 'extraCredentials' value is invalid:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?extraCredentials=invalid:", "Connection property 'extraCredentials' value is invalid:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?extraCredentials=:invalid", "Connection property 'extraCredentials' value is invalid:");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?extraCredentials=test.token.foo:bar;test.token.foo:xyz", "Connection property 'extraCredentials' value is invalid");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?extraCredentials=", "Connection property 'extraCredentials' value is empty");
        TestTrinoDriverUri.assertInvalid("jdbc:presto://localhost:8080", "Invalid JDBC URL: jdbc:presto://localhost:8080");
        TestTrinoDriverUri.assertInvalid("jdbc:trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true&assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true", "Connection property 'assumeLiteralNamesInMetadataCallsForNonConformingClients' is not allowed");
    }

    @Test(expectedExceptions={SQLException.class}, expectedExceptionsMessageRegExp="Connection property 'user' value is empty")
    public void testEmptyUser() throws Exception {
        TrinoDriverUri.create((String)"jdbc:trino://localhost:8080?user=", (Properties)new Properties());
    }

    @Test
    public void testEmptyPassword() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?password=");
        Assert.assertEquals((String)parameters.getProperties().getProperty("password"), (String)"");
    }

    @Test
    public void testNonEmptyPassword() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?password=secret");
        Assert.assertEquals((String)parameters.getProperties().getProperty("password"), (String)"secret");
    }

    @Test
    public void testUriWithSocksProxy() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?socksProxy=localhost:1234");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SOCKS_PROXY.getKey()), (String)"localhost:1234");
    }

    @Test
    public void testUriWithHttpProxy() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?httpProxy=localhost:5678");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "http");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.HTTP_PROXY.getKey()), (String)"localhost:5678");
    }

    @Test
    public void testUriWithoutCompression() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?disableCompression=true");
        Assert.assertTrue((boolean)parameters.isCompressionDisabled());
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.DISABLE_COMPRESSION.getKey()), (String)"true");
    }

    @Test
    public void testUriWithoutSsl() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslDisabled() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=false");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "http");
    }

    @Test
    public void testUriWithSslEnabled() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=true");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertNull((Object)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PATH.getKey()));
        Assert.assertNull((Object)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getKey()));
    }

    @Test
    public void testUriWithSslDisabledUsing443() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:443/blackhole?SSL=false");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 443, "http");
    }

    @Test
    public void testUriWithSslEnabledUsing443() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:443/blackhole");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 443, "https");
    }

    @Test
    public void testUriWithSslEnabledPathOnly() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PATH.getKey()), (String)"truststore.jks");
        Assert.assertNull((Object)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getKey()));
    }

    @Test
    public void testUriWithSslEnabledPassword() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=true&SSLTrustStorePath=truststore.jks&SSLTrustStorePassword=password");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PATH.getKey()), (String)"truststore.jks");
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_PASSWORD.getKey()), (String)"password");
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationFull() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:443/blackhole?SSL=true&SSLVerification=FULL");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_VERIFICATION.getKey()), (String)ConnectionProperties.SslVerificationMode.FULL.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationCA() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:443/blackhole?SSL=true&SSLVerification=CA");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_VERIFICATION.getKey()), (String)ConnectionProperties.SslVerificationMode.CA.name());
    }

    @Test
    public void testUriWithSslEnabledUsing443SslVerificationNONE() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:443/blackhole?SSL=true&SSLVerification=NONE");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 443, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_VERIFICATION.getKey()), (String)ConnectionProperties.SslVerificationMode.NONE.name());
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreDefault() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=true&SSLUseSystemTrustStore=true");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE.getKey()), (String)"true");
    }

    @Test
    public void testUriWithSslEnabledSystemTrustStoreOverride() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/blackhole?SSL=true&SSLTrustStoreType=Override&SSLUseSystemTrustStore=true");
        TestTrinoDriverUri.assertUriPortScheme(parameters, 8080, "https");
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_TRUST_STORE_TYPE.getKey()), (String)"Override");
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.SSL_USE_SYSTEM_TRUST_STORE.getKey()), (String)"true");
    }

    @Test
    public void testUriWithExtraCredentials() throws SQLException {
        String extraCredentials = "test.token.foo:bar;test.token.abc:xyz";
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?extraCredentials=" + extraCredentials);
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.EXTRA_CREDENTIALS.getKey()), (String)extraCredentials);
    }

    @Test
    public void testUriWithClientTags() throws SQLException {
        String clientTags = "c1,c2";
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?clientTags=" + clientTags);
        Properties properties = parameters.getProperties();
        Assert.assertEquals((String)properties.getProperty(ConnectionProperties.CLIENT_TAGS.getKey()), (String)clientTags);
    }

    @Test
    public void testOptionalCatalogAndSchema() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080");
        Assertions.assertThat((Optional)parameters.getCatalog()).isEmpty();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testOptionalSchema() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080/catalog");
        Assertions.assertThat((Optional)parameters.getCatalog()).isPresent();
        Assertions.assertThat((Optional)parameters.getSchema()).isEmpty();
    }

    @Test
    public void testAssumeLiteralNamesInMetadataCallsForNonConformingClients() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?assumeLiteralNamesInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isFalse();
    }

    @Test
    public void testAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients() throws SQLException {
        TrinoDriverUri parameters = TestTrinoDriverUri.createDriverUri("jdbc:trino://localhost:8080?assumeLiteralUnderscoreInMetadataCallsForNonConformingClients=true");
        Assertions.assertThat((boolean)parameters.isAssumeLiteralUnderscoreInMetadataCallsForNonConformingClients()).isTrue();
        Assertions.assertThat((boolean)parameters.isAssumeLiteralNamesInMetadataCallsForNonConformingClients()).isFalse();
    }

    private static void assertUriPortScheme(TrinoDriverUri parameters, int port, String scheme) {
        URI uri = parameters.getHttpUri();
        Assert.assertEquals((int)uri.getPort(), (int)port);
        Assert.assertEquals((String)uri.getScheme(), (String)scheme);
    }

    private static TrinoDriverUri createDriverUri(String url) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty("user", "test");
        return TrinoDriverUri.create((String)url, (Properties)properties);
    }

    private static void assertInvalid(String url, String prefix) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestTrinoDriverUri.createDriverUri(url)).isInstanceOf(SQLException.class)).hasMessageStartingWith(prefix);
    }
}

