/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import com.google.common.collect.ImmutableList;
import io.trino.client.ClientSelectedRole;
import io.trino.client.QueryData;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementStats;
import io.trino.jdbc.TrinoResultSet;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTrinoResultSet {
    @Test(timeOut=10000L)
    public void testIteratorCancelWhenQueueNotFull() throws Exception {
        final AtomicReference thread = new AtomicReference();
        final CountDownLatch interruptedButSwallowedLatch = new CountDownLatch(1);
        MockAsyncIterator<Iterable<List<Object>>> iterator = new MockAsyncIterator<Iterable<List<Object>>>(new Iterator<Iterable<List<Object>>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Iterable<List<Object>> next() {
                thread.compareAndSet(null, Thread.currentThread());
                try {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
                catch (InterruptedException e) {
                    interruptedButSwallowedLatch.countDown();
                }
                return ImmutableList.of((Object)ImmutableList.of((Object)new Object()));
            }
        }, new ArrayBlockingQueue(100));
        while (thread.get() == null || ((Thread)thread.get()).getState() != Thread.State.TIMED_WAITING) {
        }
        iterator.cancel();
        while (!iterator.getFuture().isDone() || !iterator.isBackgroundThreadFinished()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        boolean interruptedButSwallowed = interruptedButSwallowedLatch.await(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)interruptedButSwallowed);
    }

    @Test(timeOut=10000L)
    public void testIteratorCancelWhenQueueIsFull() throws Exception {
        ArrayBlockingQueue<ImmutableList> queue = new ArrayBlockingQueue<ImmutableList>(1);
        queue.put(ImmutableList.of());
        final AtomicReference thread = new AtomicReference();
        MockAsyncIterator<Iterable<List<Object>>> iterator = new MockAsyncIterator<Iterable<List<Object>>>(new Iterator<Iterable<List<Object>>>(){

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Iterable<List<Object>> next() {
                thread.compareAndSet(null, Thread.currentThread());
                return ImmutableList.of((Object)ImmutableList.of((Object)new Object()));
            }
        }, queue);
        while (thread.get() == null || ((Thread)thread.get()).getState() != Thread.State.WAITING) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
        iterator.cancel();
        while (!iterator.isBackgroundThreadFinished()) {
            TimeUnit.MILLISECONDS.sleep(10L);
        }
    }

    private static class MockAsyncIterator<T>
    extends TrinoResultSet.AsyncIterator<T> {
        public MockAsyncIterator(Iterator<T> dataIterator, BlockingQueue<T> queue) {
            super(dataIterator, new StatementClient(){

                public String getQuery() {
                    throw new UnsupportedOperationException();
                }

                public ZoneId getTimeZone() {
                    throw new UnsupportedOperationException();
                }

                public boolean isRunning() {
                    throw new UnsupportedOperationException();
                }

                public boolean isClientAborted() {
                    throw new UnsupportedOperationException();
                }

                public boolean isClientError() {
                    throw new UnsupportedOperationException();
                }

                public boolean isFinished() {
                    throw new UnsupportedOperationException();
                }

                public StatementStats getStats() {
                    throw new UnsupportedOperationException();
                }

                public QueryStatusInfo currentStatusInfo() {
                    throw new UnsupportedOperationException();
                }

                public QueryData currentData() {
                    throw new UnsupportedOperationException();
                }

                public QueryStatusInfo finalStatusInfo() {
                    throw new UnsupportedOperationException();
                }

                public Optional<String> getSetCatalog() {
                    throw new UnsupportedOperationException();
                }

                public Optional<String> getSetSchema() {
                    throw new UnsupportedOperationException();
                }

                public Optional<String> getSetPath() {
                    throw new UnsupportedOperationException();
                }

                public Map<String, String> getSetSessionProperties() {
                    throw new UnsupportedOperationException();
                }

                public Set<String> getResetSessionProperties() {
                    throw new UnsupportedOperationException();
                }

                public Map<String, ClientSelectedRole> getSetRoles() {
                    throw new UnsupportedOperationException();
                }

                public Map<String, String> getAddedPreparedStatements() {
                    throw new UnsupportedOperationException();
                }

                public Set<String> getDeallocatedPreparedStatements() {
                    throw new UnsupportedOperationException();
                }

                public String getStartedTransactionId() {
                    throw new UnsupportedOperationException();
                }

                public boolean isClearTransactionId() {
                    throw new UnsupportedOperationException();
                }

                public boolean advance() {
                    throw new UnsupportedOperationException();
                }

                public void cancelLeafStage() {
                    throw new UnsupportedOperationException();
                }

                public void close() {
                }
            }, Optional.of(queue));
        }
    }
}

