/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.guava.collect;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.guava.annotations.Beta;
import io.trino.jdbc.$internal.guava.annotations.GwtCompatible;
import io.trino.jdbc.$internal.guava.collect.ElementTypesAreNonnullByDefault;
import io.trino.jdbc.$internal.guava.collect.ForwardingSet;
import io.trino.jdbc.$internal.guava.collect.ForwardingSortedMap;
import io.trino.jdbc.$internal.javax.annotation.CheckForNull;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    @CheckForNull
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    @.ParametricNullness
    public E first() {
        return this.delegate().first();
    }

    @Override
    public SortedSet<E> headSet(@.ParametricNullness E toElement) {
        return this.delegate().headSet(toElement);
    }

    @Override
    @.ParametricNullness
    public E last() {
        return this.delegate().last();
    }

    @Override
    public SortedSet<E> subSet(@.ParametricNullness E fromElement, @.ParametricNullness E toElement) {
        return this.delegate().subSet(fromElement, toElement);
    }

    @Override
    public SortedSet<E> tailSet(@.ParametricNullness E fromElement) {
        return this.delegate().tailSet(fromElement);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Beta
    protected boolean standardContains(@CheckForNull Object object) {
        try {
            @Nullable ForwardingSortedSet self = this;
            Object ceiling = self.tailSet(object).first();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), ceiling, object) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException e) {
            return false;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    @Beta
    protected boolean standardRemove(@CheckForNull Object object) {
        try {
            @Nullable ForwardingSortedSet self = this;
            Iterator iterator2 = self.tailSet(object).iterator();
            if (iterator2.hasNext()) {
                Object ceiling = iterator2.next();
                if (ForwardingSortedMap.unsafeCompare(this.comparator(), ceiling, object) == 0) {
                    iterator2.remove();
                    return true;
                }
            }
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
        return false;
    }

    @Beta
    protected SortedSet<E> standardSubSet(@.ParametricNullness E fromElement, @.ParametricNullness E toElement) {
        return this.tailSet(fromElement).headSet(toElement);
    }
}

