package io.trino.jdbc.$internal.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;

import io.trino.jdbc.$internal.jackson.core.JsonGenerator;
import io.trino.jdbc.$internal.jackson.core.JsonToken;
import io.trino.jdbc.$internal.jackson.core.type.WritableTypeId;

import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.JsonMappingException;
import io.trino.jdbc.$internal.jackson.databind.JsonNode;
import io.trino.jdbc.$internal.jackson.databind.SerializerProvider;
import io.trino.jdbc.$internal.jackson.databind.annotation.JacksonStdImpl;
import io.trino.jdbc.$internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.trino.jdbc.$internal.jackson.databind.jsontype.TypeSerializer;

/**
 * Simple "bogus" serializer that will just serialize an empty
 * Object for any given value.
 * Quite similar to {@code UnknownSerializer} with the exception that
 * serialization never fails.
 *
 * @since 2.13
 */
@JacksonStdImpl
@SuppressWarnings("serial")
public class ToEmptyObjectSerializer
    extends StdSerializer<Object>
{
    protected ToEmptyObjectSerializer(Class<?> raw) {
        super(raw, false);
    }

    public ToEmptyObjectSerializer(JavaType type) {
        super(type);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider ctxt) throws IOException
    {
        gen.writeStartObject(value, 0);
        gen.writeEndObject();
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen,
            SerializerProvider ctxt, TypeSerializer typeSer) throws IOException
    {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen,
                typeSer.typeId(value, JsonToken.START_OBJECT));
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    /**
     * @deprecated Since 2.15
     */
    @Deprecated
    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint)
            throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor,
            JavaType typeHint)
        throws JsonMappingException
    {
        /*JsonObjectFormatVisitor v =*/ visitor.expectObjectFormat(typeHint);
    }
}
