/*
 * Copyright 2010-2018 JetBrains s.r.o. and Kotlin Programming Language contributors.
 * Use of this source code is governed by the Apache 2.0 license that can be found in the license/LICENSE.txt file.
 */

package io.trino.jdbc.\$internal.kotlin.jvm.internal;

import io.trino.jdbc.\$internal.kotlin.SinceKotlin;
import io.trino.jdbc.\$internal.kotlin.reflect.KCallable;
import io.trino.jdbc.\$internal.kotlin.reflect.KProperty2;

@SuppressWarnings({"unchecked", "rawtypes", "NullableProblems", "unused"})
public abstract class PropertyReference2 extends PropertyReference implements KProperty2 {
    public PropertyReference2() {
        super();
    }

    @SinceKotlin(version = "1.4")
    public PropertyReference2(Class owner, String name, String signature, int flags) {
        super(NO_RECEIVER, owner, name, signature, flags);
    }

    @Override
    protected KCallable computeReflected() {
        return Reflection.property2(this);
    }

    @Override
    public Object invoke(Object receiver1, Object receiver2) {
        return get(receiver1, receiver2);
    }

    @Override
    public KProperty2.Getter getGetter() {
        return ((KProperty2) getReflected()).getGetter();
    }

    @Override
    @SinceKotlin(version = "1.1")
    public Object getDelegate(Object receiver1, Object receiver2) {
        return ((KProperty2) getReflected()).getDelegate(receiver1, receiver2);
    }
}
