/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.client.JsonCodec;
import io.trino.jdbc.$internal.guava.base.MoreObjects;
import io.trino.jdbc.$internal.jackson.core.JsonProcessingException;
import io.trino.jdbc.$internal.okhttp3.Headers;
import io.trino.jdbc.$internal.okhttp3.MediaType;
import io.trino.jdbc.$internal.okhttp3.OkHttpClient;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.okhttp3.ResponseBody;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public final class JsonResponse<T> {
    private final int statusCode;
    private final Headers headers;
    @.Nullable
    private final String responseBody;
    private final boolean hasValue;
    private final T value;
    private final IllegalArgumentException exception;

    private JsonResponse(int statusCode, Headers headers, String responseBody) {
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = Objects.requireNonNull(responseBody, "responseBody is null");
        this.hasValue = false;
        this.value = null;
        this.exception = null;
    }

    private JsonResponse(int statusCode, Headers headers, @.Nullable String responseBody, @.Nullable T value, @.Nullable IllegalArgumentException exception) {
        this.statusCode = statusCode;
        this.headers = Objects.requireNonNull(headers, "headers is null");
        this.responseBody = responseBody;
        this.value = value;
        this.exception = exception;
        this.hasValue = exception == null;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean hasValue() {
        return this.hasValue;
    }

    public T getValue() {
        if (!this.hasValue) {
            throw new IllegalStateException("Response does not contain a JSON value", this.exception);
        }
        return this.value;
    }

    public Optional<String> getResponseBody() {
        return Optional.ofNullable(this.responseBody);
    }

    @.Nullable
    public IllegalArgumentException getException() {
        return this.exception;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("statusCode", this.statusCode).add("headers", this.headers.toMultimap()).add("hasValue", this.hasValue).add("value", this.value).omitNullValues().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> JsonResponse<T> execute(JsonCodec<T> codec, OkHttpClient client, Request request, OptionalLong materializedJsonSizeLimit) {
        try (Response response = client.newCall(request).execute();){
            ResponseBody responseBody = Objects.requireNonNull(response.body());
            if (JsonResponse.isJson(responseBody.contentType())) {
                String body = null;
                T value = null;
                IllegalArgumentException exception = null;
                try {
                    if (materializedJsonSizeLimit.isPresent() && (responseBody.contentLength() < 0L || responseBody.contentLength() > materializedJsonSizeLimit.getAsLong())) {
                        value = codec.fromJson(responseBody.byteStream());
                    } else {
                        body = responseBody.string();
                        value = codec.fromJson(body);
                    }
                }
                catch (JsonProcessingException e) {
                    String message = body != null ? String.format("Unable to create %s from JSON response:\n[%s]", codec.getType(), body) : String.format("Unable to create %s from JSON response", codec.getType());
                    exception = new IllegalArgumentException(message, e);
                }
                JsonResponse<Object> jsonResponse = new JsonResponse<Object>(response.code(), response.headers(), body, value, exception);
                return jsonResponse;
            }
            JsonResponse<T> jsonResponse = new JsonResponse<T>(response.code(), response.headers(), responseBody.string());
            return jsonResponse;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static boolean isJson(MediaType type) {
        return type != null && "application".equals(type.type()) && "json".equals(type.subtype());
    }
}

