/*
 * Copyright (C) 2007 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This package contains generic collection interfaces and implementations, and other utilities for
 * working with collections. It is a part of the open-source <a
 * href="http://github.com/google/guava">Guava</a> library.
 *
 * <h2>Collection Types</h2>
 *
 * <dl>
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.BiMap}
 *   <dd>An extension of {@link java.util.Map} that guarantees the uniqueness of its values as well
 *       as that of its keys. This is sometimes called an "invertible map," since the restriction on
 *       values enables it to support an {@linkplain com.google.common.collect.BiMap#inverse inverse
 *       view} -- which is another instance of {@code BiMap}.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.Multiset}
 *   <dd>An extension of {@link java.util.Collection} that may contain duplicate values like a
 *       {@link java.util.List}, yet has order-independent equality like a {@link java.util.Set}.
 *       One typical use for a multiset is to represent a histogram.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.Multimap}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but may contain multiple entries
 *       with the same key. Some behaviors of {@link io.trino.jdbc.\$internal.guava.collect.Multimap} are left
 *       unspecified and are provided only by the subtypes mentioned below.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.ListMultimap}
 *   <dd>An extension of {@link io.trino.jdbc.\$internal.guava.collect.Multimap} which permits duplicate entries,
 *       supports random access of values for a particular key, and has <i>partially order-dependent
 *       equality</i> as defined by {@link io.trino.jdbc.\$internal.guava.collect.ListMultimap#equals(Object)}.
 *       {@code ListMultimap} takes its name from the fact that the {@linkplain
 *       com.google.common.collect.ListMultimap#get collection of values} associated with a given
 *       key fulfills the {@link java.util.List} contract.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.SetMultimap}
 *   <dd>An extension of {@link io.trino.jdbc.\$internal.guava.collect.Multimap} which has order-independent
 *       equality and does not allow duplicate entries; that is, while a key may appear twice in a
 *       {@code SetMultimap}, each must map to a different value. {@code SetMultimap} takes its name
 *       from the fact that the {@linkplain com.google.common.collect.SetMultimap#get collection of
 *       values} associated with a given key fulfills the {@link java.util.Set} contract.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.SortedSetMultimap}
 *   <dd>An extension of {@link io.trino.jdbc.\$internal.guava.collect.SetMultimap} for which the {@linkplain
 *       com.google.common.collect.SortedSetMultimap#get collection values} associated with a given
 *       key is a {@link java.util.SortedSet}.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.Table}
 *   <dd>A new type, which is similar to {@link java.util.Map}, but which indexes its values by an
 *       ordered pair of keys, a row key and column key.
 *   <dt>{@link io.trino.jdbc.\$internal.guava.collect.ClassToInstanceMap}
 *   <dd>An extension of {@link java.util.Map} that associates a raw type with an instance of that
 *       type.
 * </dl>
 *
 * <h2>Collection Implementations</h2>
 *
 * <h3>of {@link java.util.List}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableList}
 * </ul>
 *
 * <h3>of {@link java.util.Set}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableSet}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableSortedSet}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ContiguousSet} (see {@code Range})
 * </ul>
 *
 * <h3>of {@link java.util.Map}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableSortedMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.MapMaker}
 * </ul>
 *
 * <h3>of {@link io.trino.jdbc.\$internal.guava.collect.BiMap}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableBiMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.HashBiMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.EnumBiMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.EnumHashBiMap}
 * </ul>
 *
 * <h3>of {@link io.trino.jdbc.\$internal.guava.collect.Multiset}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableSortedMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.HashMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.LinkedHashMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.TreeMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.EnumMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ConcurrentHashMultiset}
 * </ul>
 *
 * <h3>of {@link io.trino.jdbc.\$internal.guava.collect.Multimap}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableListMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableSetMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ArrayListMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.HashMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.TreeMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.LinkedHashMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.LinkedListMultimap}
 * </ul>
 *
 * <h3>of {@link io.trino.jdbc.\$internal.guava.collect.Table}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableTable}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ArrayTable}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.HashBasedTable}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.TreeBasedTable}
 * </ul>
 *
 * <h3>of {@link io.trino.jdbc.\$internal.guava.collect.ClassToInstanceMap}</h3>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableClassToInstanceMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.MutableClassToInstanceMap}
 * </ul>
 *
 * <h2>Classes of static utility methods</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Collections2}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Iterators}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Iterables}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Lists}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Maps}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Queues}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Sets}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Multisets}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Multimaps}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Tables}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ObjectArrays}
 * </ul>
 *
 * <h2>Comparison</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Ordering}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ComparisonChain}
 * </ul>
 *
 * <h2>Abstract implementations</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.AbstractIterator}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.AbstractSequentialIterator}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ImmutableCollection}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.UnmodifiableIterator}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.UnmodifiableListIterator}
 * </ul>
 *
 * <h2>Ranges</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Range}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.RangeMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.DiscreteDomain}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ContiguousSet}
 * </ul>
 *
 * <h2>Other</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.Interner}, {@link io.trino.jdbc.\$internal.guava.collect.Interners}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.MapDifference}, {@link
 *       io.trino.jdbc.\$internal.guava.collect.SortedMapDifference}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.MinMaxPriorityQueue}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.PeekingIterator}
 * </ul>
 *
 * <h2>Forwarding collections</h2>
 *
 * <ul>
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingCollection}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingConcurrentMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingIterator}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingList}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingListIterator}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingListMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingMapEntry}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingNavigableMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingNavigableSet}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingObject}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingQueue}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSet}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSetMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSortedMap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSortedMultiset}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSortedSet}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingSortedSetMultimap}
 *   <li>{@link io.trino.jdbc.\$internal.guava.collect.ForwardingTable}
 * </ul>
 */
@CheckReturnValue
@ParametersAreNonnullByDefault
package io.trino.jdbc.\$internal.guava.collect;

import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
