// DO NOT EDIT
// Generated by JFlex 1.8.2 http://jflex.de/
// source: /home/runner/work/opentelemetry-java-instrumentation/opentelemetry-java-instrumentation/instrumentation-api-semconv/src/main/jflex/SqlSanitizer.jflex

/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.db;


// See https://github.com/jflex-de/jflex/issues/222
@SuppressWarnings("FallThrough")
final class AutoSqlSanitizer {

  /** This character denotes the end of file. */
  private static final int YYEOF = -1;

  /** Initial size of the lookahead buffer. */
  private static final int ZZ_BUFFERSIZE = 2048;

  // Lexical states.
  private static final int YYINITIAL = 0;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0, 0
  };

  /**
   * Top-level table for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_TOP = zzUnpackcmap_top();

  private static final String ZZ_CMAP_TOP_PACKED_0 =
    "\1\0\1\u0100\1\u0200\1\u0300\1\u0400\1\u0500\1\u0600\1\u0700"+
    "\1\u0800\1\u0900\1\u0a00\1\u0b00\1\u0c00\1\u0d00\1\u0e00\1\u0f00"+
    "\1\u1000\1\u1100\1\u1200\1\u1300\1\u1400\1\u1100\1\u1500\1\u1600"+
    "\1\u1700\1\u1800\1\u1900\1\u1a00\1\u1b00\1\u1c00\1\u1100\1\u1d00"+
    "\1\u1e00\1\u1f00\12\u2000\1\u2100\1\u2200\1\u2300\1\u2000\1\u2400"+
    "\1\u2500\2\u2000\31\u1100\1\u2600\121\u1100\1\u2700\4\u1100\1\u2800"+
    "\1\u1100\1\u2900\1\u2a00\1\u2b00\1\u2c00\1\u2d00\1\u2e00\53\u1100"+
    "\1\u2f00\41\u2000\1\u1100\1\u3000\1\u3100\1\u1100\1\u3200\1\u3300"+
    "\1\u3400\1\u3500\1\u2000\1\u3600\1\u3700\1\u3800\1\u3900\1\u1100"+
    "\1\u3a00\1\u3b00\1\u3c00\1\u3d00\1\u3e00\1\u3f00\1\u4000\1\u2000"+
    "\1\u4100\1\u4200\1\u4300\1\u4400\1\u4500\1\u4600\1\u4700\1\u4800"+
    "\1\u4900\1\u4a00\1\u4b00\1\u4c00\1\u2000\1\u4d00\1\u4e00\1\u4f00"+
    "\1\u2000\3\u1100\1\u5000\1\u5100\1\u5200\12\u2000\4\u1100\1\u5300"+
    "\17\u2000\2\u1100\1\u5400\41\u2000\2\u1100\1\u5500\1\u5600\2\u2000"+
    "\1\u5700\1\u5800\27\u1100\1\u5900\2\u1100\1\u5a00\45\u2000\1\u1100"+
    "\1\u5b00\1\u5c00\11\u2000\1\u5d00\27\u2000\1\u5e00\1\u5f00\1\u6000"+
    "\1\u6100\11\u2000\1\u6200\1\u6300\5\u2000\1\u6400\1\u6500\4\u2000"+
    "\1\u6600\21\u2000\246\u1100\1\u6700\20\u1100\1\u6800\1\u6900\25\u1100"+
    "\1\u6a00\34\u1100\1\u6b00\14\u2000\2\u1100\1\u6c00\u0e05\u2000";

  private static int [] zzUnpackcmap_top() {
    int [] result = new int[4352];
    int offset = 0;
    offset = zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_top(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Second-level tables for translating characters to character classes
   */
  private static final int [] ZZ_CMAP_BLOCKS = zzUnpackcmap_blocks();

  private static final String ZZ_CMAP_BLOCKS_PACKED_0 =
    "\11\0\2\1\2\0\1\1\22\0\1\1\1\0\1\2"+
    "\1\0\1\3\2\0\1\4\1\5\1\6\1\7\1\10"+
    "\1\11\1\10\1\12\1\13\1\14\11\15\7\0\1\16"+
    "\1\17\1\20\1\21\1\22\1\23\1\24\1\25\1\26"+
    "\1\27\1\25\1\30\1\31\1\32\1\33\1\34\1\25"+
    "\1\35\1\36\1\37\1\40\2\25\1\41\2\25\4\0"+
    "\1\25\1\42\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\25\1\30\1\31\1\32"+
    "\1\33\1\34\1\25\1\35\1\36\1\37\1\40\2\25"+
    "\1\41\2\25\57\0\1\25\12\0\1\25\4\0\1\25"+
    "\5\0\27\25\1\0\37\25\1\0\70\25\2\26\115\25"+
    "\1\36\u0142\25\4\0\14\25\16\0\5\25\7\0\1\25"+
    "\1\0\1\25\201\0\5\25\1\0\2\25\2\0\4\25"+
    "\1\0\1\25\6\0\1\25\1\0\3\25\1\0\1\25"+
    "\1\0\24\25\1\0\123\25\1\0\213\25\10\0\246\25"+
    "\1\0\46\25\2\0\1\25\6\0\51\25\107\0\33\25"+
    "\4\0\4\25\55\0\53\25\43\0\2\25\1\0\143\25"+
    "\1\0\1\25\17\0\2\25\7\0\2\25\12\0\3\25"+
    "\2\0\1\25\20\0\1\25\1\0\36\25\35\0\131\25"+
    "\13\0\1\25\30\0\41\25\11\0\2\25\4\0\1\25"+
    "\5\0\26\25\4\0\1\25\11\0\1\25\3\0\1\25"+
    "\27\0\31\25\7\0\13\25\65\0\25\25\1\0\10\25"+
    "\106\0\66\25\3\0\1\25\22\0\1\25\7\0\12\25"+
    "\17\0\20\25\4\0\10\25\2\0\2\25\2\0\26\25"+
    "\1\0\7\25\1\0\1\25\3\0\4\25\3\0\1\25"+
    "\20\0\1\25\15\0\2\25\1\0\3\25\16\0\2\25"+
    "\12\0\1\25\10\0\6\25\4\0\2\25\2\0\26\25"+
    "\1\0\7\25\1\0\2\25\1\0\2\25\1\0\2\25"+
    "\37\0\4\25\1\0\1\25\23\0\3\25\20\0\11\25"+
    "\1\0\3\25\1\0\26\25\1\0\7\25\1\0\2\25"+
    "\1\0\5\25\3\0\1\25\22\0\1\25\17\0\2\25"+
    "\27\0\1\25\13\0\10\25\2\0\2\25\2\0\26\25"+
    "\1\0\7\25\1\0\2\25\1\0\5\25\3\0\1\25"+
    "\36\0\2\25\1\0\3\25\17\0\1\25\21\0\1\25"+
    "\1\0\6\25\3\0\3\25\1\0\4\25\3\0\2\25"+
    "\1\0\1\25\1\0\2\25\3\0\2\25\3\0\3\25"+
    "\3\0\14\25\26\0\1\25\64\0\10\25\1\0\3\25"+
    "\1\0\27\25\1\0\20\25\3\0\1\25\32\0\3\25"+
    "\5\0\2\25\36\0\1\25\4\0\10\25\1\0\3\25"+
    "\1\0\27\25\1\0\12\25\1\0\5\25\3\0\1\25"+
    "\40\0\1\25\1\0\2\25\17\0\2\25\22\0\10\25"+
    "\1\0\3\25\1\0\51\25\2\0\1\25\20\0\1\25"+
    "\5\0\3\25\10\0\3\25\30\0\6\25\5\0\22\25"+
    "\3\0\30\25\1\0\11\25\1\0\1\25\2\0\7\25"+
    "\72\0\60\25\1\0\2\25\14\0\7\25\72\0\2\25"+
    "\1\0\1\25\1\0\5\25\1\0\30\25\1\0\1\25"+
    "\1\0\12\25\1\0\2\25\11\0\1\25\2\0\5\25"+
    "\1\0\1\25\25\0\4\25\40\0\1\25\77\0\10\25"+
    "\1\0\44\25\33\0\5\25\163\0\53\25\24\0\1\25"+
    "\20\0\6\25\4\0\4\25\3\0\1\25\3\0\2\25"+
    "\7\0\3\25\4\0\15\25\14\0\1\25\21\0\46\25"+
    "\1\0\1\25\5\0\1\25\2\0\53\25\1\0\u014d\25"+
    "\1\0\4\25\2\0\7\25\1\0\1\25\1\0\4\25"+
    "\2\0\51\25\1\0\4\25\2\0\41\25\1\0\4\25"+
    "\2\0\7\25\1\0\1\25\1\0\4\25\2\0\17\25"+
    "\1\0\71\25\1\0\4\25\2\0\103\25\45\0\20\25"+
    "\20\0\126\25\2\0\6\25\3\0\u016c\25\2\0\21\25"+
    "\1\0\32\25\5\0\113\25\6\0\10\25\7\0\15\25"+
    "\1\0\4\25\16\0\22\25\16\0\22\25\16\0\15\25"+
    "\1\0\3\25\17\0\64\25\43\0\1\25\4\0\1\25"+
    "\103\0\131\25\7\0\5\25\2\0\42\25\1\0\1\25"+
    "\5\0\106\25\12\0\37\25\61\0\36\25\2\0\5\25"+
    "\13\0\54\25\4\0\32\25\66\0\27\25\11\0\65\25"+
    "\122\0\1\25\135\0\57\25\21\0\7\25\67\0\36\25"+
    "\15\0\2\25\12\0\54\25\32\0\44\25\51\0\3\25"+
    "\12\0\44\25\2\0\11\25\7\0\53\25\2\0\3\25"+
    "\51\0\4\25\1\0\6\25\1\0\2\25\3\0\1\25"+
    "\5\0\300\25\100\0\26\25\2\0\6\25\2\0\46\25"+
    "\2\0\6\25\2\0\10\25\1\0\1\25\1\0\1\25"+
    "\1\0\1\25\1\0\37\25\2\0\65\25\1\0\7\25"+
    "\1\0\1\25\3\0\3\25\1\0\7\25\3\0\4\25"+
    "\2\0\6\25\4\0\15\25\5\0\3\25\1\0\7\25"+
    "\164\0\1\25\15\0\1\25\20\0\15\25\145\0\1\25"+
    "\4\0\1\25\2\0\12\25\1\0\1\25\3\0\5\25"+
    "\6\0\1\25\1\0\1\25\1\0\1\25\1\0\4\25"+
    "\1\0\13\25\2\0\4\25\5\0\5\25\4\0\1\25"+
    "\64\0\2\25\u017b\0\57\25\1\0\57\25\1\0\205\25"+
    "\6\0\4\25\3\0\2\25\14\0\46\25\1\0\1\25"+
    "\5\0\1\25\2\0\70\25\7\0\1\25\20\0\27\25"+
    "\11\0\7\25\1\0\7\25\1\0\7\25\1\0\7\25"+
    "\1\0\7\25\1\0\7\25\1\0\7\25\1\0\7\25"+
    "\120\0\1\25\325\0\2\25\52\0\5\25\5\0\2\25"+
    "\4\0\126\25\6\0\3\25\1\0\132\25\1\0\4\25"+
    "\5\0\53\25\1\0\136\25\21\0\33\25\65\0\306\25"+
    "\112\0\360\25\20\0\215\25\103\0\56\25\2\0\15\25"+
    "\3\0\20\25\12\0\2\25\24\0\57\25\20\0\37\25"+
    "\2\0\106\25\61\0\11\25\2\0\147\25\2\0\65\25"+
    "\2\0\5\25\60\0\13\25\1\0\3\25\1\0\4\25"+
    "\1\0\27\25\35\0\64\25\16\0\62\25\76\0\6\25"+
    "\3\0\1\25\1\0\2\25\13\0\34\25\12\0\27\25"+
    "\31\0\35\25\7\0\57\25\34\0\1\25\20\0\5\25"+
    "\1\0\12\25\12\0\5\25\1\0\51\25\27\0\3\25"+
    "\1\0\10\25\24\0\27\25\3\0\1\25\3\0\62\25"+
    "\1\0\1\25\3\0\2\25\2\0\5\25\2\0\1\25"+
    "\1\0\1\25\30\0\3\25\2\0\13\25\7\0\3\25"+
    "\14\0\6\25\2\0\6\25\2\0\6\25\11\0\7\25"+
    "\1\0\7\25\1\0\53\25\1\0\14\25\10\0\163\25"+
    "\35\0\244\25\14\0\27\25\4\0\61\25\4\0\156\25"+
    "\2\0\152\25\46\0\7\25\14\0\5\25\5\0\1\25"+
    "\1\0\12\25\1\0\15\25\1\0\5\25\1\0\1\25"+
    "\1\0\2\25\1\0\2\25\1\0\154\25\41\0\153\25"+
    "\22\0\100\25\2\0\66\25\50\0\14\25\164\0\5\25"+
    "\1\0\207\25\44\0\32\25\6\0\32\25\13\0\131\25"+
    "\3\0\6\25\2\0\6\25\2\0\6\25\2\0\3\25"+
    "\43\0\14\25\1\0\32\25\1\0\23\25\1\0\2\25"+
    "\1\0\17\25\2\0\16\25\42\0\173\25\205\0\35\25"+
    "\3\0\61\25\57\0\40\25\15\0\24\25\1\0\10\25"+
    "\6\0\46\25\12\0\36\25\2\0\44\25\4\0\10\25"+
    "\60\0\236\25\22\0\44\25\4\0\44\25\4\0\50\25"+
    "\10\0\64\25\234\0\67\25\11\0\26\25\12\0\10\25"+
    "\230\0\6\25\2\0\1\25\1\0\54\25\1\0\2\25"+
    "\3\0\1\25\2\0\27\25\12\0\27\25\11\0\37\25"+
    "\101\0\23\25\1\0\2\25\12\0\26\25\12\0\32\25"+
    "\106\0\70\25\6\0\2\25\100\0\1\25\17\0\4\25"+
    "\1\0\3\25\1\0\35\25\52\0\35\25\3\0\35\25"+
    "\43\0\10\25\1\0\34\25\33\0\66\25\12\0\26\25"+
    "\12\0\23\25\15\0\22\25\156\0\111\25\67\0\63\25"+
    "\15\0\63\25\15\0\44\25\334\0\35\25\12\0\1\25"+
    "\10\0\26\25\232\0\27\25\14\0\65\25\113\0\55\25"+
    "\40\0\31\25\32\0\44\25\35\0\1\25\13\0\43\25"+
    "\3\0\1\25\14\0\60\25\16\0\4\25\25\0\1\25"+
    "\1\0\1\25\43\0\22\25\1\0\31\25\124\0\7\25"+
    "\1\0\1\25\1\0\4\25\1\0\17\25\1\0\12\25"+
    "\7\0\57\25\46\0\10\25\2\0\2\25\2\0\26\25"+
    "\1\0\7\25\1\0\2\25\1\0\5\25\3\0\1\25"+
    "\22\0\1\25\14\0\5\25\236\0\65\25\22\0\4\25"+
    "\24\0\1\25\40\0\60\25\24\0\2\25\1\0\1\25"+
    "\270\0\57\25\51\0\4\25\44\0\60\25\24\0\1\25"+
    "\73\0\53\25\15\0\1\25\107\0\33\25\345\0\54\25"+
    "\164\0\100\25\37\0\1\25\240\0\10\25\2\0\47\25"+
    "\20\0\1\25\1\0\1\25\34\0\1\25\12\0\50\25"+
    "\7\0\1\25\25\0\1\25\13\0\56\25\23\0\1\25"+
    "\42\0\71\25\7\0\11\25\1\0\45\25\21\0\1\25"+
    "\61\0\36\25\160\0\7\25\1\0\2\25\1\0\46\25"+
    "\25\0\1\25\31\0\6\25\1\0\2\25\1\0\40\25"+
    "\16\0\1\25\u0147\0\23\25\15\0\232\25\346\0\304\25"+
    "\274\0\57\25\321\0\107\25\271\0\71\25\7\0\37\25"+
    "\161\0\36\25\22\0\60\25\20\0\4\25\37\0\25\25"+
    "\5\0\23\25\260\0\100\25\200\0\113\25\5\0\1\25"+
    "\102\0\15\25\100\0\2\25\1\0\1\25\34\0\370\25"+
    "\10\0\363\25\15\0\37\25\61\0\3\25\21\0\4\25"+
    "\10\0\u018c\25\4\0\153\25\5\0\15\25\3\0\11\25"+
    "\7\0\12\25\146\0\125\25\1\0\107\25\1\0\2\25"+
    "\2\0\1\25\2\0\2\25\2\0\4\25\1\0\14\25"+
    "\1\0\1\25\1\0\7\25\1\0\101\25\1\0\4\25"+
    "\2\0\10\25\1\0\7\25\1\0\34\25\1\0\4\25"+
    "\1\0\5\25\1\0\1\25\3\0\7\25\1\0\u0154\25"+
    "\2\0\31\25\1\0\31\25\1\0\37\25\1\0\31\25"+
    "\1\0\37\25\1\0\31\25\1\0\37\25\1\0\31\25"+
    "\1\0\37\25\1\0\31\25\1\0\10\25\64\0\55\25"+
    "\12\0\7\25\20\0\1\25\u0171\0\54\25\24\0\305\25"+
    "\73\0\104\25\7\0\1\25\264\0\4\25\1\0\33\25"+
    "\1\0\2\25\1\0\1\25\2\0\1\25\1\0\12\25"+
    "\1\0\4\25\1\0\1\25\1\0\1\25\6\0\1\25"+
    "\4\0\1\25\1\0\1\25\1\0\1\25\1\0\3\25"+
    "\1\0\2\25\1\0\1\25\2\0\1\25\1\0\1\25"+
    "\1\0\1\25\1\0\1\25\1\0\1\25\1\0\2\25"+
    "\1\0\1\25\2\0\4\25\1\0\7\25\1\0\4\25"+
    "\1\0\4\25\1\0\1\25\1\0\12\25\1\0\21\25"+
    "\5\0\3\25\1\0\5\25\1\0\21\25\104\0\327\25"+
    "\51\0\65\25\13\0\336\25\2\0\u0182\25\16\0\u0131\25"+
    "\37\0\36\25\342\0";

  private static int [] zzUnpackcmap_blocks() {
    int [] result = new int[27904];
    int offset = 0;
    offset = zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackcmap_blocks(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\1\2\3\1\1\3\1\4\2\1\1\5"+
    "\1\1\2\6\12\7\1\1\1\0\1\10\2\0\1\6"+
    "\1\11\1\0\1\12\1\0\11\7\1\0\1\13\1\0"+
    "\1\6\12\7\1\6\1\14\1\7\1\15\1\7\1\16"+
    "\1\17\1\7\1\20\4\7\1\21\2\7\1\22\1\23"+
    "\1\24\1\25";

  private static int [] zzUnpackAction() {
    int [] result = new int[77];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\43\0\106\0\151\0\214\0\257\0\43\0\43"+
    "\0\322\0\365\0\43\0\u0118\0\u013b\0\u015e\0\u0181\0\u01a4"+
    "\0\u01c7\0\u01ea\0\u020d\0\u0230\0\u0253\0\u0276\0\u0299\0\u02bc"+
    "\0\u02df\0\151\0\u0302\0\u0325\0\257\0\u0348\0\43\0\365"+
    "\0\43\0\u036b\0\u038e\0\u03b1\0\u03d4\0\u03f7\0\u041a\0\u043d"+
    "\0\u0460\0\u0483\0\u04a6\0\u02df\0\43\0\u04c9\0\u036b\0\u04ec"+
    "\0\u050f\0\u0532\0\u0555\0\u0578\0\u059b\0\u05be\0\u05e1\0\u0604"+
    "\0\u0627\0\43\0\u0181\0\u064a\0\u0181\0\u066d\0\u0181\0\u0181"+
    "\0\u0690\0\u0181\0\u06b3\0\u06d6\0\u06f9\0\u071c\0\u0181\0\u073f"+
    "\0\u0762\0\u0181\0\u0181\0\u0181\0\u0181";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[77];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\2\1\3\1\4\1\5\1\6\1\7\1\10\1\11"+
    "\1\12\1\13\1\12\1\14\1\15\1\16\2\17\1\20"+
    "\1\21\1\17\1\22\2\17\1\23\1\24\1\17\1\25"+
    "\1\26\3\17\1\27\1\17\1\30\1\17\1\31\44\0"+
    "\1\3\41\0\2\32\1\33\40\32\3\0\1\34\37\0"+
    "\4\35\1\36\36\35\13\0\1\37\37\0\1\40\1\0"+
    "\1\40\1\0\2\16\34\0\1\41\43\0\1\16\1\0"+
    "\1\16\1\0\2\16\4\0\1\16\16\0\1\42\11\0"+
    "\1\16\1\0\1\16\1\0\2\16\4\0\1\16\32\0"+
    "\1\17\1\0\26\17\13\0\1\17\1\0\2\17\1\43"+
    "\23\17\13\0\1\17\1\0\6\17\1\44\17\17\13\0"+
    "\1\17\1\0\21\17\1\45\4\17\13\0\1\17\1\0"+
    "\16\17\1\46\7\17\13\0\1\17\1\0\17\17\1\47"+
    "\6\17\13\0\1\17\1\0\6\17\1\50\17\17\13\0"+
    "\1\17\1\0\6\17\1\51\17\17\13\0\1\17\1\0"+
    "\6\17\1\52\17\17\13\0\1\17\1\0\20\17\1\53"+
    "\5\17\1\0\42\54\1\55\2\0\1\32\40\0\3\34"+
    "\1\56\37\34\4\0\1\35\52\0\10\57\31\0\1\17"+
    "\1\0\14\17\1\60\11\17\13\0\1\17\1\0\14\17"+
    "\1\61\11\17\13\0\1\17\1\0\17\17\1\62\6\17"+
    "\13\0\1\17\1\0\22\17\1\63\1\64\2\17\13\0"+
    "\1\17\1\0\12\17\1\65\13\17\13\0\1\17\1\0"+
    "\21\17\1\66\4\17\13\0\1\17\1\0\25\17\1\67"+
    "\13\0\1\17\1\0\14\17\1\70\11\17\13\0\1\17"+
    "\1\0\5\17\1\71\20\17\4\0\1\72\51\0\1\17"+
    "\1\0\14\17\1\73\11\17\13\0\1\17\1\0\6\17"+
    "\1\74\17\17\13\0\1\17\1\0\15\17\1\75\10\17"+
    "\13\0\1\17\1\0\6\17\1\76\17\17\13\0\1\17"+
    "\1\0\17\17\1\77\6\17\13\0\1\17\1\0\16\17"+
    "\1\100\7\17\13\0\1\17\1\0\10\17\1\101\15\17"+
    "\13\0\1\17\1\0\23\17\1\102\2\17\13\0\1\17"+
    "\1\0\6\17\1\103\17\17\13\0\1\17\1\0\2\17"+
    "\1\104\23\17\13\0\1\17\1\0\23\17\1\105\2\17"+
    "\13\0\1\17\1\0\21\17\1\106\4\17\13\0\1\17"+
    "\1\0\6\17\1\107\17\17\13\0\1\17\1\0\4\17"+
    "\1\110\21\17\13\0\1\17\1\0\23\17\1\111\2\17"+
    "\13\0\1\17\1\0\6\17\1\112\17\17\13\0\1\17"+
    "\1\0\23\17\1\113\2\17\13\0\1\17\1\0\23\17"+
    "\1\114\2\17\13\0\1\17\1\0\6\17\1\115\17\17"+
    "\1\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[1925];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /** Error code for "Unknown internal scanner error". */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  /** Error code for "could not match input". */
  private static final int ZZ_NO_MATCH = 1;
  /** Error code for "pushback value was too large". */
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /**
   * Error messages for {@link #ZZ_UNKNOWN_ERROR}, {@link #ZZ_NO_MATCH}, and
   * {@link #ZZ_PUSHBACK_2BIG} respectively.
   */
  private static final String ZZ_ERROR_MSG[] = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state {@code aState}
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\11\4\1\2\11\2\1\1\11\16\1\1\0"+
    "\1\1\2\0\1\1\1\11\1\0\1\11\1\0\11\1"+
    "\1\0\1\11\1\0\13\1\1\11\23\1";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[77];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** Input device. */
  private java.io.Reader zzReader;

  /** Current state of the DFA. */
  private int zzState;

  /** Current lexical state. */
  private int zzLexicalState = YYINITIAL;

  /**
   * This buffer contains the current text to be matched and is the source of the {@link #yytext()}
   * string.
   */
  private char zzBuffer[] = new char[ZZ_BUFFERSIZE];

  /** Text position at the last accepting state. */
  private int zzMarkedPos;

  /** Current text position in the buffer. */
  private int zzCurrentPos;

  /** Marks the beginning of the {@link #yytext()} string in the buffer. */
  private int zzStartRead;

  /** Marks the last character in the buffer, that has been read from input. */
  private int zzEndRead;

  /**
   * Whether the scanner is at the end of file.
   * @see #yyatEOF
   */
  private boolean zzAtEOF;

  /**
   * The number of occupied positions in {@link #zzBuffer} beyond {@link #zzEndRead}.
   *
   * <p>When a lead/high surrogate has been read from the input stream into the final
   * {@link #zzBuffer} position, this will have a value of 1; otherwise, it will have a value of 0.
   */
  private int zzFinalHighSurrogate = 0;

  /** Number of newlines encountered up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yyline;

  /** Number of characters from the last newline up to the start of the matched text. */
  @SuppressWarnings("unused")
  private int yycolumn;

  /** Number of characters up to the start of the matched text. */
  @SuppressWarnings("unused")
  private long yychar;

  /** Whether the scanner is currently at the beginning of a line. */
  @SuppressWarnings("unused")
  private boolean zzAtBOL = true;

  /** Whether the user-EOF-code has already been executed. */
  @SuppressWarnings("unused")
  private boolean zzEOFDone;

  /* user code: */
  static SqlStatementInfo sanitize(String statement, SqlDialect dialect) {
    AutoSqlSanitizer sanitizer = new AutoSqlSanitizer(new java.io.StringReader(statement));
    sanitizer.dialect = dialect;
    try {
      while (!sanitizer.yyatEOF()) {
        int token = sanitizer.yylex();
        // YYEOF token may be used to stop processing
        if (token == YYEOF) {
          break;
        }
      }
      return sanitizer.getResult();
    } catch (java.io.IOException e) {
      // should never happen
      return SqlStatementInfo.create(null, null, null);
    }
  }

  // max length of the sanitized statement - SQLs longer than this will be trimmed
  static final int LIMIT = 32 * 1024;

  private final StringBuilder builder = new StringBuilder();

  private void appendCurrentFragment() {
    builder.append(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
  }

  private boolean isOverLimit() {
    return builder.length() > LIMIT;
  }

  /** @return text matched by current token without enclosing double quotes or backticks */
  private String readIdentifierName() {
    String identifierName = yytext();
    if (identifierName != null && ((identifierName.startsWith("\"") && identifierName.endsWith("\""))
        || (identifierName.startsWith("`") && identifierName.endsWith("`")))) {
      identifierName = identifierName.substring(1, identifierName.length() - 1);
    }
    return identifierName;
  }

  // you can reference a table in the FROM clause in one of the following ways:
  //   table
  //   table t
  //   table as t
  // in other words, you need max 3 identifiers to reference a table
  private static final int FROM_TABLE_REF_MAX_IDENTIFIERS = 3;

  private int parenLevel = 0;
  private boolean insideComment = false;
  private Operation operation = NoOp.INSTANCE;
  private boolean extractionDone = false;
  private SqlDialect dialect;

  private void setOperation(Operation operation) {
    if (this.operation == NoOp.INSTANCE) {
      this.operation = operation;
    }
  }

  private static abstract class Operation {
    String mainIdentifier = null;

    /** @return true if all statement info is gathered */
    boolean handleFrom() {
      return false;
    }

    /** @return true if all statement info is gathered */
    boolean handleInto() {
      return false;
    }

    /** @return true if all statement info is gathered */
    boolean handleJoin() {
      return false;
    }

    /** @return true if all statement info is gathered */
    boolean handleIdentifier() {
      return false;
    }

    /** @return true if all statement info is gathered */
    boolean handleComma() {
      return false;
    }

    /** @return true if all statement info is gathered */
    boolean handleNext() {
      return false;
     }

    SqlStatementInfo getResult(String fullStatement) {
      return SqlStatementInfo.create(fullStatement, getClass().getSimpleName().toUpperCase(java.util.Locale.ROOT), mainIdentifier);
    }
  }

  private static class NoOp extends Operation {
    static final Operation INSTANCE = new NoOp();

    SqlStatementInfo getResult(String fullStatement) {
      return SqlStatementInfo.create(fullStatement, null, null);
    }
  }

  private class Select extends Operation {
    // you can reference a table in the FROM clause in one of the following ways:
    //   table
    //   table t
    //   table as t
    // in other words, you need max 3 identifiers to reference a table
    private static final int FROM_TABLE_REF_MAX_IDENTIFIERS = 3;

    boolean expectingTableName = false;
    boolean mainTableSetAlready = false;
    int identifiersAfterMainFromClause = 0;

    boolean handleFrom() {
      if (parenLevel == 0) {
        // main query FROM clause
        expectingTableName = true;
        return false;
      }

      // subquery in WITH or SELECT clause, before main FROM clause; skipping
      mainIdentifier = null;
      return true;
    }

    boolean handleJoin() {
      // for SELECT statements with joined tables there's no main table
      mainIdentifier = null;
      return true;
    }

    boolean handleIdentifier() {
      if (identifiersAfterMainFromClause > 0) {
        ++identifiersAfterMainFromClause;
      }

      if (!expectingTableName) {
        return false;
      }

      // SELECT FROM (subquery) case
      if (parenLevel != 0) {
        mainIdentifier = null;
        return true;
      }

      // whenever >1 table is used there is no main table (e.g. unions)
      if (mainTableSetAlready) {
        mainIdentifier = null;
        return true;
      }

      mainIdentifier = readIdentifierName();
      mainTableSetAlready = true;
      expectingTableName = false;
      // start counting identifiers after encountering main from clause
      identifiersAfterMainFromClause = 1;

      // continue scanning the query, there may be more than one table (e.g. joins)
      return false;
    }

    boolean handleComma() {
      // comma was encountered in the FROM clause, i.e. implicit join
      // (if less than 3 identifiers have appeared before first comma then it means that it's a table list;
      // any other list that can appear later needs at least 4 idents)
      if (identifiersAfterMainFromClause > 0
          && identifiersAfterMainFromClause <= FROM_TABLE_REF_MAX_IDENTIFIERS) {
        mainIdentifier = null;
        return true;
      }
      return false;
    }
  }

  private class Insert extends Operation {
    boolean expectingTableName = false;

    boolean handleInto() {
      expectingTableName = true;
      return false;
    }

    boolean handleIdentifier() {
      if (!expectingTableName) {
        return false;
      }

      mainIdentifier = readIdentifierName();
      return true;
    }
  }

  private class Delete extends Operation {
    boolean expectingTableName = false;

    boolean handleFrom() {
      expectingTableName = true;
      return false;
    }

    boolean handleIdentifier() {
      if (!expectingTableName) {
        return false;
      }

      mainIdentifier = readIdentifierName();
      return true;
    }
  }

  private class Update extends Operation {
    boolean handleIdentifier() {
      mainIdentifier = readIdentifierName();
      return true;
    }
  }

  private class Call extends Operation {
    boolean handleIdentifier() {
      mainIdentifier = readIdentifierName();
      return true;
    }

    boolean handleNext() {
      mainIdentifier = null;
      return true;
    }
  }

  private class Merge extends Operation {
    boolean handleIdentifier() {
      mainIdentifier = readIdentifierName();
      return true;
    }
  }

  private SqlStatementInfo getResult() {
    if (builder.length() > LIMIT) {
      builder.delete(LIMIT, builder.length());
    }
    String fullStatement = builder.toString();
    return operation.getResult(fullStatement);
  }



  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  AutoSqlSanitizer(java.io.Reader in) {
    this.zzReader = in;
  }

  /**
   * Translates raw input code points to DFA table row
   */
  private static int zzCMap(int input) {
    int offset = input & 255;
    return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
  }

  /**
   * Refills the input buffer.
   *
   * @return {@code false} iff there was new input.
   * @exception java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (zzStartRead > 0) {
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
      System.arraycopy(zzBuffer, zzStartRead,
                       zzBuffer, 0,
                       zzEndRead - zzStartRead);

      /* translate stored positions */
      zzEndRead -= zzStartRead;
      zzCurrentPos -= zzStartRead;
      zzMarkedPos -= zzStartRead;
      zzStartRead = 0;
    }

    /* is the buffer big enough? */
    if (zzCurrentPos >= zzBuffer.length - zzFinalHighSurrogate) {
      /* if not: blow it up */
      char newBuffer[] = new char[zzBuffer.length * 2];
      System.arraycopy(zzBuffer, 0, newBuffer, 0, zzBuffer.length);
      zzBuffer = newBuffer;
      zzEndRead += zzFinalHighSurrogate;
      zzFinalHighSurrogate = 0;
    }

    /* fill the buffer with new input */
    int requested = zzBuffer.length - zzEndRead;
    int numRead = zzReader.read(zzBuffer, zzEndRead, requested);

    /* not supposed to occur according to specification of java.io.Reader */
    if (numRead == 0) {
      throw new java.io.IOException(
          "Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
    }
    if (numRead > 0) {
      zzEndRead += numRead;
      if (Character.isHighSurrogate(zzBuffer[zzEndRead - 1])) {
        if (numRead == requested) { // We requested too few chars to encode a full Unicode character
          --zzEndRead;
          zzFinalHighSurrogate = 1;
        } else {                    // There is room in the buffer for at least one more char
          int c = zzReader.read();  // Expecting to read a paired low surrogate char
          if (c == -1) {
            return true;
          } else {
            zzBuffer[zzEndRead++] = (char)c;
          }
        }
      }
      /* potentially more input available */
      return false;
    }

    /* numRead < 0 ==> end of stream */
    return true;
  }


  /**
   * Closes the input reader.
   *
   * @throws java.io.IOException if the reader could not be closed.
   */
  private final void yyclose() throws java.io.IOException {
    zzAtEOF = true; // indicate end of file
    zzEndRead = zzStartRead; // invalidate buffer

    if (zzReader != null) {
      zzReader.close();
    }
  }


  /**
   * Resets the scanner to read from a new input stream.
   *
   * <p>Does not close the old reader.
   *
   * <p>All internal variables are reset, the old input stream <b>cannot</b> be reused (internal
   * buffer is discarded and lost). Lexical state is set to {@code ZZ_INITIAL}.
   *
   * <p>Internal scan buffer is resized down to its initial length, if it has grown.
   *
   * @param reader The new input stream.
   */
  private final void yyreset(java.io.Reader reader) {
    zzReader = reader;
    zzEOFDone = false;
    yyResetPosition();
    zzLexicalState = YYINITIAL;
    if (zzBuffer.length > ZZ_BUFFERSIZE) {
      zzBuffer = new char[ZZ_BUFFERSIZE];
    }
  }

  /**
   * Resets the input position.
   */
  private final void yyResetPosition() {
      zzAtBOL  = true;
      zzAtEOF  = false;
      zzCurrentPos = 0;
      zzMarkedPos = 0;
      zzStartRead = 0;
      zzEndRead = 0;
      zzFinalHighSurrogate = 0;
      yyline = 0;
      yycolumn = 0;
      yychar = 0L;
  }


  /**
   * Returns whether the scanner has reached the end of the reader it reads from.
   *
   * @return whether the scanner has reached EOF.
   */
  private final boolean yyatEOF() {
    return zzAtEOF;
  }


  /**
   * Returns the current lexical state.
   *
   * @return the current lexical state.
   */
  private final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state.
   *
   * @param newState the new lexical state
   */
  private final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   *
   * @return the matched text.
   */
  private final String yytext() {
    return new String(zzBuffer, zzStartRead, zzMarkedPos-zzStartRead);
  }


  /**
   * Returns the character at the given position from the matched text.
   *
   * <p>It is equivalent to {@code yytext().charAt(pos)}, but faster.
   *
   * @param position the position of the character to fetch. A value from 0 to {@code yylength()-1}.
   *
   * @return the character at {@code position}.
   */
  private final char yycharat(int position) {
    return zzBuffer[zzStartRead + position];
  }


  /**
   * How many characters were matched.
   *
   * @return the length of the matched text region.
   */
  private final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * <p>In a well-formed scanner (no or only correct usage of {@code yypushback(int)} and a
   * match-all fallback rule) this method will only be called with things that
   * "Can't Possibly Happen".
   *
   * <p>If this method is called, something is seriously wrong (e.g. a JFlex bug producing a faulty
   * scanner etc.).
   *
   * <p>Usual syntax/scanner level error handling should be done in error fallback rules.
   *
   * @param errorCode the code of the error message to display.
   */
  private static void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    } catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * <p>They will be read again by then next call of the scanning method.
   *
   * @param number the number of characters to be read again. This number must not be greater than
   *     {@link #yylength()}.
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }




  /**
   * Resumes scanning until the next regular expression is matched, the end of input is encountered
   * or an I/O-Error occurs.
   *
   * @return the next token.
   * @exception java.io.IOException if any I/O-Error occurs.
   */
  private int yylex() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    char[] zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + zzCMap(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return YYEOF;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 22: break;
          case 2:
            { builder.append(' ');
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 23: break;
          case 3:
            { if (!insideComment) {
            parenLevel += 1;
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 24: break;
          case 4:
            { if (!insideComment) {
            parenLevel -= 1;
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 25: break;
          case 5:
            { if (!insideComment && !extractionDone) {
            extractionDone = operation.handleComma();
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 26: break;
          case 6:
            { builder.append('?');
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 27: break;
          case 7:
            { if (!insideComment && !extractionDone) {
            extractionDone = operation.handleIdentifier();
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 28: break;
          case 8:
            { if (dialect == SqlDialect.COUCHBASE) {
            builder.append('?');
          } else {
            if (!insideComment && !extractionDone) {
              extractionDone = operation.handleIdentifier();
            }
            appendCurrentFragment();
          }
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 29: break;
          case 9:
            { insideComment = false;
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 30: break;
          case 10:
            { insideComment = true;
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 31: break;
          case 11:
            { if (!insideComment && !extractionDone) {
          extractionDone = operation.handleIdentifier();
        }
        appendCurrentFragment();
        if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 32: break;
          case 12:
            { if (!insideComment) {
            setOperation(new Call());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 33: break;
          case 13:
            { if (!insideComment && !extractionDone) {
            if (operation == NoOp.INSTANCE) {
              // hql/jpql queries may skip SELECT and start with FROM clause
              // treat such queries as SELECT queries
              setOperation(new Select());
            }
            extractionDone = operation.handleFrom();
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 34: break;
          case 14:
            { if (!insideComment && !extractionDone) {
            extractionDone = operation.handleInto();
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 35: break;
          case 15:
            { if (!insideComment && !extractionDone) {
            extractionDone = operation.handleJoin();
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 36: break;
          case 16:
            { if (!insideComment && !extractionDone) {
              extractionDone = operation.handleNext();
            }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 37: break;
          case 17:
            { if (!insideComment) {
            setOperation(new Merge());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 38: break;
          case 18:
            { if (!insideComment) {
            setOperation(new Delete());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 39: break;
          case 19:
            { if (!insideComment) {
            setOperation(new Insert());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 40: break;
          case 20:
            { if (!insideComment) {
            setOperation(new Select());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 41: break;
          case 21:
            { if (!insideComment) {
            setOperation(new Update());
          }
          appendCurrentFragment();
          if (isOverLimit()) return YYEOF;
            }
            // fall through
          case 42: break;
          default:
            zzScanError(ZZ_NO_MATCH);
        }
      }
    }
  }


}
