/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.OkHttpAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.OkHttpTelemetry;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.internal.OkHttpNetAttributesGetter;
import java.util.ArrayList;
import java.util.List;

public final class OkHttpTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.okhttp-3.0";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<Request, Response>> additionalExtractors = new ArrayList<AttributesExtractor<Request, Response>>();
    private final HttpClientAttributesExtractorBuilder<Request, Response> httpAttributesExtractorBuilder = HttpClientAttributesExtractor.builder(OkHttpAttributesGetter.INSTANCE, new OkHttpNetAttributesGetter());

    OkHttpTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder addAttributesExtractor(AttributesExtractor<Request, Response> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public OkHttpTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public OkHttpTelemetry build() {
        OkHttpAttributesGetter httpAttributesGetter = OkHttpAttributesGetter.INSTANCE;
        Instrumenter<Request, Response> instrumenter = Instrumenter.builder(this.openTelemetry, INSTRUMENTATION_NAME, HttpSpanNameExtractor.create(httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create(httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addOperationMetrics(HttpClientMetrics.get()).buildInstrumenter(SpanKindExtractor.alwaysClient());
        return new OkHttpTelemetry(instrumenter, this.openTelemetry.getPropagators());
    }
}

