/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.trino.jdbc.$internal.okhttp3.Interceptor;
import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.RequestHeaderSetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.TracingCallFactory;
import java.io.IOException;

final class TracingInterceptor
implements Interceptor {
    private final Instrumenter<Request, Response> instrumenter;
    private final ContextPropagators propagators;

    TracingInterceptor(Instrumenter<Request, Response> instrumenter, ContextPropagators propagators) {
        this.instrumenter = instrumenter;
        this.propagators = propagators;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Context parentContext = TracingCallFactory.getCallingContextForRequest(request);
        if (parentContext == null) {
            parentContext = Context.current();
        }
        if (!this.instrumenter.shouldStart(parentContext, request)) {
            return chain.proceed(chain.request());
        }
        Context context = this.instrumenter.start(parentContext, request);
        request = this.injectContextToRequest(request, context);
        try (Scope ignored = context.makeCurrent();){
            response = chain.proceed(request);
        }
        catch (Exception e) {
            this.instrumenter.end(context, request, null, e);
            throw e;
        }
        this.instrumenter.end(context, request, response, null);
        return response;
    }

    private Request injectContextToRequest(Request request, Context context) {
        Request.Builder requestBuilder = request.newBuilder();
        this.propagators.getTextMapPropagator().inject(context, (Object)requestBuilder, (TextMapSetter)RequestHeaderSetter.INSTANCE);
        return requestBuilder.build();
    }
}

