/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.okhttp.v3_0.internal;

import io.trino.jdbc.$internal.okhttp3.Request;
import io.trino.jdbc.$internal.okhttp3.Response;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import javax.annotation.Nullable;

public final class OkHttpNetAttributesGetter
implements NetClientAttributesGetter<Request, Response> {
    @Override
    public String getTransport(Request request, @Nullable Response response) {
        return "ip_tcp";
    }

    @Override
    @Nullable
    public String getProtocolName(Request request, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        switch (response.protocol()) {
            case HTTP_1_0: 
            case HTTP_1_1: 
            case HTTP_2: {
                return "http";
            }
            case SPDY_3: {
                return "spdy";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getProtocolVersion(Request request, @Nullable Response response) {
        if (response == null) {
            return null;
        }
        switch (response.protocol()) {
            case HTTP_1_0: {
                return "1.0";
            }
            case HTTP_1_1: {
                return "1.1";
            }
            case HTTP_2: {
                return "2.0";
            }
            case SPDY_3: {
                return "3.1";
            }
        }
        return null;
    }

    @Override
    @Nullable
    public String getPeerName(Request request) {
        return request.url().host();
    }

    @Override
    public Integer getPeerPort(Request request) {
        return request.url().port();
    }
}

