/*
 * Copyright The OpenTelemetry Authors
 * SPDX-License-Identifier: Apache-2.0
 */

package io.trino.jdbc.\$internal.opentelemetry.instrumentation.okhttp.v3_0.internal;

import static io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor.alwaysClient;

import io.opentelemetry.api.OpenTelemetry;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.trino.jdbc.\$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import java.util.List;
import java.util.function.Consumer;
import io.trino.jdbc.\$internal.okhttp3.Request;
import io.trino.jdbc.\$internal.okhttp3.Response;

/**
 * This class is internal and is hence not for public use. Its APIs are unstable and can change at
 * any time.
 */
public final class OkHttpInstrumenterFactory {

  private static final String INSTRUMENTATION_NAME = "io.opentelemetry.okhttp-3.0";

  public static Instrumenter<Request, Response> create(
      OpenTelemetry openTelemetry,
      Consumer<HttpClientAttributesExtractorBuilder<Request, Response>> extractorConfigurer,
      List<AttributesExtractor<Request, Response>> additionalAttributesExtractors,
      boolean emitExperimentalHttpClientMetrics) {

    OkHttpAttributesGetter httpAttributesGetter = OkHttpAttributesGetter.INSTANCE;

    HttpClientAttributesExtractorBuilder<Request, Response> extractorBuilder =
        HttpClientAttributesExtractor.builder(httpAttributesGetter);
    extractorConfigurer.accept(extractorBuilder);

    InstrumenterBuilder<Request, Response> builder =
        Instrumenter.<Request, Response>builder(
                openTelemetry,
                INSTRUMENTATION_NAME,
                HttpSpanNameExtractor.create(httpAttributesGetter))
            .setSpanStatusExtractor(HttpSpanStatusExtractor.create(httpAttributesGetter))
            .addAttributesExtractor(extractorBuilder.build())
            .addAttributesExtractors(additionalAttributesExtractors)
            .addOperationMetrics(HttpClientMetrics.get());
    if (emitExperimentalHttpClientMetrics) {
      builder.addOperationMetrics(HttpClientExperimentalMetrics.get());
    }

    return builder.buildInstrumenter(alwaysClient());
  }

  private OkHttpInstrumenterFactory() {}
}
