/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.net;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import java.util.Map;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final Map<String, String> peerServiceMapping;

    PeerServiceAttributesExtractor(ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, Map<String, String> peerServiceMapping) {
        this.attributesGetter = attributesGetter;
        this.peerServiceMapping = peerServiceMapping;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST, RESPONSE> attributesGetter, Map<String, String> peerServiceMapping) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceMapping);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (this.peerServiceMapping.isEmpty()) {
            return;
        }
        String serverAddress = this.attributesGetter.getServerAddress(request);
        String peerService = this.mapToPeerService(serverAddress);
        if (peerService == null) {
            String serverSocketDomain = this.attributesGetter.getServerSocketDomain(request, response);
            peerService = this.mapToPeerService(serverSocketDomain);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, (Object)peerService);
        }
    }

    @Nullable
    private String mapToPeerService(@Nullable String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

