/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.rpc;

import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.semconv.SemanticAttributes;
import io.trino.jdbc.$internal.opentelemetry.extension.incubator.metrics.ExtendedDoubleHistogramBuilder;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.NetworkAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.ArrayList;

final class RpcMetricsAdvice {
    static void applyClientDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(SemanticAttributes.RPC_SYSTEM);
        attributes.add(SemanticAttributes.RPC_SERVICE);
        attributes.add(SemanticAttributes.RPC_METHOD);
        attributes.add(SemanticAttributes.RPC_GRPC_STATUS_CODE);
        if (SemconvStability.emitStableHttpSemconv()) {
            attributes.add(NetworkAttributes.NETWORK_TYPE);
            attributes.add(NetworkAttributes.NETWORK_TRANSPORT);
            attributes.add(NetworkAttributes.SERVER_ADDRESS);
            attributes.add(NetworkAttributes.SERVER_PORT);
            attributes.add(NetworkAttributes.SERVER_SOCKET_ADDRESS);
            attributes.add(NetworkAttributes.SERVER_SOCKET_PORT);
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            attributes.add(SemanticAttributes.NET_PEER_NAME);
            attributes.add(SemanticAttributes.NET_PEER_PORT);
            attributes.add(SemanticAttributes.NET_TRANSPORT);
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAdvice(advice -> advice.setAttributes(attributes));
    }

    static void applyServerDurationAdvice(DoubleHistogramBuilder builder) {
        if (!(builder instanceof ExtendedDoubleHistogramBuilder)) {
            return;
        }
        ArrayList<Object> attributes = new ArrayList<Object>();
        attributes.add(SemanticAttributes.RPC_SYSTEM);
        attributes.add(SemanticAttributes.RPC_SERVICE);
        attributes.add(SemanticAttributes.RPC_METHOD);
        attributes.add(SemanticAttributes.RPC_GRPC_STATUS_CODE);
        if (SemconvStability.emitStableHttpSemconv()) {
            attributes.add(NetworkAttributes.NETWORK_TYPE);
            attributes.add(NetworkAttributes.NETWORK_TRANSPORT);
            attributes.add(NetworkAttributes.SERVER_ADDRESS);
            attributes.add(NetworkAttributes.SERVER_PORT);
            attributes.add(NetworkAttributes.SERVER_SOCKET_ADDRESS);
            attributes.add(NetworkAttributes.SERVER_SOCKET_PORT);
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            attributes.add(SemanticAttributes.NET_HOST_NAME);
            attributes.add(SemanticAttributes.NET_SOCK_HOST_ADDR);
            attributes.add(SemanticAttributes.NET_TRANSPORT);
        }
        ((ExtendedDoubleHistogramBuilder)builder).setAdvice(advice -> advice.setAttributes(attributes));
    }

    private RpcMetricsAdvice() {
    }
}

