/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpMetricsAdvice;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpClientExperimentalMetrics
implements OperationListener {
    private static final ContextKey<Attributes> HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES = ContextKey.named((String)"http-client-experimental-metrics-start-attributes");
    private static final Logger logger = Logger.getLogger(HttpClientExperimentalMetrics.class.getName());
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpClientExperimentalMetrics::new;
    }

    private HttpClientExperimentalMetrics(Meter meter) {
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("http.client.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs();
        HttpMetricsAdvice.applyClientRequestSizeAdvice(requestSizeBuilder);
        this.requestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("http.client.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs();
        HttpMetricsAdvice.applyClientRequestSizeAdvice(responseSizeBuilder);
        this.responseSize = responseSizeBuilder.build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES, (Object)startAttributes);
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        Attributes startAttributes = (Attributes)context.get(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES);
        if (startAttributes == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes sizeAttributes = startAttributes.toBuilder().putAll(endAttributes).build();
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, startAttributes);
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize.longValue(), sizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, startAttributes)) != null) {
            this.responseSize.record(responseBodySize.longValue(), sizeAttributes, context);
        }
    }
}

