/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.semconv.SemanticAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeadersUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.internal.HttpAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

abstract class HttpCommonAttributesExtractor<REQUEST, RESPONSE, GETTER extends HttpCommonAttributesGetter<REQUEST, RESPONSE>>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final GETTER getter;
    private final List<String> capturedRequestHeaders;
    private final List<String> capturedResponseHeaders;
    private final Set<String> knownMethods;

    HttpCommonAttributesExtractor(GETTER getter, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, Set<String> knownMethods) {
        this.getter = getter;
        this.capturedRequestHeaders = CapturedHttpHeadersUtil.lowercase(capturedRequestHeaders);
        this.capturedResponseHeaders = CapturedHttpHeadersUtil.lowercase(capturedResponseHeaders);
        this.knownMethods = new HashSet<String>(knownMethods);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String method = this.getter.getHttpRequestMethod(request);
        if (SemconvStability.emitStableHttpSemconv()) {
            if (method == null || this.knownMethods.contains(method)) {
                AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_REQUEST_METHOD, method);
            } else {
                AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_REQUEST_METHOD, "_OTHER");
                AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL, method);
            }
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_METHOD, method);
        }
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.USER_AGENT_ORIGINAL, this.userAgent(request));
        for (String name : this.capturedRequestHeaders) {
            List<String> values2 = this.getter.getHttpRequestHeader(request, name);
            if (values2.isEmpty()) continue;
            AttributesExtractorUtil.internalSet(attributes, CapturedHttpHeadersUtil.requestAttributeKey(name), values2);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Long requestBodySize = this.requestBodySize(request);
        if (SemconvStability.emitStableHttpSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_REQUEST_BODY_SIZE, requestBodySize);
        }
        if (SemconvStability.emitOldHttpSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, requestBodySize);
        }
        if (response != null) {
            Integer statusCode = this.getter.getHttpResponseStatusCode(request, response, error);
            if (statusCode != null && statusCode > 0) {
                if (SemconvStability.emitStableHttpSemconv()) {
                    AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_RESPONSE_STATUS_CODE, Long.valueOf(statusCode.intValue()));
                }
                if (SemconvStability.emitOldHttpSemconv()) {
                    AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_STATUS_CODE, Long.valueOf(statusCode.intValue()));
                }
            }
            Long responseBodySize = this.responseBodySize(request, response);
            if (SemconvStability.emitStableHttpSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, HttpAttributes.HTTP_RESPONSE_BODY_SIZE, responseBodySize);
            }
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, responseBodySize);
            }
            for (String name : this.capturedResponseHeaders) {
                List<String> values2 = this.getter.getHttpResponseHeader(request, response, name);
                if (values2.isEmpty()) continue;
                AttributesExtractorUtil.internalSet(attributes, CapturedHttpHeadersUtil.responseAttributeKey(name), values2);
            }
        }
    }

    @Nullable
    private String userAgent(REQUEST request) {
        return HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "user-agent"));
    }

    @Nullable
    private Long requestBodySize(REQUEST request) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpRequestHeader(request, "content-length")));
    }

    @Nullable
    private Long responseBodySize(REQUEST request, RESPONSE response) {
        return HttpCommonAttributesExtractor.parseNumber(HttpCommonAttributesExtractor.firstHeaderValue(this.getter.getHttpResponseHeader(request, response, "content-length")));
    }

    @Nullable
    static String firstHeaderValue(List<String> values2) {
        return values2.isEmpty() ? null : values2.get(0);
    }

    @Nullable
    private static Long parseNumber(@Nullable String number) {
        if (number == null) {
            return null;
        }
        try {
            return Long.parseLong(number);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

