/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client.uri;

import io.trino.jdbc.$internal.guava.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public enum PropertyName {
    USER("user"),
    PASSWORD("password"),
    SESSION_USER("sessionUser"),
    ROLES("roles"),
    SOCKS_PROXY("socksProxy"),
    HTTP_PROXY("httpProxy"),
    APPLICATION_NAME_PREFIX("applicationNamePrefix"),
    DISABLE_COMPRESSION("disableCompression"),
    ASSUME_LITERAL_NAMES_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS("assumeLiteralNamesInMetadataCallsForNonConformingClients"),
    ASSUME_LITERAL_UNDERSCORE_IN_METADATA_CALLS_FOR_NON_CONFORMING_CLIENTS("assumeLiteralUnderscoreInMetadataCallsForNonConformingClients"),
    SSL("SSL"),
    SSL_VERIFICATION("SSLVerification"),
    SSL_KEY_STORE_PATH("SSLKeyStorePath"),
    SSL_KEY_STORE_PASSWORD("SSLKeyStorePassword"),
    SSL_KEY_STORE_TYPE("SSLKeyStoreType"),
    SSL_TRUST_STORE_PATH("SSLTrustStorePath"),
    SSL_TRUST_STORE_PASSWORD("SSLTrustStorePassword"),
    SSL_TRUST_STORE_TYPE("SSLTrustStoreType"),
    SSL_USE_SYSTEM_TRUST_STORE("SSLUseSystemTrustStore"),
    KERBEROS_SERVICE_PRINCIPAL_PATTERN("KerberosServicePrincipalPattern"),
    KERBEROS_REMOTE_SERVICE_NAME("KerberosRemoteServiceName"),
    KERBEROS_USE_CANONICAL_HOSTNAME("KerberosUseCanonicalHostname"),
    KERBEROS_PRINCIPAL("KerberosPrincipal"),
    KERBEROS_CONFIG_PATH("KerberosConfigPath"),
    KERBEROS_KEYTAB_PATH("KerberosKeytabPath"),
    KERBEROS_CREDENTIAL_CACHE_PATH("KerberosCredentialCachePath"),
    KERBEROS_DELEGATION("KerberosDelegation"),
    KERBEROS_CONSTRAINED_DELEGATION("KerberosConstrainedDelegation"),
    ACCESS_TOKEN("accessToken"),
    EXTERNAL_AUTHENTICATION("externalAuthentication"),
    EXTERNAL_AUTHENTICATION_TIMEOUT("externalAuthenticationTimeout"),
    EXTERNAL_AUTHENTICATION_REDIRECT_HANDLERS("externalAuthenticationRedirectHandlers"),
    EXTERNAL_AUTHENTICATION_TOKEN_CACHE("externalAuthenticationTokenCache"),
    EXTRA_CREDENTIALS("extraCredentials"),
    CLIENT_INFO("clientInfo"),
    CLIENT_TAGS("clientTags"),
    TRACE_TOKEN("traceToken"),
    SESSION_PROPERTIES("sessionProperties"),
    SOURCE("source"),
    DNS_RESOLVER("dnsResolver"),
    DNS_RESOLVER_CONTEXT("dnsResolverContext"),
    HOSTNAME_IN_CERTIFICATE("hostnameInCertificate"),
    TIMEZONE("timezone"),
    CATALOG("catalog"),
    SCHEMA("schema");

    private final String key;
    private static final Map<String, PropertyName> lookup;

    private PropertyName(String key) {
        this.key = key;
    }

    public String toString() {
        return this.key;
    }

    public static Optional<PropertyName> findByKey(String key) {
        return Optional.ofNullable(lookup.get(key));
    }

    static {
        lookup = Arrays.stream(PropertyName.values()).collect(ImmutableMap.toImmutableMap(PropertyName::toString, Function.identity()));
    }
}

