/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributeKey;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

final class CapturedHttpHeadersUtil {
    private static final ConcurrentMap<String, AttributeKey<List<String>>> oldSemconvRequestKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private static final ConcurrentMap<String, AttributeKey<List<String>>> stableSemconvRequestKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private static final ConcurrentMap<String, AttributeKey<List<String>>> oldSemconvResponseKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();
    private static final ConcurrentMap<String, AttributeKey<List<String>>> stableSemconvResponseKeysCache = new ConcurrentHashMap<String, AttributeKey<List<String>>>();

    static List<String> lowercase(List<String> names) {
        return Collections.unmodifiableList(names.stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toList()));
    }

    static AttributeKey<List<String>> oldSemconvRequestAttributeKey(String headerName) {
        return oldSemconvRequestKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createOldSemconvKey("request", n));
    }

    static AttributeKey<List<String>> stableSemconvRequestAttributeKey(String headerName) {
        return stableSemconvRequestKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createStableSemconvKey("request", n));
    }

    static AttributeKey<List<String>> oldSemconvResponseAttributeKey(String headerName) {
        return oldSemconvResponseKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createOldSemconvKey("response", n));
    }

    static AttributeKey<List<String>> stableSemconvResponseAttributeKey(String headerName) {
        return stableSemconvResponseKeysCache.computeIfAbsent(headerName, n -> CapturedHttpHeadersUtil.createStableSemconvKey("response", n));
    }

    private static AttributeKey<List<String>> createOldSemconvKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName.replace('-', '_');
        return AttributeKey.stringArrayKey((String)key);
    }

    private static AttributeKey<List<String>> createStableSemconvKey(String type, String headerName) {
        String key = "http." + type + ".header." + headerName;
        return AttributeKey.stringArrayKey((String)key);
    }

    private CapturedHttpHeadersUtil() {
    }
}

