/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.context.Context;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HostAddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.http.HttpClientRequestResendCount;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.net.internal.InternalNetClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalNetworkAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.network.internal.ServerAddressAndPortExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.HttpConstants;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.internal.SemconvStability;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public final class HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter;
    final NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter;
    final AddressAndPortExtractor<REQUEST> serverAddressAndPortExtractor;
    List<String> capturedRequestHeaders = Collections.emptyList();
    List<String> capturedResponseHeaders = Collections.emptyList();
    Set<String> knownMethods = HttpConstants.KNOWN_METHODS;
    ToIntFunction<Context> resendCountIncrementer = HttpClientRequestResendCount::getAndIncrement;

    HttpClientAttributesExtractorBuilder(HttpClientAttributesGetter<REQUEST, RESPONSE> httpAttributesGetter, NetClientAttributesGetter<REQUEST, RESPONSE> netAttributesGetter) {
        this.httpAttributesGetter = httpAttributesGetter;
        this.netAttributesGetter = netAttributesGetter;
        this.serverAddressAndPortExtractor = new ServerAddressAndPortExtractor<REQUEST>(netAttributesGetter, new HostAddressAndPortExtractor<REQUEST>(httpAttributesGetter));
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedRequestHeaders(List<String> requestHeaders) {
        this.capturedRequestHeaders = new ArrayList<String>(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setCapturedResponseHeaders(List<String> responseHeaders) {
        this.capturedResponseHeaders = new ArrayList<String>(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setKnownMethods(Set<String> knownMethods) {
        this.knownMethods = new HashSet<String>(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    HttpClientAttributesExtractorBuilder<REQUEST, RESPONSE> setResendCountIncrementer(ToIntFunction<Context> resendCountIncrementer) {
        this.resendCountIncrementer = resendCountIncrementer;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new HttpClientAttributesExtractor(this);
    }

    InternalNetClientAttributesExtractor<REQUEST, RESPONSE> buildNetExtractor() {
        return new InternalNetClientAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, this.serverAddressAndPortExtractor, SemconvStability.emitOldHttpSemconv());
    }

    InternalNetworkAttributesExtractor<REQUEST, RESPONSE> buildNetworkExtractor() {
        return new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(this.netAttributesGetter, this.serverAddressAndPortExtractor, false, false, true, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv());
    }

    InternalServerAttributesExtractor<REQUEST> buildServerExtractor() {
        return new InternalServerAttributesExtractor<REQUEST>(this.serverAddressAndPortExtractor, SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), InternalServerAttributesExtractor.Mode.PEER);
    }
}

